/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;

public class ReceiptUtil {
    private static final String TO_RECEIVE = "toReceive";
    private static final String[] VALID_PRO = new String[]{"warehouse", "location", "lot", "project", "trace", "unit", "basicUnit", "note"};

    public static String getBotpRule(List<DynamicObject> list, String targetBillType) {
        Map<String, Object> billInfoMap = ReceiptUtil.getBillIdInfo(list);
        String rules = "";
        if (billInfoMap.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            billInfoMap.put("targetBillType", targetBillType);
            param.put("data", billInfoMap);
            param.put("code", "200");
            rules = ApiUtil.botpQuery(param);
        }
        return rules;
    }

    public static Map<String, Object> getBillIdInfo(List<DynamicObject> list) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        if (list.size() == 0) {
            return dataMap;
        }
        HashSet<String> entryIdSet = new HashSet<String>();
        HashSet<String> billIdSet = new HashSet<String>();
        for (DynamicObject entry : list) {
            String srcEntryId = String.valueOf(entry.get("poentryid"));
            if (null == srcEntryId || srcEntryId.trim().length() <= 0) continue;
            entryIdSet.add(srcEntryId);
            String billId = String.valueOf(entry.get("pobillid"));
            billIdSet.add(billId);
        }
        dataMap.put("billId", billIdSet);
        dataMap.put("entryId", entryIdSet);
        return dataMap;
    }

    public static String toRecive(List<DynamicObject> list, String botpNumber, String index) {
        String msg = null;
        Map<String, Object> billInfoMap = ReceiptUtil.getBillInfo(list, index);
        if (billInfoMap.size() > 0) {
            billInfoMap.put("botpNumber", botpNumber);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tobilltype", "receive");
            param.put("billtype", "pur_outstock");
            param.put("data", billInfoMap);
            param.put("action", TO_RECEIVE);
            param.put("code", "200");
            msg = ApiUtil.purSaloutToRec(param);
        }
        return msg;
    }

    public static Map<String, Object> getBillInfo(List<DynamicObject> list, String index) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        for (DynamicObject entry : list) {
            HashMap<String, Object> detailMap = new HashMap<String, Object>();
            Object srcEntryId = entry.get("poentryid" + index);
            if (srcEntryId == null || srcEntryId.toString().trim().isEmpty()) continue;
            for (String property : VALID_PRO) {
                Object val = entry.get(property + index);
                if (null == val) {
                    detailMap.put(property, "");
                    continue;
                }
                if (val instanceof DynamicObject) {
                    Object number = DynamicObjectUtil.getBDNumberOfValue((DynamicObject)((DynamicObject)val));
                    detailMap.put(property, number);
                    continue;
                }
                detailMap.put(property, val);
            }
            BigDecimal recieveQty = CommonUtil.getBigDecimalPro((Object)entry.get("receiveqty" + index));
            String entryIdStr = entry.getString("entryid" + index);
            String billIdStr = entry.getString("billid" + index);
            detailMap.put("entryId", srcEntryId);
            detailMap.put("billid", entry.get("pobillid" + index));
            detailMap.put("qty", recieveQty);
            detailMap.put("srcEntryId", entryIdStr);
            detailMap.put("srcBillId", billIdStr);
            dataMap.put(entryIdStr, detailMap);
        }
        return ReceiptUtil.groupDataBySrcBillId(dataMap);
    }

    public static Map<String, Object> groupDataBySrcBillId(Map<String, Object> dataMap) {
        HashMap<String, Object> groupedData = new HashMap<String, Object>();
        dataMap.forEach((key, val) -> {
            Map data = (Map)val;
            String srcBillId = String.valueOf(data.get("srcBillId"));
            ArrayList<Map> list = (ArrayList<Map>)groupedData.get(srcBillId);
            if (list == null) {
                list = new ArrayList<Map>();
            }
            list.add(data);
            groupedData.put(srcBillId, list);
        });
        return groupedData;
    }

    public static List<DynamicObject> getAvailableData(List<DynamicObject> list, String index) {
        ArrayList<DynamicObject> availableData = new ArrayList<DynamicObject>(list.size());
        HashMap<Long, DynamicObject> salOutEntryIdOfData = new HashMap<Long, DynamicObject>(list.size());
        for (DynamicObject entry : list) {
            String entryid = entry.getString("entryid" + index);
            if (entryid == null || entryid.isEmpty()) continue;
            salOutEntryIdOfData.put(Long.parseLong(entryid), entry);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"scp_saloutstock", (String)"id,materialentry.id entryid,materialentry.qty qty,materialentry.sumreceiptqty sumreceiptqty,materialentry.suminstockqty suminstockqty", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", salOutEntryIdOfData.keySet())}, (String)"id");){
            while (dataSet.hasNext()) {
                BigDecimal suminstockqty;
                Row row = dataSet.next();
                String entryid = row.getString("entryid");
                DynamicObject verifyData = (DynamicObject)salOutEntryIdOfData.get(Long.parseLong(entryid));
                if (verifyData == null) continue;
                BigDecimal qty = row.getBigDecimal("qty");
                BigDecimal receiveqty = verifyData.getBigDecimal("receiveqty" + index);
                BigDecimal currencyQty = BigDecimal.ZERO;
                BigDecimal sumreceiptqty = row.getBigDecimal("sumreceiptqty");
                currencyQty = sumreceiptqty.compareTo(suminstockqty = row.getBigDecimal("suminstockqty")) >= 0 ? qty.subtract(sumreceiptqty) : qty.subtract(suminstockqty);
                if (currencyQty.compareTo(BigDecimal.ZERO) == 0) continue;
                if (currencyQty.compareTo(receiveqty) >= 0) {
                    availableData.add(verifyData);
                    continue;
                }
                verifyData.set("receiveqty" + index, (Object)currencyQty);
                availableData.add(verifyData);
            }
        }
        return availableData;
    }
}

