/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.blueprintshare.support;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pur.common.blueprintshare.support.VersionComparator;
import kd.scm.pur.common.constant.PurBlueprintShareConstant;

public class PurBluePrintSortSupport {
    public void setMaxVersionTag(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        HashMap<String, DynamicObject> versionToBluePrintMap = new HashMap<String, DynamicObject>(dynamicObjects.length);
        ArrayList<String> versions = new ArrayList<String>(dynamicObjects.length);
        for (DynamicObject object : dynamicObjects) {
            String versionString = object.getString("version");
            versions.add(versionString);
            versionToBluePrintMap.put(versionString, object);
        }
        versions.sort(new VersionComparator());
        String maxVersion = (String)versions.get(versions.size() - 1);
        DynamicObject maxBluePrint = (DynamicObject)versionToBluePrintMap.get(maxVersion);
        maxBluePrint.set("islatestversion", (Object)true);
    }

    public DynamicObject[] queryGroupDataByMaterielIdAndCreateOrgIdAudit(Long materielId, Long createOrgId) {
        String queryParma = PurBlueprintShareConstant.buildQueryParma("islatestversion", "sort", "version");
        return BusinessDataServiceHelper.load((String)"pur_blueprint_share", (String)queryParma, (QFilter[])new QFilter[]{new QFilter("createorg.id", "=", (Object)createOrgId).and("materiel.id", "=", (Object)materielId).and("status", "=", (Object)"C")});
    }

    public DynamicObject[] queryGroupDataByMaterielIdAndCreateOrgId(Long materielId, Long createOrgId) {
        String queryParma = PurBlueprintShareConstant.buildQueryParma("islatestversion", "sort", "version", "status");
        return BusinessDataServiceHelper.load((String)"pur_blueprint_share", (String)queryParma, (QFilter[])new QFilter[]{new QFilter("createorg.id", "=", (Object)createOrgId).and("materiel.id", "=", (Object)materielId)});
    }

    public String queryLatestVersionByOrgAndMateriel(Long createOrgId, Long materielId) {
        DynamicObject latestVersionObject = QueryServiceHelper.queryOne((String)"pur_blueprint_share", (String)"version", (QFilter[])new QFilter[]{new QFilter("createorg.id", "=", (Object)createOrgId).and("materiel.id", "=", (Object)materielId).and("islatestversion", "=", (Object)true)});
        if (latestVersionObject == null) {
            return "";
        }
        return latestVersionObject.getString("version");
    }
}

