/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.ecinvoice;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.pur.common.ecinvoice.service.impl.CgEcInvoiceService;
import kd.scm.pur.common.ecinvoice.service.impl.DlEcInvoiceService;
import kd.scm.pur.common.ecinvoice.service.impl.GenericEcInvoiceService;
import kd.scm.pur.common.ecinvoice.service.impl.JdEcInvoiceService;
import kd.scm.pur.common.ecinvoice.service.impl.JdProEcInvoiceService;
import kd.scm.pur.common.ecinvoice.service.impl.SnEcInvoiceService;
import kd.scm.pur.common.ecinvoice.service.impl.XyEcInvoiceService;
import kd.scm.pur.common.ecinvoice.service.impl.ZkhEcInvoiceService;

public class EcInvoiceFactory {
    private static final Map<String, GenericEcInvoiceService> serviceMap = new ConcurrentHashMap<String, GenericEcInvoiceService>();

    public static GenericEcInvoiceService getEcInvoiceServiceBySource(String source) {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return new GenericEcInvoiceService();
        }
        GenericEcInvoiceService invoiceService = serviceMap.get(source);
        if (invoiceService != null) {
            return invoiceService;
        }
        int sourceNum = Integer.parseInt(source);
        switch (sourceNum) {
            case 2: {
                invoiceService = new JdEcInvoiceService();
                break;
            }
            case 3: {
                invoiceService = new SnEcInvoiceService();
                break;
            }
            case 4: {
                invoiceService = new DlEcInvoiceService();
                break;
            }
            case 5: {
                invoiceService = new XyEcInvoiceService();
                break;
            }
            case 6: {
                invoiceService = new CgEcInvoiceService();
                break;
            }
            case 7: {
                invoiceService = new JdProEcInvoiceService();
                break;
            }
            case 9: {
                invoiceService = new ZkhEcInvoiceService();
                break;
            }
            default: {
                invoiceService = new GenericEcInvoiceService();
            }
        }
        serviceMap.put(source, invoiceService);
        return invoiceService;
    }
}

