/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.ecinvoice.service.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.entity.EmalStatus;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.JDAccessTokenUtil;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.ApiResult;
import kd.scm.common.helper.apiconnector.api.parser.JdApiParser;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.common.jd.util.JDHttpsUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JDOrderUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.pur.common.ecinvoice.beans.EcConfirmInfo;
import kd.scm.pur.common.ecinvoice.beans.EcConfirmRecParam;
import kd.scm.pur.common.ecinvoice.beans.EcInvSubmitParam;
import kd.scm.pur.common.ecinvoice.beans.EcInvSubmitResult;
import kd.scm.pur.common.ecinvoice.beans.EcInvoiceInfo;
import kd.scm.pur.common.ecinvoice.beans.EcInvoiceSkuDetail;
import kd.scm.pur.common.ecinvoice.exception.KDEcInvoiceException;
import kd.scm.pur.common.ecinvoice.service.impl.GenericEcInvoiceService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class JdEcInvoiceService
extends GenericEcInvoiceService {
    private static final Log log = LogFactory.getLog((String)JdEcInvoiceService.class.getName());

    @Override
    public EcInvSubmitParam packageEcSubmitParam(IDataModel model, DynamicObjectCollection reportDyoCol) {
        EcInvSubmitParam ecInvSubmitParam = super.packageEcSubmitParam(model, reportDyoCol);
        BigDecimal invoiceAmount = this.getInvoiceAmount(reportDyoCol);
        String ecAddressNum = AddressUtil.getLongNumber((Long)Long.parseLong(model.getValue("revaddress").toString()), (String)this.getPlatform());
        String[] ecAddress = this.getEcAddress(ecAddressNum);
        if (ecAddress == null || ecAddress.length < 3) {
            ecAddressNum = (String)model.getValue("jdaddressnum");
            String[] stringArray = ecAddress = ecAddressNum == null ? null : ecAddressNum.split("_");
        }
        if (ecAddress == null || ecAddress.length < 3) {
            log.error("@@\u5730\u5740\u7f16\u7801\uff1a" + ecAddressNum);
            throw new KDEcInvoiceException(ResManager.loadKDString((String)"\u4eac\u4e1c\u5f00\u7968\u5730\u5740\u6709\u8bef\u3002", (String)"JdEcInvoiceService_0", (String)"scm-pur-common", (Object[])new Object[0]));
        }
        int billToProvinceId = 0;
        int billToCityId = 1;
        int billToCountyId = 2;
        int billToTownId = 3;
        ecInvSubmitParam.setBillToProvince(ecAddress[billToProvinceId]);
        ecInvSubmitParam.setBillToCity(ecAddress[billToCityId]);
        ecInvSubmitParam.setBillToCounty(ecAddress[billToCountyId]);
        if (ecAddress.length == 4) {
            ecInvSubmitParam.setBillToTown(ecAddress[billToTownId]);
        }
        ecInvSubmitParam.setSettlementId(ecInvSubmitParam.getMarkId());
        ecInvSubmitParam.setInvoiceOrg(this.getInvoiceOrgCode());
        ecInvSubmitParam.setInvoiceDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        ecInvSubmitParam.setInvoiceNum(String.valueOf(reportDyoCol.size()));
        String invAmountStr = invoiceAmount.toPlainString();
        ecInvSubmitParam.setInvoicePrice(invAmountStr);
        ecInvSubmitParam.setCurrentBatch("1");
        ecInvSubmitParam.setTotalBatch("1");
        ecInvSubmitParam.setTotalBatchInvoiceAmount(invAmountStr);
        return ecInvSubmitParam;
    }

    @Override
    public EcInvSubmitResult doSubmit(EcInvSubmitParam ecInvSubmitParam) {
        if (MalOrderUtil.getDefaultMalVersion()) {
            log.info("@@ecInvSubmitParam:" + ecInvSubmitParam);
            Map<String, Object> paramMap = ecInvSubmitParam.covertToApiParamMap();
            String token = JDAccessTokenUtil.getValidToken((String)ecInvSubmitParam.getTitleId(), (String)this.getPlatform());
            if (StringUtils.isNotBlank((CharSequence)token)) {
                ((Map)paramMap.get(this.getPlatform())).put("token", token);
            }
            Map res = EcGroupApiUtil.addInvoice(paramMap);
            log.info("@@res:" + res);
            return this.parseResult(ecInvSubmitParam, res);
        }
        EcInvSubmitResult ecInvSubmitResult = new EcInvSubmitResult();
        String data = ecInvSubmitParam.covertToJdUrlParam();
        log.info("@@@invoiceSubmit\u7533\u8bf7\u5f00\u7968data\uff1a" + data);
        String json = JDHttpsUtil.httpsJDPost((String)"https://bizapi.jd.com/api/invoice/submit", (String)data);
        log.info("@@@\u8c03\u7528\u7533\u8bf7\u5f00\u7968\u63a5\u53e3\u7ed3\u679c\uff1a" + json);
        JSONObject node = JSONObject.fromObject((Object)json);
        if (node.getBoolean("success")) {
            String code;
            switch (code = node.getString("resultCode")) {
                case "2007": 
                case "3304": 
                case "5002": 
                case "3302": {
                    ecInvSubmitResult.setSuccess(false);
                    break;
                }
                default: {
                    ecInvSubmitResult.setSuccess(true);
                    break;
                }
            }
        } else {
            ecInvSubmitResult.setSuccess(false);
        }
        if (ecInvSubmitResult.isSuccess()) {
            ecInvSubmitResult.setInvoiceState(PurEcInvoiceEnum.HANDLING.getVal());
            ecInvSubmitResult.setMarkId(ecInvSubmitParam.getMarkId());
            ecInvSubmitResult.setEcOrderIds(new HashSet<String>(Arrays.asList(ecInvSubmitParam.getSupplierOrder().split(","))));
        } else {
            ecInvSubmitResult.setInvoiceState(PurEcInvoiceEnum.INVOICEFAILED.getVal());
            ecInvSubmitResult.setMarkId(ecInvSubmitParam.getMarkId());
            ecInvSubmitResult.setEcOrderIds(new HashSet<String>(Arrays.asList(ecInvSubmitParam.getSupplierOrder().split(","))));
            ArrayList<String> errInfos = new ArrayList<String>();
            errInfos.add(String.valueOf(node.get("resultMessage")));
            ecInvSubmitResult.setErrorInfo(errInfos);
        }
        ecInvSubmitResult.setPlatform(this.getPlatform());
        return ecInvSubmitResult;
    }

    @Override
    protected EcInvSubmitResult parseResult(EcInvSubmitParam ecInvSubmitParam, Map<String, Map<String, Object>> res) {
        EcInvSubmitResult ecInvSubmitResult = super.parseResult(ecInvSubmitParam, res);
        Map<String, Object> resultMap = res.get(this.getPlatform());
        ecInvSubmitResult.setSuccess((Boolean)resultMap.get("success"));
        if (ecInvSubmitResult.isSuccess()) {
            ecInvSubmitResult.setInvoiceState(PurEcInvoiceEnum.HANDLING.getVal());
        } else {
            ecInvSubmitResult.setInvoiceState(PurEcInvoiceEnum.INVOICEFAILED.getVal());
            ArrayList<String> errorInfos = new ArrayList<String>();
            errorInfos.add(this.now() + ":" + resultMap.get("resultMessage"));
            ecInvSubmitResult.setErrorInfo(errorInfos);
        }
        ecInvSubmitResult.setPlatform(this.getPlatform());
        return ecInvSubmitResult;
    }

    @Override
    public void repaireData(IFormView view) {
        DynamicObject dynamicObject;
        String jdOrderId;
        DynamicObjectCollection dyoCol = this.getSelectedDyObject(view);
        if (null != dyoCol && dyoCol.size() == 1 && StringUtils.isNotBlank((CharSequence)(jdOrderId = ((DynamicObject)dyoCol.get(0)).getString("jdchildorderid"))) && null != (dynamicObject = this.getJdOrder(((DynamicObject)dyoCol.get(0)).getString("jdchildorderid"))) && dynamicObject.getString("number").equals(dynamicObject.getString("jdorderid"))) {
            String token = JDAccessTokenUtil.getAccessTokenByKD((String)RequestContext.get().getTenantId());
            Map childJdOrderIdMap = JDOrderUtil.getJdChildOrderIdMap((String)token, (String)jdOrderId);
            String remittanceCode = JdApiUtil.selectRemittanceCode((int)2, (int)0, (String)jdOrderId, (int)0, (int)1, (String)"", (int)0, (BigDecimal)dynamicObject.getBigDecimal("taxamount"));
            Map<String, Long> numberJdOrderIdMap = this.getNumberJdOrderIdMap(childJdOrderIdMap, remittanceCode, dynamicObject);
            QFilter filter = new QFilter("jdorderid", "=", (Object)jdOrderId);
            DynamicObject malOrder = BusinessDataServiceHelper.loadSingle((String)"mal_order", (String)"entryentity,entryentity.goods,entryentity.jdorder", (QFilter[])new QFilter[]{filter});
            DynamicObjectCollection maColl = malOrder.getDynamicObjectCollection("entryentity");
            for (DynamicObject coll : maColl) {
                if (Boolean.parseBoolean((String)childJdOrderIdMap.get("isHasChildOrder"))) {
                    coll.set("jdorder", (Object)numberJdOrderIdMap.get(((DynamicObject)coll.get("goods")).get("number")));
                    continue;
                }
                coll.set("jdorder", (Object)numberJdOrderIdMap.get("jdorder"));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{malOrder});
            DynamicObject purOrder = BusinessDataServiceHelper.loadSingle((String)"pur_order", (String)"materialentry,materialentry.goods,materialentry.jdorder", (QFilter[])new QFilter[]{filter});
            DynamicObjectCollection purColl = purOrder.getDynamicObjectCollection("materialentry");
            for (DynamicObject coll : purColl) {
                if (Boolean.parseBoolean((String)childJdOrderIdMap.get("isHasChildOrder"))) {
                    coll.set("jdorder", (Object)numberJdOrderIdMap.get(((DynamicObject)coll.get("goods")).get("number")));
                    continue;
                }
                coll.set("jdorder", (Object)numberJdOrderIdMap.get("jdorder"));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{purOrder});
        }
    }

    private DynamicObject getJdOrder(String jdOrderId) {
        return JDOrderUtil.getJdOrder((String)jdOrderId);
    }

    @Override
    public String getEcOrderEntityKey() {
        return "pbd_jdorder";
    }

    private Map<String, Long> getNumberJdOrderIdMap(Map<String, Object> childJdOrderIdMap, String remittanceCode, DynamicObject jdOrder) {
        HashMap<String, Long> resultMap = new HashMap();
        if (Boolean.parseBoolean((String)childJdOrderIdMap.get("isHasChildOrder"))) {
            resultMap = JDOrderUtil.saveChildOrder(childJdOrderIdMap, (String)remittanceCode, (DynamicObject)jdOrder);
        } else {
            jdOrder.set("paycode", (Object)remittanceCode);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{jdOrder});
            resultMap.put("jdorder", jdOrder.getLong("id"));
        }
        return resultMap;
    }

    @Override
    public DynamicObject queryEcOrder(String ecOrderId) {
        QFilter qFilter1 = new QFilter("number", "=", (Object)ecOrderId);
        return BusinessDataServiceHelper.loadSingle((String)"pbd_jdorder", (String)"invaddress,number", (QFilter[])new QFilter[]{qFilter1});
    }

    @Override
    public String getInvoiceOrgCode() {
        String enterpriseId = RequestContext.getOrCreate().getTenantId();
        String selectFields = "invoiceorgcode";
        QFilter qfiter = new QFilter("tenantid", "=", (Object)enterpriseId);
        qfiter.and(new QFilter("platform", "=", (Object)this.getPlatform()));
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"pmm_ecadmit", (String)selectFields, (QFilter[])new QFilter[]{qfiter});
        if (null != dyo && StringUtils.isNotBlank((CharSequence)dyo.getString("invoiceorgcode"))) {
            return dyo.getString("invoiceorgcode");
        }
        return "544";
    }

    @Override
    public void updateInvoice(IFormView view) {
        if (MalOrderUtil.getDefaultMalVersion()) {
            super.updateInvoice(view);
        } else {
            try {
                int[] selectIndexs = this.getSelectIndex(view);
                if (selectIndexs.length > 0) {
                    Set<String> jdChildOrderSet = this.getEcChildOrderIdSet(this.getSelectedDyObject(view));
                    JDOrderUtil.updateJdInvoiceInfo(jdChildOrderSet);
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5f00\u7968\u72b6\u6001\u6210\u529f\u3002", (String)"JdEcInvoiceService_1", (String)"scm-pur-common", (Object[])new Object[0]));
                    view.invokeOperation("refresh");
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"JdEcInvoiceService_2", (String)"scm-pur-common", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                view.showTipNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5f00\u7968\u72b6\u6001\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"JdEcInvoiceService_3", (String)"scm-pur-common", (Object[])new Object[0]));
                log.error("@@@\u624b\u5de5\u66f4\u65b0\u53d1\u7968\u7b7e\u6536\u53d1\u7968\u4fe1\u606f\u3001\u72b6\u6001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }

    @Override
    public void confirmReceive(IFormView view) {
        if (MalOrderUtil.getDefaultMalVersion()) {
            super.confirmReceive(view);
        } else {
            int[] selectIndexs = this.getSelectIndex(view);
            if (selectIndexs.length > 0) {
                boolean flag = true;
                Set<String> jdChildOrderSet = this.getEcChildOrderIdSet(this.getSelectedDyObject(view));
                try {
                    JDOrderUtil.updateJdStateInfo(jdChildOrderSet);
                }
                catch (Exception e) {
                    flag = false;
                    log.error("@@@\u624b\u5de5\u66f4\u65b0\u4eac\u4e1c\u5355\u72b6\u6001\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
                }
                String resultstr = JDOrderUtil.confirmRecieve(jdChildOrderSet);
                if ((resultstr == null || resultstr.length() < 2) && flag) {
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6536\u8d27\u72b6\u6001\u6210\u529f\u3002", (String)"JdEcInvoiceService_4", (String)"scm-pur-common", (Object[])new Object[0]));
                } else {
                    view.showMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u6536\u8d27\u72b6\u6001\u5931\u8d25\u3002", (String)"JdEcInvoiceService_5", (String)"scm-pur-common", (Object[])new Object[0]), resultstr, MessageTypes.Default);
                }
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"JdEcInvoiceService_2", (String)"scm-pur-common", (Object[])new Object[0]));
            }
        }
    }

    @Override
    protected ApiResult<List<EcConfirmInfo>> doConfirmRec(EcConfirmRecParam ecConfirmRecParam) {
        HashMap<String, String> params = new HashMap<String, String>();
        Set<String> ecOrderIds = ecConfirmRecParam.getEcChildOrderIds();
        params.put("orderIds", StringUtils.join((Object[])ecOrderIds.toArray(), (String)","));
        String token = this.getTokenByEcOrderId(new ArrayList<String>(ecOrderIds).get(0));
        if (StringUtils.isNotBlank((CharSequence)token)) {
            params.put("token", token);
        }
        Map result = (Map)ApiAccessor.invoke((String)"SRM_JD_ORDER_batchConfirmReceived", params);
        ApiResult apiResult = new ApiResult(result);
        apiResult.setResult(this.getBody(result));
        return apiResult;
    }

    @Override
    public DynamicObjectCollection queryEcOrders(Set<String> ecChildOrderIdSet) {
        return QueryServiceHelper.query((String)"pbd_jdorder", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", ecChildOrderIdSet)});
    }

    @Override
    public DynamicObject[] loadEcOrders(Set<String> ecChildOrderSet) {
        QFilter orderFiler = new QFilter("number", "in", ecChildOrderSet);
        String selectField = "markid,invoicestate,invoiceid,invoicecode,invoicedate,invoiceamount,invoicetax,invoicetaxamount,invoicetype,invaddress,invoiceresult, number";
        return BusinessDataServiceHelper.load((String)"pbd_jdorder", (String)selectField, (QFilter[])new QFilter[]{orderFiler});
    }

    @Override
    public EcInvoiceInfo packageEcInvoiceInfo(EcInvoiceInfo ecInvoiceInfo, JSONObject invoiceJo, Map<String, EmalStatus> emalStatusMap) {
        ecInvoiceInfo = super.packageEcInvoiceInfo(ecInvoiceInfo, invoiceJo, emalStatusMap);
        ecInvoiceInfo.setEcInvoiceSkuDetails(this.queryEcInvoiceDetail(ecInvoiceInfo));
        return ecInvoiceInfo;
    }

    protected List<EcInvoiceSkuDetail> queryEcInvoiceDetail(EcInvoiceInfo ecInvoiceInfo) {
        Map invoiceResultMap;
        ArrayList<EcInvoiceSkuDetail> ecInvoiceSkuDetails = new ArrayList<EcInvoiceSkuDetail>();
        if (!ecInvoiceInfo.isSuccess()) {
            return ecInvoiceSkuDetails;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("invoiceId", ecInvoiceInfo.getInvoiceId());
        paramMap.put("invoiceCode", ecInvoiceInfo.getInvoiceCode());
        String token = this.getTokenByInvoiceIdAndCode(ecInvoiceInfo.getInvoiceId(), ecInvoiceInfo.getInvoiceCode());
        if (StringUtils.isNotBlank((CharSequence)token)) {
            paramMap.put("token", token);
        }
        Object result = ApiAccessor.invoke((String)JdApiParser.getJdApiNumber((String)this.getPlatform(), (String)"SRM_JD_INVOICE_queryInvoiceItem"), paramMap);
        BigDecimal invoiceNakedAmount = BigDecimal.ZERO;
        BigDecimal invoiceTaxAmount = BigDecimal.ZERO;
        if (result != null && ((Boolean)(invoiceResultMap = (Map)result).get("success")).booleanValue()) {
            JSONObject invoiceItemRespJo = JSONObject.fromObject(invoiceResultMap.get("result"));
            JSONArray invoiceDetailJa = JSONArray.fromObject((Object)invoiceItemRespJo.getJSONArray("skuDetails"));
            HashSet<String> ecOrderIdSet = new HashSet<String>(16);
            for (int i = 0; i < invoiceDetailJa.size(); ++i) {
                JSONObject invoiceDetailJo = invoiceDetailJa.getJSONObject(i);
                EcInvoiceSkuDetail ecInvoiceSkuDetail = new EcInvoiceSkuDetail();
                ecInvoiceSkuDetail.setAmount(this.converStr2BigDecimal(invoiceDetailJo.getString("amount")));
                ecInvoiceSkuDetail.setAmountUnTax(this.converStr2BigDecimal(invoiceDetailJo.getString("amountUnTax")));
                invoiceNakedAmount = invoiceNakedAmount.add(ecInvoiceSkuDetail.getAmountUnTax());
                ecInvoiceSkuDetail.setNum(this.converStr2BigDecimal(invoiceDetailJo.getString("num")));
                ecInvoiceSkuDetail.setTaxAmount(this.converStr2BigDecimal(invoiceDetailJo.getString("taxAmount")));
                invoiceTaxAmount = invoiceTaxAmount.add(ecInvoiceSkuDetail.getTaxAmount());
                String jdOrderId = invoiceDetailJo.getString("jdOrderId");
                ecInvoiceSkuDetail.setEcOrderId(jdOrderId);
                ecOrderIdSet.add(jdOrderId);
                ecInvoiceSkuDetail.setPrice(this.converStr2BigDecimal(invoiceDetailJo.getString("price")));
                ecInvoiceSkuDetail.setSettleUnit(invoiceDetailJo.getString("settleUnit"));
                ecInvoiceSkuDetail.setSkuName(invoiceDetailJo.getString("skuName"));
                ecInvoiceSkuDetail.setSpecification(invoiceDetailJo.getString("specification"));
                ecInvoiceSkuDetail.setTaxRate(this.converStr2BigDecimal(invoiceDetailJo.getString("taxRate")));
                ecInvoiceSkuDetail.setSkuId(invoiceDetailJo.getString("skuId"));
                ecInvoiceSkuDetails.add(ecInvoiceSkuDetail);
            }
            ecInvoiceInfo.setInvoiceNakedAmount(invoiceNakedAmount);
            ecInvoiceInfo.setInvoiceTaxAmount(invoiceTaxAmount);
            ecInvoiceInfo.setEcOrders(ecOrderIdSet);
        }
        return ecInvoiceSkuDetails;
    }

    @Override
    protected void updateMaterialEntry(DynamicObject purInvoice, List<EcInvoiceInfo> ecInvoiceInfos) {
        DynamicObjectCollection materialEntryCol = purInvoice.getDynamicObjectCollection("entryentity1");
        Iterator itr = materialEntryCol.iterator();
        BigDecimal sumtaxamount = purInvoice.getBigDecimal("sumtaxamount");
        BigDecimal sumamount = purInvoice.getBigDecimal("sumamount");
        BigDecimal sumtax = purInvoice.getBigDecimal("sumtax");
        HashSet<String> failEcOrderIdSet = new HashSet<String>(64);
        HashSet<String> ecOrderIdSet = new HashSet<String>(materialEntryCol.size());
        StringBuilder logSb = new StringBuilder();
        StringBuilder isExistSb = new StringBuilder();
        while (itr.hasNext()) {
            DynamicObject materialEntry = (DynamicObject)itr.next();
            String ecOrderId = materialEntry.getString("entryjdorder.number");
            String sku = materialEntry.getString("goods1.number");
            BigDecimal qty = materialEntry.getBigDecimal("qty1");
            boolean isExist = false;
            for (EcInvoiceInfo ecInvoiceInfo : ecInvoiceInfos) {
                if (!ecInvoiceInfo.isSuccess()) {
                    return;
                }
                List<EcInvoiceSkuDetail> jdInvoiceSkuDetails = ecInvoiceInfo.getEcInvoiceSkuDetails();
                for (EcInvoiceSkuDetail jdInvoiceSkuDetail : jdInvoiceSkuDetails) {
                    ecOrderIdSet.add(jdInvoiceSkuDetail.getEcOrderId());
                    if (!StringUtils.equals((CharSequence)jdInvoiceSkuDetail.getEcOrderId(), (CharSequence)ecOrderId) || !StringUtils.equals((CharSequence)jdInvoiceSkuDetail.getSkuId(), (CharSequence)sku)) continue;
                    isExist = true;
                    if (qty.compareTo(jdInvoiceSkuDetail.getNum()) == 0) continue;
                    logSb.append("@@ jdInvoiceSkuDetail.getNum() isnotequal invoice qty").append(JSON.toJSONString((Object)ecInvoiceInfo)).append(System.lineSeparator());
                    materialEntry.set("qty1", (Object)jdInvoiceSkuDetail.getNum());
                    BigDecimal oldTaxamount1 = materialEntry.getBigDecimal("taxamount1");
                    BigDecimal taxamount1 = oldTaxamount1.divide(qty).multiply(jdInvoiceSkuDetail.getNum());
                    materialEntry.set("taxamount1", (Object)taxamount1);
                    sumtaxamount = sumtaxamount.subtract(oldTaxamount1.subtract(taxamount1));
                    BigDecimal oldAmount1 = materialEntry.getBigDecimal("amount1");
                    BigDecimal amount1 = oldAmount1.divide(qty).multiply(jdInvoiceSkuDetail.getNum());
                    materialEntry.set("amount1", (Object)amount1);
                    sumamount = sumamount.subtract(oldAmount1.subtract(amount1));
                    BigDecimal oldTax1 = materialEntry.getBigDecimal("tax1");
                    BigDecimal tax1 = oldTax1.divide(qty).multiply(jdInvoiceSkuDetail.getNum());
                    materialEntry.set("tax1", (Object)tax1);
                    sumtax = sumtax.subtract(oldTax1.subtract(tax1));
                }
            }
            if (isExist) continue;
            isExistSb.append("@@ goods isNotExist invoice").append(ecOrderId).append(":").append(sku).append(":").append(qty).append(System.lineSeparator());
            sumtaxamount = sumtaxamount.subtract(materialEntry.getBigDecimal("taxamount1"));
            sumamount = sumamount.subtract(materialEntry.getBigDecimal("amount1"));
            sumtax = sumtax.subtract(materialEntry.getBigDecimal("tax1"));
            failEcOrderIdSet.add(ecOrderId);
            itr.remove();
        }
        if (logSb.length() > 0) {
            log.info("@@\u53d1\u73b0\u53d1\u7968\u7b7e\u6536\u5546\u54c1\u6570\u91cf\u4e0e\u7535\u5546\u53d1\u7968\u5546\u54c1\u6570\u91cf\u4e0d\u4e00\u81f4:{}", (Object)logSb.toString());
        }
        if (isExistSb.length() > 0) {
            log.info("@@\u53d1\u73b0\u53d1\u7968\u7b7e\u6536\u5355\u4e2d\u4e0d\u5b58\u5728\u8ba2\u5355\u5546\u54c1:{}", (Object)isExistSb);
        }
        purInvoice.set("insumtaxamount", (Object)sumtaxamount);
        purInvoice.set("sumtaxamount", (Object)sumtaxamount);
        purInvoice.set("sumamount", (Object)sumamount);
        purInvoice.set("sumtax", (Object)sumtax);
        failEcOrderIdSet.removeIf(ecOrderIdSet::contains);
        this.updateEcOrderForPartFail(failEcOrderIdSet);
    }

    protected void updateEcOrderForPartFail(Set<String> failEcOrderIdSet) {
        if (failEcOrderIdSet != null && !failEcOrderIdSet.isEmpty()) {
            DynamicObject[] jdDyos;
            QFilter numberFilter = new QFilter("number", "in", failEcOrderIdSet);
            String selector = "markid,number,invoicestate,invoiceresult,invoiceid,invoicecode,invoicedate,invoiceamount,invoicetax,invoicetaxamount,invoicetype,invaddress";
            for (DynamicObject jdDyo : jdDyos = BusinessDataServiceHelper.load((String)"pbd_jdorder", (String)selector, (QFilter[])new QFilter[]{numberFilter})) {
                jdDyo.set("invoicestate", (Object)"8");
                jdDyo.set("invoiceresult", (Object)ResManager.loadKDString((String)"\u5f00\u7968\u5931\u8d25\u90e8\u5206", (String)"JdEcInvoiceService_7", (String)"scm-common", (Object[])new Object[0]));
            }
            SaveServiceHelper.save((DynamicObject[])jdDyos);
        }
    }

    @Override
    protected void updateEcOrder(DynamicObject ecOrder, List<EcInvoiceInfo> ecInvoiceInfos) {
        for (EcInvoiceInfo ecInvoiceInfoValue : ecInvoiceInfos) {
            if (!ecInvoiceInfoValue.getEcOrders().contains(ecOrder.getString("number")) && ecInvoiceInfoValue.isSuccess()) continue;
            this.updateEcOrderByEcInvInfo(ecOrder, ecInvoiceInfoValue);
        }
    }

    @Override
    protected String getEcOrderId(DynamicObject ecOrder) {
        return ecOrder.getString("number");
    }

    @Override
    public String getPlatform() {
        return EcPlatformEnum.ECPLATFORM_JD.getVal();
    }

    @Override
    protected DynamicObjectCollection queryEcOrderByPks(Set<Long> ecOrderPkSet) {
        if (ecOrderPkSet == null || ecOrderPkSet.isEmpty()) {
            return new DynamicObjectCollection();
        }
        QFilter idFilter = new QFilter("id", "in", ecOrderPkSet);
        return QueryServiceHelper.query((String)this.getEcOrderEntityKey(), (String)"id,number orderid", (QFilter[])new QFilter[]{idFilter});
    }

    @Override
    public Map<String, Object> prepareQueryParam(DynamicObject ecOrder) {
        String markId = ecOrder.getString("markid");
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        HashMap<String, String> platformParam = new HashMap<String, String>(16);
        platformParam.put("markId", markId);
        String token = this.getTokenByEcOrderPk(ecOrder.getLong("id"));
        if (StringUtils.isNotBlank((CharSequence)token)) {
            platformParam.put("token", token);
        }
        param.put(this.getPlatform(), platformParam);
        return param;
    }

    private String getTokenByEcOrderPk(Long ecOrderPk) {
        log.info("kd.scm.pur.common.ecinvoice.service.impl.JdEcInvoiceService.getTokenByEcOrderPk:" + ecOrderPk);
        DynamicObject malOrderDyn = QueryServiceHelper.queryOne((String)"mal_order", (String)"settleorg.id", (QFilter[])new QFilter[]{new QFilter("entryentity.order", "=", (Object)ecOrderPk)});
        if (malOrderDyn != null) {
            return JDAccessTokenUtil.getValidToken((String)malOrderDyn.getString("settleorg.id"), (String)this.getPlatform());
        }
        return "";
    }

    private String getTokenByInvoiceIdAndCode(String invoiceId, String invoiceCode) {
        log.info("kd.scm.pur.common.ecinvoice.service.impl.JdEcInvoiceService.getTokenByInvoiceIdAndCode:" + invoiceId + "&" + invoiceCode);
        DynamicObject jdOrderDyn = QueryServiceHelper.queryOne((String)"pbd_jdorder", (String)"id", (QFilter[])new QFilter[]{new QFilter("invoiceid", "=", (Object)invoiceId), new QFilter("invoicecode", "=", (Object)invoiceCode)});
        if (jdOrderDyn != null) {
            return this.getTokenByEcOrderPk(jdOrderDyn.getLong("id"));
        }
        return "";
    }

    private String getTokenByEcOrderId(String ecOrderId) {
        log.info("kd.scm.pur.common.ecinvoice.service.impl.JdEcInvoiceService.getTokenByEcOrderId:" + ecOrderId);
        DynamicObject jdOrderDyn = QueryServiceHelper.queryOne((String)"pbd_jdorder", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)ecOrderId)});
        if (jdOrderDyn != null) {
            return this.getTokenByEcOrderPk(jdOrderDyn.getLong("id"));
        }
        return "";
    }
}

