/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.ecinvoice.service.impl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.helper.apiconnector.api.ApiResult;
import kd.scm.pur.common.ecinvoice.beans.EcConfirmInfo;
import kd.scm.pur.common.ecinvoice.beans.EcInvSubmitParam;
import kd.scm.pur.common.ecinvoice.beans.EcInvSubmitResult;
import kd.scm.pur.common.ecinvoice.exception.KDEcInvoiceException;
import kd.scm.pur.common.ecinvoice.service.impl.GenericEcInvoiceService;

public class XyEcInvoiceService
extends GenericEcInvoiceService {
    private static final Log log = LogFactory.getLog((String)XyEcInvoiceService.class.getName());

    @Override
    public EcInvSubmitParam packageEcSubmitParam(IDataModel model, DynamicObjectCollection reportDyoCol) {
        EcInvSubmitParam ecInvSubmitParam = super.packageEcSubmitParam(model, reportDyoCol);
        BigDecimal invoiceAmount = this.getInvoiceAmount(reportDyoCol);
        String ecAddressNum = AddressUtil.getLongNumber((Long)Long.parseLong(model.getValue("revaddress").toString()), (String)EcPlatformEnum.ECPLATFORM_XY.getVal());
        String[] ecAddress = this.getEcAddress(ecAddressNum);
        if (ecAddress.length < 3) {
            log.error("@@@kd.scm.pur.formplugin.util.PurNewEcInvoiceHelper.invoiceSubmit\u897f\u57df\u5f00\u7968\u5f02\u5e38\uff1a\u5730\u5740\u6ca1\u67093\u7ea7\u7f16\u7801\u3002");
            throw new KDEcInvoiceException(ResManager.loadKDString((String)"\u897f\u57df\u5f00\u7968\u5f02\u5e38\uff1a\u5730\u5740\u6ca1\u67093\u7ea7\u7f16\u7801\u3002", (String)"XyEcInvoiceService_0", (String)"scm-pur-common", (Object[])new Object[0]));
        }
        int billToProvinceId = 0;
        int billToCityId = 1;
        int billToCountyId = 2;
        ecInvSubmitParam.setBillToProvince(ecAddress[billToProvinceId]);
        ecInvSubmitParam.setBillToCity(ecAddress[billToCityId]);
        ecInvSubmitParam.setBillToCounty(ecAddress[billToCountyId]);
        ecInvSubmitParam.setBillToTown("0");
        ecInvSubmitParam.setSettlementId(ecInvSubmitParam.getMarkId());
        ecInvSubmitParam.setInvoiceDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        ecInvSubmitParam.setInvoicePrice(invoiceAmount.toPlainString());
        return ecInvSubmitParam;
    }

    @Override
    protected EcInvSubmitResult parseResult(EcInvSubmitParam ecInvSubmitParam, Map<String, Map<String, Object>> res) {
        EcInvSubmitResult ecInvSubmitResult = super.parseResult(ecInvSubmitParam, res);
        Map<String, Object> resultMap = res.get(EcPlatformEnum.ECPLATFORM_XY.getVal());
        ecInvSubmitResult.setSuccess((Boolean)resultMap.get("success"));
        if (ecInvSubmitResult.isSuccess()) {
            ecInvSubmitResult.setInvoiceState(PurEcInvoiceEnum.HANDLING.getVal());
        } else {
            ecInvSubmitResult.setInvoiceState(PurEcInvoiceEnum.INVOICEFAILED.getVal());
            ArrayList<String> errorInfos = new ArrayList<String>();
            errorInfos.add(this.now() + ":" + resultMap.get("resultMessage"));
            ecInvSubmitResult.setErrorInfo(errorInfos);
        }
        ecInvSubmitResult.setPlatform(EcPlatformEnum.ECPLATFORM_XY.getVal());
        return ecInvSubmitResult;
    }

    @Override
    public String getPlatform() {
        return EcPlatformEnum.ECPLATFORM_XY.getVal();
    }

    @Override
    public String getEcOrderEntityKey() {
        return "pbd_order_xy";
    }

    @Override
    protected void afterDoConfirmRec(ApiResult<List<EcConfirmInfo>> apiResult, IFormView view) {
        if (apiResult == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u897f\u57df\u5546\u57ce\u8ba2\u5355\u65e0\u9700\u786e\u8ba4\u6536\u8d27\u3002", (String)"GenericEcInvoiceService_20", (String)"scm-pur-common", (Object[])new Object[0]));
            return;
        }
    }
}

