/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.ecinvoice.service.impl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.entity.EmalStatus;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.helper.apiconnector.api.ApiResult;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.pur.common.ecinvoice.beans.EcConfirmInfo;
import kd.scm.pur.common.ecinvoice.beans.EcConfirmRecParam;
import kd.scm.pur.common.ecinvoice.beans.EcInvSubmitParam;
import kd.scm.pur.common.ecinvoice.beans.EcInvSubmitResult;
import kd.scm.pur.common.ecinvoice.beans.EcInvoiceInfo;
import kd.scm.pur.common.ecinvoice.service.impl.GenericEcInvoiceService;
import net.sf.json.JSONObject;

public class ZkhEcInvoiceService
extends GenericEcInvoiceService {
    private static final Log log = LogFactory.getLog((String)ZkhEcInvoiceService.class.getName());
    private static final String ORDERITEM = "9";

    @Override
    public EcInvSubmitParam packageEcSubmitParam(IDataModel model, DynamicObjectCollection reportDyoCol) {
        EcInvSubmitParam ecInvSubmitParam = super.packageEcSubmitParam(model, reportDyoCol);
        DynamicObject reportDyo = (DynamicObject)reportDyoCol.get(0);
        ecInvSubmitParam.setCompanyName(reportDyo.getString("invoiceorg.ffirmname.zh_CN").trim());
        ecInvSubmitParam.setSettlementId(ecInvSubmitParam.getMarkId());
        DynamicObject addrDyn = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"fullname", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)model.getDataEntity().getLong("revaddress"))});
        String addr = this.getFullAddress(addrDyn.getString("fullname"), model.getDataEntity().getString("revaddressdetail"));
        ecInvSubmitParam.setBillToAddress(addr);
        ecInvSubmitParam.setInvoiceDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        ecInvSubmitParam.setInvoicePrice(this.getInvoiceAmount(reportDyoCol).toPlainString());
        ecInvSubmitParam.setAmount(this.getAmount(reportDyoCol));
        ecInvSubmitParam.setTax(this.getTax(reportDyoCol));
        log.info("@@packageEcSubmitParam:" + ecInvSubmitParam);
        return ecInvSubmitParam;
    }

    private String getFullAddress(String wholeAddress, String revaddressdetail) {
        StringBuilder addrDetail = new StringBuilder();
        String[] addr = wholeAddress.split("_");
        String beijing = ResManager.loadKDString((String)"\u5317\u4eac", (String)"ZkhEcInvoiceService_1", (String)"scm-pur-common", (Object[])new Object[0]);
        String tianjin = ResManager.loadKDString((String)"\u5929\u6d25", (String)"ZkhEcInvoiceService_2", (String)"scm-pur-common", (Object[])new Object[0]);
        String shanghai = ResManager.loadKDString((String)"\u4e0a\u6d77", (String)"ZkhEcInvoiceService_3", (String)"scm-pur-common", (Object[])new Object[0]);
        String chongqing = ResManager.loadKDString((String)"\u91cd\u5e86", (String)"ZkhEcInvoiceService_4", (String)"scm-pur-common", (Object[])new Object[0]);
        if (addr[0].contains(beijing)) {
            addr = this.addrLoopDeal(addr, beijing);
        } else if (addr[0].contains(tianjin)) {
            addr = this.addrLoopDeal(addr, tianjin);
        } else if (addr[0].contains(shanghai)) {
            addr = this.addrLoopDeal(addr, shanghai);
        } else if (addr[0].contains(chongqing)) {
            addr = this.addrLoopDeal(addr, chongqing);
        }
        for (String address : addr) {
            addrDetail.append(address).append("_");
        }
        addrDetail.append(revaddressdetail);
        return addrDetail.toString();
    }

    private String[] addrLoopDeal(String[] addr, String address) {
        String[] newAddr = new String[addr.length + 1];
        newAddr[0] = address;
        for (int i = 0; i < addr.length; ++i) {
            newAddr[i + 1] = addr[i];
        }
        return newAddr;
    }

    @Override
    public EcInvSubmitResult doSubmit(EcInvSubmitParam ecInvSubmitParam) {
        log.info("@@ecInvSubmitParam:" + ecInvSubmitParam);
        Map<String, Object> paraMap = ecInvSubmitParam.covertToApiParamMap();
        this.addSkuInfo(paraMap);
        this.addAddressInfo(paraMap);
        Map res = EcGroupApiUtil.addInvoice(paraMap);
        log.info("@@res:" + res);
        return this.parseResult(ecInvSubmitParam, res);
    }

    @Override
    protected EcInvSubmitResult parseResult(EcInvSubmitParam ecInvSubmitParam, Map<String, Map<String, Object>> res) {
        EcInvSubmitResult ecInvSubmitResult = super.parseResult(ecInvSubmitParam, res);
        Map<String, Object> resultMap = res.get(EcPlatformEnum.ECPLATFORM_ZKH.getVal());
        ecInvSubmitResult.setSuccess((Boolean)resultMap.get("success"));
        if (ecInvSubmitResult.isSuccess()) {
            ecInvSubmitResult.setInvoiceState(PurEcInvoiceEnum.PREAUDIT.getVal());
        } else {
            ecInvSubmitResult.setInvoiceState(PurEcInvoiceEnum.INVOICEFAILED.getVal());
            ArrayList<String> errorInfos = new ArrayList<String>();
            errorInfos.add(this.now() + ":" + resultMap.get("resultMessage"));
            ecInvSubmitResult.setErrorInfo(errorInfos);
        }
        ecInvSubmitResult.setPlatform(EcPlatformEnum.ECPLATFORM_ZKH.getVal());
        return ecInvSubmitResult;
    }

    private void addSkuInfo(Map<String, Object> paraMap) {
        Map paraDetailMap = (Map)paraMap.get(EcPlatformEnum.ECPLATFORM_ZKH.getVal());
        String[] supplierOrders = ((String)paraDetailMap.get("supplierOrder")).split(",");
        HashMap<Long, Map> ecOrderMap = new HashMap<Long, Map>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pbd_order_zkh", (String)"id,orderid,orderamount,entryentity.goods.number goods,entryentity.qty qty,entryentity.price price", (QFilter[])new QFilter[]{new QFilter("orderid", "in", (Object)supplierOrders)}, null);){
            dataSet.forEach(row -> {
                Map infoMap = ecOrderMap.computeIfAbsent(row.getLong("id"), k -> new HashMap());
                Map goodsMap = (Map)infoMap.computeIfAbsent("goods", k -> new HashMap());
                HashMap<String, Number> priceMap = new HashMap<String, Number>(8);
                priceMap.put("qty", row.getInteger("qty"));
                priceMap.put("price", row.getBigDecimal("price"));
                goodsMap.put(row.getString("goods"), priceMap);
                infoMap.put("orderid", row.getString("orderid"));
                infoMap.put("orderamount", row.getBigDecimal("orderamount"));
            });
        }
        QFilter qFilter = new QFilter("cfmstatus", "in", Arrays.asList("B", "F"));
        qFilter.and("entryentity.ecorder", "in", ecOrderMap.keySet());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"mal_returnreq", (String)"entryentity.ecorder ecorder,entryentity.goods.number goods,entryentity.qty qty,entryentity.taxamount taxamount", (QFilter[])qFilter.toArray(), null);){
            for (Row row2 : dataSet) {
                Map infoMap2 = (Map)ecOrderMap.get(row2.getLong("ecorder"));
                if (infoMap2 == null) continue;
                Map goodsMap = (Map)infoMap2.get("goods");
                Map priceMap = (Map)goodsMap.get(row2.getString("goods"));
                priceMap.put("qty", (Integer)priceMap.get("qty") - row2.getBigDecimal("qty").intValue());
                infoMap2.put("orderamount", ((BigDecimal)infoMap2.get("orderamount")).subtract(row2.getBigDecimal("taxamount")));
            }
        }
        ArrayList supplierOrderList = new ArrayList(ecOrderMap.size());
        ecOrderMap.forEach((ecOrder, infoMap) -> {
            HashMap supplierOrder = new HashMap();
            supplierOrder.put("orderId", infoMap.get("orderid"));
            supplierOrder.put("settleAmt", infoMap.get("orderamount"));
            ArrayList skuInfos = new ArrayList();
            Map goodsMap = (Map)infoMap.get("goods");
            goodsMap.forEach((sku, priceMap) -> {
                HashMap<String, String> SKU = new HashMap<String, String>(goodsMap.size());
                SKU.put("skuId", (String)sku);
                SKU.put("skuNum", (String)priceMap.get("qty"));
                SKU.put("sellPrice", (String)priceMap.get("price"));
                skuInfos.add(SKU);
            });
            supplierOrder.put("skuInfos", skuInfos);
            supplierOrderList.add(supplierOrder);
        });
        paraDetailMap.put("supplierOrderList", supplierOrderList);
    }

    private void addAddressInfo(Map<String, Object> paraMap) {
        Map paraDetailMap = (Map)paraMap.get(EcPlatformEnum.ECPLATFORM_ZKH.getVal());
        String billToAddress = (String)paraDetailMap.get("billToAddress");
        String[] addr = billToAddress.split("_");
        HashMap<String, String> region = new HashMap<String, String>(8);
        int size = addr.length;
        region.put("province", addr[0]);
        region.put("city", addr[1]);
        region.put("county", addr[2]);
        if (size > 4) {
            region.put("town", addr[3]);
        }
        paraDetailMap.put("billToRegion", region);
        StringBuilder addressDetail = new StringBuilder();
        for (String address : addr) {
            addressDetail.append(address);
        }
        paraDetailMap.put("billToAddress", addressDetail.toString());
    }

    @Override
    public String getEcOrderEntityKey() {
        return "pbd_order_zkh";
    }

    @Override
    public ApiResult<List<EcInvoiceInfo>> parseQueryRes(Map<String, Map<String, Object>> res, DynamicObject ecOrder) {
        ApiResult<List<EcInvoiceInfo>> apiResult = super.parseQueryRes(res, ecOrder);
        List ecInvoiceInfos = (List)apiResult.getResult();
        if (ecInvoiceInfos.isEmpty()) {
            QFilter filter = new QFilter("statustypenumber", "=", (Object)"3");
            filter.and(new QFilter("emaltype", "=", (Object)EcPlatformEnum.ECPLATFORM_ZKH.getVal()));
            filter.and("number", "=", (Object)"2");
            DynamicObject objs = QueryServiceHelper.queryOne((String)"pbd_emalstatus", (String)"number,emalstatusnumber,emalstatusname", (QFilter[])new QFilter[]{filter});
            String resultCode = apiResult.getResultCode();
            if (StringUtils.isNotBlank((CharSequence)resultCode) && objs != null && resultCode.equals(objs.getString("emalstatusnumber"))) {
                EcInvoiceInfo ecInvoiceInfo = new EcInvoiceInfo();
                ecInvoiceInfo.setResultMessage(apiResult.getResultMessage());
                ecInvoiceInfo.setResultCode(apiResult.getResultCode());
                ecInvoiceInfo.setInvoiceType(ecOrder.getString("invoicetype"));
                ecInvoiceInfo.setPlatform(EcPlatformEnum.ECPLATFORM_ZKH.getVal());
                ecInvoiceInfo.setSuccess(true);
                ecInvoiceInfo.setInvoiceState(PurEcInvoiceEnum.PREAUDIT.getVal());
                ecInvoiceInfos.add(ecInvoiceInfo);
            }
        }
        return apiResult;
    }

    @Override
    public EcInvoiceInfo packageEcInvoiceInfo(EcInvoiceInfo ecInvoiceInfo, JSONObject invoiceJo, Map<String, EmalStatus> emalStatusMap) {
        ecInvoiceInfo = super.packageEcInvoiceInfo(ecInvoiceInfo, invoiceJo, emalStatusMap);
        String ecInvState = invoiceJo.getString("state");
        ecInvoiceInfo.setResultCode(ecInvState);
        EmalStatus emalStatus = emalStatusMap.get(ecInvState);
        if (emalStatus != null) {
            ecInvoiceInfo.setInvoiceState(emalStatus.getNumber());
        } else {
            ecInvoiceInfo.setInvoiceState(PurEcInvoiceEnum.PREAUDIT.getVal());
        }
        String invoiceUrl = invoiceJo.getString("invoiceUrl");
        if (StringUtils.isNotBlank((CharSequence)invoiceUrl)) {
            ecInvoiceInfo.setInvoiceFileUrl(invoiceUrl);
        }
        return ecInvoiceInfo;
    }

    @Override
    public String getPlatform() {
        return EcPlatformEnum.ECPLATFORM_ZKH.getVal();
    }

    @Override
    protected ApiResult<List<EcConfirmInfo>> doConfirmRec(EcConfirmRecParam ecConfirmRecParam) {
        HashMap params = new HashMap(ecConfirmRecParam.getEcChildOrderIds().size());
        HashMap<String, String> platformParams = new HashMap<String, String>(ecConfirmRecParam.getEcChildOrderIds().size());
        ApiResult apiResult = new ApiResult();
        ArrayList<EcConfirmInfo> ecConfirmInfos = new ArrayList<EcConfirmInfo>();
        HashSet<String> successEcIds = new HashSet<String>(ecConfirmRecParam.getEcChildOrderIds().size());
        for (String orderId : ecConfirmRecParam.getEcChildOrderIds()) {
            platformParams.put("orderId", orderId);
            params.put(this.getPlatform(), platformParams);
            Map res = EcGroupApiUtil.confirmOrderReceive(params);
            HashMap<String, Object> confirmMap = new HashMap<String, Object>();
            Map resMap = (Map)res.get(this.getPlatform());
            if (!Boolean.parseBoolean((String)resMap.get("success"))) {
                confirmMap.put("errorMsg", resMap.get("resultMessage"));
                confirmMap.put("confirmState", "2");
                confirmMap.put("childOrderId", orderId);
                EcConfirmInfo ecConfirmInfo = new EcConfirmInfo(confirmMap);
                ecConfirmInfos.add(ecConfirmInfo);
                continue;
            }
            successEcIds.add(orderId);
        }
        this.updateZkhStatus(successEcIds);
        apiResult.setSuccess(true);
        apiResult.setResult(ecConfirmInfos);
        return apiResult;
    }

    private void updateZkhStatus(Set<String> successEcIds) {
        DynamicObject[] zkhOrders;
        if (successEcIds == null || successEcIds.isEmpty()) {
            return;
        }
        HashMap<String, String> orderIdStateMap = new HashMap<String, String>(successEcIds.size() * 2);
        for (String ecOrderPkId : successEcIds) {
            Map data = (Map)EcGroupApiUtil.getEcOrderDetail((String)ecOrderPkId, (String)EcPlatformEnum.ECPLATFORM_ZKH.getVal()).get(EcPlatformEnum.ECPLATFORM_ZKH.getVal());
            if (null == data || null == data.get("state")) continue;
            orderIdStateMap.put(ecOrderPkId, String.valueOf(data.get("state")));
        }
        QFilter filter = new QFilter("orderid", "in", orderIdStateMap.keySet());
        for (DynamicObject zkhOrder : zkhOrders = BusinessDataServiceHelper.load((String)"pbd_order_zkh", (String)"id,orderid,orderstate,submitstate,state", (QFilter[])new QFilter[]{filter})) {
            String orderId = zkhOrder.getString("orderid");
            zkhOrder.set("state", orderIdStateMap.get(orderId));
        }
        SaveServiceHelper.save((DynamicObject[])zkhOrders);
    }
}

