/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.OrderUtil;
import kd.sdk.scm.pur.extpoint.IPurOrderChangeSupport;

public class PurOrderBillActiveToPurOrderOpUtil {
    private static Log log = LogFactory.getLog(PurOrderBillActiveToPurOrderOpUtil.class);

    public static DynamicObject[] getAvailableOrderS(List<Long> orderPks, String selectPro) {
        log.info("\u67e5\u8be2\u7684\u6570\u636e\u4e3b\u952e\u96c6\u5408" + orderPks.toString());
        ArrayList<Long> availablePkIds = new ArrayList<Long>(orderPks.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pur_order", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", orderPks)}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                availablePkIds.add(row.getLong("id"));
            }
        }
        DynamicObject[] purorder = null;
        log.info("\u6709\u6548\u7684\u7684\u6570\u636e\u4e3b\u952e\u96c6\u5408" + availablePkIds);
        if (!availablePkIds.isEmpty()) {
            purorder = selectPro != null && !selectPro.isEmpty() ? BusinessDataServiceHelper.load((String)"pur_order", (String)selectPro, (QFilter[])new QFilter[]{new QFilter("id", "in", availablePkIds)}) : BusinessDataServiceHelper.load((Object[])availablePkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pur_order"));
        }
        return purorder;
    }

    public static void updatepurorder(DynamicObject bill, DynamicObject srcBill) {
        String poentryid;
        String version;
        boolean pmIsDeleteEntryWay = PurOrderBillActiveToPurOrderOpUtil.getPmIsDeleteEntryWay();
        srcBill.set("remark", bill.get("comment"));
        srcBill.set("reqorg", bill.get("dept"));
        srcBill.set("contacter", bill.get("providerlinkman"));
        srcBill.set("deliaddress", bill.get("provideraddress"));
        srcBill.set("sumtaxamount", bill.get("totalallamount"));
        srcBill.set("sumamount", bill.get("totalamount"));
        srcBill.set("sumtax", bill.get("totaltaxamount"));
        List extendPlugins = PluginProxy.create(IPurOrderChangeSupport.class, (String)"SCM_PUR_ORDCHANGE_SUPPORT").getPlugins();
        if (extendPlugins != null && !extendPlugins.isEmpty()) {
            for (IPurOrderChangeSupport support : extendPlugins) {
                support.setOrderHeadFields(srcBill, bill);
            }
        }
        if ((version = bill.getString("version")) == null || version.equals("0") || version.equals("1.0") || version.equals("")) {
            version = "1";
        }
        srcBill.set("billversion", (Object)(Integer.parseInt(version) + 1));
        DynamicObjectCollection billEntryS = srcBill.getDynamicObjectCollection("materialentry");
        billEntryS.getDynamicObjectType().getProperties();
        DynamicObjectCollection xBillEntryS = bill.getDynamicObjectCollection("billentry");
        xBillEntryS.getDynamicObjectType().getProperties();
        HashMap<String, Object> modifyData = new HashMap<String, Object>();
        HashMap<String, Object> addData = new HashMap<String, Object>();
        HashMap<String, Object> removeData = new HashMap<String, Object>();
        HashMap<String, Object> cleanData = new HashMap<String, Object>();
        if (!xBillEntryS.isEmpty()) {
            for (Object xBillEntry : xBillEntryS) {
                String entrychangetype = xBillEntry.getString("entrychangetype");
                String sourceentryid = xBillEntry.getString("sourceentryid");
                String entryid = xBillEntry.getString("id");
                if ("B".equals(entrychangetype)) {
                    modifyData.put(sourceentryid, xBillEntry);
                    continue;
                }
                if ("A".equals(entrychangetype)) {
                    addData.put(entryid, xBillEntry);
                    continue;
                }
                if ("C".equals(entrychangetype) && pmIsDeleteEntryWay) {
                    removeData.put(sourceentryid, xBillEntry);
                    continue;
                }
                if (!"C".equals(entrychangetype) || pmIsDeleteEntryWay) continue;
                cleanData.put(sourceentryid, xBillEntry);
            }
        }
        StringBuilder pobillno = new StringBuilder();
        if (!modifyData.isEmpty() || !cleanData.isEmpty()) {
            for (DynamicObject billEntry : billEntryS) {
                DynamicObject xBillEntry;
                poentryid = billEntry.getString("poentryid");
                if (poentryid.isEmpty() || (xBillEntry = modifyData.get(poentryid) != null ? (DynamicObject)modifyData.get(poentryid) : (DynamicObject)cleanData.get(poentryid)) == null) continue;
                billEntry.set("qty", xBillEntry.get("qty"));
                billEntry.set("basicqty", xBillEntry.get("baseqty"));
                billEntry.set("unit", xBillEntry.get("unit"));
                billEntry.set("basicunit", xBillEntry.get("baseunit"));
                billEntry.set("price", xBillEntry.get("price"));
                billEntry.set("taxprice", xBillEntry.get("priceandtax"));
                billEntry.set("taxrate", xBillEntry.get("taxrate"));
                billEntry.set("amount", xBillEntry.get("amount"));
                billEntry.set("taxamount", xBillEntry.get("amountandtax"));
                billEntry.set("locamount", xBillEntry.get("curamount"));
                billEntry.set("loctaxamount", xBillEntry.get("curamountandtax"));
                billEntry.set("loctax", xBillEntry.get("curtaxamount"));
                billEntry.set("dctamount", xBillEntry.get("discountamount"));
                billEntry.set("dctrate", xBillEntry.get("discountrate"));
                billEntry.set("tax", xBillEntry.get("taxamount"));
                billEntry.set("note", xBillEntry.get("entrycomment"));
                billEntry.set("taxrateid", xBillEntry.get("taxrateid"));
                billEntry.set("entrydelidate", xBillEntry.get("deliverdate"));
                billEntry.set("promiseday", xBillEntry.get("promisedate"));
                billEntry.set("amountup", xBillEntry.get("amountup"));
                if (extendPlugins != null && !extendPlugins.isEmpty()) {
                    for (IPurOrderChangeSupport support : extendPlugins) {
                        support.putOrderEntryFields(billEntry, xBillEntry);
                    }
                }
                PurOrderBillActiveToPurOrderOpUtil.updateReceiveQty(billEntry, xBillEntry);
                PurOrderBillActiveToPurOrderOpUtil.updateDesQty(billEntry);
                String pobillnoTemp = billEntry.getString("pobillno");
                if (modifyData.get(poentryid) != null) {
                    PurOrderBillActiveToPurOrderOpUtil.updateEntryStatus(billEntry);
                } else if (cleanData.get(poentryid) != null) {
                    billEntry.set("entrystatus", (Object)"B");
                }
                if (pobillnoTemp.isEmpty() || pobillno.toString().contains(pobillnoTemp)) continue;
                pobillno.append(pobillnoTemp);
            }
        }
        if (!removeData.isEmpty()) {
            for (int i3 = billEntryS.size() - 1; i3 >= 0; --i3) {
                DynamicObject billEntry;
                billEntry = (DynamicObject)billEntryS.get(i3);
                poentryid = billEntry.getString("poentryid");
                if (poentryid.isEmpty() || !removeData.containsKey(poentryid) && !"0".equals(poentryid)) continue;
                billEntryS.remove((Object)billEntry);
            }
        }
        if (!addData.isEmpty()) {
            for (Map.Entry entry : addData.entrySet()) {
                DynamicObject xBillEntry = (DynamicObject)entry.getValue();
                DynamicObject billEntry = billEntryS.addNew();
                billEntry.set("material", (Object)xBillEntry.getDynamicObject("material").getDynamicObject("masterid"));
                billEntry.set("project", xBillEntry.get("project"));
                billEntry.set("entrydelidate", xBillEntry.get("deliverdate"));
                billEntry.set("unit", xBillEntry.get("unit"));
                billEntry.set("taxrate", xBillEntry.get("taxrate"));
                billEntry.set("taxrateid", xBillEntry.get("taxrateid"));
                billEntry.set("entryreqorg", xBillEntry.get("entryreqorg"));
                billEntry.set("entryrcvorg", xBillEntry.get("entryrecorg"));
                billEntry.set("entrypurorg", xBillEntry.get("entrypurorg"));
                billEntry.set("entrysettleorg", xBillEntry.get("entrysettleorg"));
                billEntry.set("entrypayorg", xBillEntry.get("entrypayorg"));
                billEntry.set("ispresent", xBillEntry.get("ispresent"));
                billEntry.set("deliaddr", bill.get("provideraddress"));
                billEntry.set("warehouse", xBillEntry.get("warehouse"));
                billEntry.set("purtype", (Object)"530841016689795072");
                billEntry.set("srcentryid", xBillEntry.get("sourceentryid"));
                billEntry.set("poentryid", (Object)xBillEntry.getString("id"));
                billEntry.set("pobillid", bill.get("sourceid"));
                billEntry.set("qty", xBillEntry.get("qty"));
                billEntry.set("basicqty", xBillEntry.get("baseqty"));
                billEntry.set("basicunit", xBillEntry.get("baseunit"));
                billEntry.set("price", xBillEntry.get("price"));
                billEntry.set("taxprice", xBillEntry.get("priceandtax"));
                billEntry.set("taxrate", xBillEntry.get("taxrate"));
                billEntry.set("amount", xBillEntry.get("amount"));
                billEntry.set("taxamount", xBillEntry.get("amountandtax"));
                billEntry.set("locamount", xBillEntry.get("curamount"));
                billEntry.set("loctaxamount", xBillEntry.get("curamountandtax"));
                billEntry.set("loctax", xBillEntry.get("curtaxamount"));
                billEntry.set("dctamount", xBillEntry.get("discountamount"));
                billEntry.set("dctrate", xBillEntry.get("discountrate"));
                billEntry.set("tax", xBillEntry.get("taxamount"));
                billEntry.set("note", xBillEntry.get("entrycomment"));
                billEntry.set("pobillno", (Object)pobillno.toString());
                billEntry.set("entrystatus", (Object)"A");
                billEntry.set("linetype", xBillEntry.get("linetype"));
                billEntry.set("entrydelidate", xBillEntry.get("deliverdate"));
                billEntry.set("promiseday", xBillEntry.get("promisedate"));
                if (extendPlugins != null && !extendPlugins.isEmpty()) {
                    for (IPurOrderChangeSupport support : extendPlugins) {
                        support.putOrderEntryFields(billEntry, xBillEntry);
                    }
                }
                PurOrderBillActiveToPurOrderOpUtil.updateReceiveQty(billEntry, xBillEntry);
                PurOrderBillActiveToPurOrderOpUtil.updateDesQty(billEntry);
                PurOrderBillActiveToPurOrderOpUtil.updateEntryStatus(billEntry);
            }
        }
        PurOrderBillActiveToPurOrderOpUtil.updateCloseBillStatus(srcBill, billEntryS);
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{srcBill});
    }

    private static void updateCloseBillStatus(DynamicObject srcBill, DynamicObjectCollection billEntryS) {
        Boolean isNotAllClose = false;
        for (DynamicObject billEntry : billEntryS) {
            String entrystatus = billEntry.getString("entrystatus");
            if (BillEntryStatusEnum.CLOSED.getVal().equals(entrystatus)) continue;
            isNotAllClose = true;
            break;
        }
        if (!isNotAllClose.booleanValue()) {
            Date now = TimeServiceHelper.now();
            srcBill.set("billstatus", (Object)"D");
            srcBill.set("closer_id", (Object)RequestContext.get().getCurrUserId());
            srcBill.set("closedate", (Object)now);
        }
    }

    private static void updateReceiveQty(DynamicObject billEntry, DynamicObject xBillEntry) {
        billEntry.set("saloutqtydown", xBillEntry.get("receiveqtydown"));
        billEntry.set("saloutbaseqtydown", xBillEntry.get("receivebaseqtydown"));
        billEntry.set("saloutqtyup", xBillEntry.get("receiveqtyup"));
        billEntry.set("saloutbaseqtyup", xBillEntry.get("receivebaseqtyup"));
        billEntry.set("saloutrateup", xBillEntry.get("receiverateup"));
        billEntry.set("saloutratedown", xBillEntry.get("receiveratedown"));
        billEntry.set("iscontrolqty", (Object)"1");
    }

    public static void updateOrderLogstatus(DynamicObject srcBill) {
        HashMap<String, Object> logStatusParams = new HashMap<String, Object>();
        HashMap<String, Object> cfmStatusParams = new HashMap<String, Object>();
        srcBill.set("cfmstatus", (Object)"B");
        DynamicObject[] dynamicObjects = new DynamicObject[]{srcBill};
        OrderUtil.updateOrderCfmStatus((DynamicObject[])dynamicObjects, (boolean)false);
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dynamicObjects);
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"pur_order", (Long[])new Long[]{(Long)srcBill.getPkValue()});
        Set setId = (Set)sourceBills.get("pm_purorderbill");
        if (null != setId) {
            ArrayList PoBillPks = new ArrayList(setId);
            logStatusParams.put("ids", PoBillPks);
            cfmStatusParams.put("ids", PoBillPks);
            logStatusParams.put("status", srcBill.get("logstatus"));
            cfmStatusParams.put("status", srcBill.get("cfmstatus"));
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PmSupColService", (String)"upOrderConfirmStatus", (Object[])new Object[]{cfmStatusParams});
            DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PmSupColService", (String)"upLogisticsStatus", (Object[])new Object[]{logStatusParams});
        }
    }

    private static void updateEntryStatus(DynamicObject billEntry) {
        BigDecimal sumreceiptbaseqty;
        DynamicObject lineType = billEntry.getDynamicObject("linetype");
        BigDecimal sumrefundbaseqty = billEntry.getBigDecimal("sumrefundbaseqty");
        BigDecimal saloutbaseqtydown = billEntry.getBigDecimal("saloutbaseqtydown");
        if (lineType.getString("number").equals("010")) {
            BigDecimal suminstockbaseqty = billEntry.getBigDecimal("suminstockbaseqty");
            if (suminstockbaseqty.subtract(sumrefundbaseqty).compareTo(saloutbaseqtydown) >= 0) {
                billEntry.set("entrystatus", (Object)BillEntryStatusEnum.CLOSED.getVal());
            }
        } else if (lineType.getString("number").startsWith("030") && (sumreceiptbaseqty = billEntry.getBigDecimal("sumreceiptbaseqty")).subtract(sumrefundbaseqty).compareTo(saloutbaseqtydown) >= 0) {
            billEntry.set("entrystatus", (Object)BillEntryStatusEnum.CLOSED.getVal());
        }
    }

    private static boolean getPmIsDeleteEntryWay() {
        Boolean IsEnableDeleteLine = (Boolean)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurChangeOrderBillService", (String)"getIsEnableDeleteLine", (Object[])new Object[0]);
        return IsEnableDeleteLine;
    }

    private static void updateDesQty(DynamicObject billEntry) {
        DynamicObject materialObj = billEntry.getDynamicObject("material");
        DynamicObject unitObj = billEntry.getDynamicObject("unit");
        DynamicObject basicUnitObj = billEntry.getDynamicObject("basicunit");
        billEntry.set("schedulebaseqty", (Object)CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)billEntry.getBigDecimal("scheduleqty"), (DynamicObject)basicUnitObj));
        billEntry.set("relateoutstockbaseqty", (Object)CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)billEntry.getBigDecimal("relateoutstockqty"), (DynamicObject)basicUnitObj));
        billEntry.set("sumoutstockbaseqty", (Object)CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)billEntry.getBigDecimal("sumoutstockqty"), (DynamicObject)basicUnitObj));
        billEntry.set("sumrecretbaseqty", (Object)CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)billEntry.getBigDecimal("sumrecretqty"), (DynamicObject)basicUnitObj));
        billEntry.set("suminstockretbaseqty", (Object)CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)billEntry.getBigDecimal("suminstockretqty"), (DynamicObject)basicUnitObj));
        billEntry.set("sumrefundbaseqty", (Object)CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)billEntry.getBigDecimal("sumrefundqty"), (DynamicObject)basicUnitObj));
        billEntry.set("sumreceiptbaseqty", (Object)CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)billEntry.getBigDecimal("sumreceiptqty"), (DynamicObject)basicUnitObj));
        billEntry.set("suminstockbaseqty", (Object)CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)billEntry.getBigDecimal("suminstockqty"), (DynamicObject)basicUnitObj));
    }
}

