/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.pur.service.ICancelVerifyService;

public class CancelVerifyService
implements ICancelVerifyService {
    private static final Log log = LogFactory.getLog(CancelVerifyService.class);

    public Map<String, Object> CanCancelVerify(String entityKey, String entryKey, Map<Long, List<Long>> billIds) throws KDException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("succed", Boolean.FALSE);
        resultMap.put("message", "");
        log.info("CancelVerifyService#CanCancelVerify#begin_check_param");
        if (Objects.nonNull(entityKey) && !entityKey.trim().isEmpty() && Objects.nonNull(billIds) && !billIds.isEmpty() && Objects.nonNull(entryKey) && !entryKey.trim().isEmpty()) {
            log.info("CanCancelVerify:entityKey" + entityKey);
            log.info("CanCancelVerify:entryKey" + entryKey);
            log.info("CanCancelVerify:billIds" + billIds);
            ArrayList listEntryIds = new ArrayList(1024);
            for (Map.Entry<Long, List<Long>> entry : billIds.entrySet()) {
                listEntryIds.addAll(entry.getValue());
            }
            List bfRowList = BFTrackerServiceHelper.loadTargetRowIds((String)entityKey, (String)entryKey, (Long[])billIds.keySet().toArray(new Long[0]), (Long[])listEntryIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
            HashSet<String> verifyEntryId = new HashSet<String>(1024);
            for (BFRow bfRow : bfRowList) {
                Long entryId = bfRow.getSId().getEntryId();
                if (!listEntryIds.contains(entryId)) continue;
                verifyEntryId.add(String.valueOf(bfRow.getId().getEntryId()));
            }
            log.info("CanCancelVerify:verifyEntryId" + verifyEntryId);
            ArrayList<String> verifySrcType = new ArrayList<String>(16);
            if ("im_purinbill".equals(entityKey) || "im_mdc_omcmplinbill".equals(entityKey)) {
                verifySrcType.add("pur_instock");
                verifySrcType.add("pur_return");
                verifySrcType.add("scp_instock");
                verifySrcType.add("scp_return");
            } else if ("im_purreceivebill".equals(entityKey) || "pm_puracceptbill".equals(entityKey)) {
                verifySrcType.add("pur_receipt");
                verifySrcType.add("pur_receipt_return");
                verifySrcType.add("scp_receipt");
                verifySrcType.add("scp_return_receipt");
            }
            log.info("CanCancelVerify:verifySrcType" + verifySrcType);
            HashMap<String, List<String>> checkOfMap = new HashMap<String, List<String>>(billIds.size());
            if (!verifyEntryId.isEmpty()) {
                List<String> entryIds;
                String srcentryid;
                String srcbillid;
                Row row2;
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pur_check", (String)"materialentry.srcentryid srcentryid,materialentry.srcbillid srcbillid,materialentry.srcbilltype srcbilltype", (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", verifyEntryId).and(new QFilter("materialentry.srcbilltype", "in", verifySrcType)).and(new QFilter("billstatus", "in", (Object)"C"))}, (String)"id");
                Object object = null;
                try {
                    while (dataSet.hasNext()) {
                        row2 = dataSet.next();
                        srcbillid = row2.getString("srcbillid");
                        srcentryid = row2.getString("srcentryid");
                        entryIds = (ArrayList<String>)checkOfMap.get(srcbillid);
                        if (entryIds != null) {
                            entryIds.add(srcentryid);
                            continue;
                        }
                        entryIds = new ArrayList<String>(1024);
                        entryIds.add(srcentryid);
                        checkOfMap.putIfAbsent(srcbillid, entryIds);
                    }
                }
                catch (Throwable row2) {
                    object = row2;
                    throw row2;
                }
                finally {
                    if (dataSet != null) {
                        if (object != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable row2) {
                                ((Throwable)object).addSuppressed(row2);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
                dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pur_invoice", (String)"entryentity1.srcbilltype1 srcbilltype,entryentity1.srcbillid1 srcbillid,entryentity1.srcentryid1 srcentryid", (QFilter[])new QFilter[]{new QFilter("entryentity1.srcentryid1", "in", verifyEntryId).and(new QFilter("entryentity1.srcbilltype1", "in", verifySrcType))}, (String)"id");
                object = null;
                try {
                    while (dataSet.hasNext()) {
                        row2 = dataSet.next();
                        srcbillid = row2.getString("srcbillid");
                        srcentryid = row2.getString("srcentryid");
                        entryIds = (List)checkOfMap.get(srcbillid);
                        if (entryIds != null) {
                            entryIds.add(srcentryid);
                            continue;
                        }
                        entryIds = new ArrayList(1024);
                        entryIds.add(srcentryid);
                        checkOfMap.putIfAbsent(srcbillid, entryIds);
                    }
                }
                catch (Throwable row3) {
                    object = row3;
                    throw row3;
                }
                finally {
                    if (dataSet != null) {
                        if (object != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable row3) {
                                ((Throwable)object).addSuppressed(row3);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
            String verifyMessage = ResManager.loadKDString((String)"\u8bf7\u5173\u6ce8\u542f\u7528\u534f\u540c\u662f\u5426\u592a\u665a\uff0c\u6570\u636e\u6ca1\u6709\u540c\u6b65\u5230\u534f\u540c\u3002", (String)"CancelVerifyService_1", (String)"scm-pur-mservice", (Object[])new Object[0]);
            log.info("CanCancelVerify:verifyMessage" + verifyMessage);
            log.info("CanCancelVerify:checkOfMap" + checkOfMap);
            HashMap<Long, ArrayList<Long>> resultDataMap = new HashMap<Long, ArrayList<Long>>(1024);
            if (!checkOfMap.isEmpty()) {
                for (BFRow bfRow : bfRowList) {
                    BFRowId bfRowId = bfRow.getId();
                    Long billId = bfRowId.getBillId();
                    Long bfRowIdEntryId = bfRowId.getEntryId();
                    List checkEntryOfMap = (List)checkOfMap.get(String.valueOf(billId));
                    if (checkEntryOfMap == null || checkEntryOfMap.isEmpty()) continue;
                    BFRowId bfsRowId = bfRow.getSId();
                    Long bfsRowIdEntryId = bfsRowId.getEntryId();
                    Long bfsRowIdBillId = bfsRowId.getBillId();
                    ArrayList<Long> resultEntryDataList = (ArrayList<Long>)resultDataMap.get(bfsRowIdBillId);
                    if (checkEntryOfMap.contains(String.valueOf(bfRowIdEntryId))) {
                        if (resultEntryDataList != null) {
                            resultEntryDataList.add(bfsRowIdEntryId);
                        } else {
                            resultEntryDataList = new ArrayList<Long>(1024);
                            resultEntryDataList.add(bfsRowIdEntryId);
                        }
                    }
                    resultDataMap.putIfAbsent(bfsRowIdBillId, resultEntryDataList);
                }
                resultMap.put("data", resultDataMap);
                resultMap.put("message", ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u5bf9\u8d26\u6216\u8005\u5f00\u7968\uff0c\u6682\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CancelVerifyService_2", (String)"scm-pur-mservice", (Object[])new Object[0]));
            } else {
                resultMap.put("succed", Boolean.TRUE);
                resultMap.put("data", resultDataMap);
            }
        } else {
            String verifyMessage = ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u53c2\u6570\u4e0d\u5408\u6cd5\u3002", (String)"CancelVerifyService_0", (String)"scm-pur-mservice", (Object[])new Object[0]);
            throw new KDException(new ErrorCode("VERIFY_CODE_002", verifyMessage), new Object[]{new Throwable()});
        }
        return resultMap;
    }

    public String CanCancelVerify(String entitykey, String verifylist) throws KDException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("succed", Boolean.FALSE);
        resultMap.put("message", "");
        if (Objects.nonNull(entitykey) && !entitykey.trim().isEmpty() && Objects.nonNull(verifylist) && !verifylist.isEmpty()) {
            log.info("CanCancelVerify:entitykey" + entitykey);
            log.info("CanCancelVerify:verifylist" + verifylist);
            Map mapList = (Map)SerializationUtils.fromJsonString((String)verifylist, Map.class);
            ArrayList listEntryIds = new ArrayList(1024);
            for (Map.Entry entry : mapList.entrySet()) {
                listEntryIds.addAll((Collection)entry.getValue());
            }
            ArrayList<String> verifySrcType = new ArrayList<String>(16);
            ArrayList<String> queryEntity = new ArrayList<String>(2);
            if ("STK_InStock".equals(entitykey)) {
                verifySrcType.add("pur_instock");
                verifySrcType.add("scp_instock");
                queryEntity.add("pur_instock");
            } else if ("PUR_MRB".equals(entitykey)) {
                verifySrcType.add("pur_return");
                verifySrcType.add("scp_return");
                verifySrcType.add("scp_return_receipt");
                verifySrcType.add("pur_receipt_return");
                queryEntity.add("pur_receipt_return");
                queryEntity.add("pur_return");
                verifySrcType.add("pur_receipt");
                verifySrcType.add("scp_receipt");
            } else if ("PUR_ReceiveBill".equals(entitykey)) {
                verifySrcType.add("pur_receipt");
                verifySrcType.add("scp_receipt");
                queryEntity.add("pur_receipt");
            }
            HashSet<String> verifyEntryId = new HashSet<String>(1024);
            ArrayList<VerifyRow> verifyRowList = new ArrayList<VerifyRow>();
            for (String entity : queryEntity) {
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)entity, (String)"id,materialentry.id entryid,materialentry.srcbillid srcbillid,materialentry.srcentryid srcentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcbillid", "in", mapList.keySet()).and(new QFilter("materialentry.srcentryid", "in", listEntryIds))}, (String)"id");
                Throwable throwable = null;
                try {
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        verifyEntryId.add(row.getString("entryid"));
                        VerifyRowId verifyRowId = new VerifyRowId();
                        verifyRowId.setBillid(row.getString("id"));
                        verifyRowId.setEntryid(row.getString("entryid"));
                        VerifyRowId verifyRowEId = new VerifyRowId();
                        verifyRowEId.setBillid(row.getString("srcbillid"));
                        verifyRowEId.setEntryid(row.getString("srcentryid"));
                        VerifyRow verifyRow = new VerifyRow();
                        verifyRow.setVerifyRowId(verifyRowId);
                        verifyRow.setVerifyRowEId(verifyRowEId);
                        verifyRowList.add(verifyRow);
                    }
                }
                catch (Throwable row) {
                    throwable = row;
                    throw row;
                }
                finally {
                    if (dataSet == null) continue;
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable row) {
                            throwable.addSuppressed(row);
                        }
                        continue;
                    }
                    dataSet.close();
                }
            }
            log.info("CanCancelVerify:verifySrcType" + verifySrcType);
            log.info("CanCancelVerify:verifyEntryId" + verifyEntryId);
            HashMap<String, List<String>> checkOfMap = new HashMap<String, List<String>>(mapList.size());
            if (!verifyEntryId.isEmpty()) {
                List<String> entryIds;
                String srcentryid;
                String srcbillid;
                Row row2;
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pur_check", (String)"materialentry.srcentryid srcentryid,materialentry.srcbillid srcbillid,materialentry.srcbilltype srcbilltype", (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", verifyEntryId).and(new QFilter("materialentry.srcbilltype", "in", verifySrcType)).and(new QFilter("billstatus", "in", (Object)"C"))}, (String)"id");
                Object object = null;
                try {
                    while (dataSet.hasNext()) {
                        row2 = dataSet.next();
                        srcbillid = row2.getString("srcbillid");
                        srcentryid = row2.getString("srcentryid");
                        entryIds = (ArrayList<String>)checkOfMap.get(srcbillid);
                        if (entryIds != null) {
                            entryIds.add(srcentryid);
                            continue;
                        }
                        entryIds = new ArrayList<String>(1024);
                        entryIds.add(srcentryid);
                        checkOfMap.putIfAbsent(srcbillid, entryIds);
                    }
                }
                catch (Throwable row2) {
                    object = row2;
                    throw row2;
                }
                finally {
                    if (dataSet != null) {
                        if (object != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable row2) {
                                ((Throwable)object).addSuppressed(row2);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
                dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pur_invoice", (String)"entryentity1.srcbilltype1 srcbilltype,entryentity1.srcbillid1 srcbillid,entryentity1.srcentryid1 srcentryid", (QFilter[])new QFilter[]{new QFilter("entryentity1.srcentryid1", "in", verifyEntryId).and(new QFilter("entryentity1.srcbilltype1", "in", verifySrcType))}, (String)"id");
                object = null;
                try {
                    while (dataSet.hasNext()) {
                        row2 = dataSet.next();
                        srcbillid = row2.getString("srcbillid");
                        srcentryid = row2.getString("srcentryid");
                        entryIds = (List)checkOfMap.get(srcbillid);
                        if (entryIds != null) {
                            entryIds.add(srcentryid);
                            continue;
                        }
                        entryIds = new ArrayList(1024);
                        entryIds.add(srcentryid);
                        checkOfMap.putIfAbsent(srcbillid, entryIds);
                    }
                }
                catch (Throwable row3) {
                    object = row3;
                    throw row3;
                }
                finally {
                    if (dataSet != null) {
                        if (object != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable row3) {
                                ((Throwable)object).addSuppressed(row3);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
            String verifyMessage = ResManager.loadKDString((String)"\u8bf7\u5173\u6ce8\u542f\u7528\u534f\u540c\u662f\u5426\u592a\u665a\uff0c\u6570\u636e\u6ca1\u6709\u540c\u6b65\u5230\u534f\u540c\u3002", (String)"CancelVerifyService_1", (String)"scm-pur-mservice", (Object[])new Object[0]);
            log.warn("CanCancelVerify:verifyMessage" + verifyMessage);
            log.info("CanCancelVerify:checkOfMap" + checkOfMap);
            HashMap<String, ArrayList<String>> resultDataMap = new HashMap<String, ArrayList<String>>(1024);
            if (!checkOfMap.isEmpty()) {
                for (VerifyRow verifyRow : verifyRowList) {
                    VerifyRowId verifyRowId = verifyRow.getVerifyRowId();
                    String verifyRowIdBillid = verifyRowId.getBillid();
                    String verifyRowIdEntryid = verifyRowId.getEntryid();
                    List checkEntryOfMap = (List)checkOfMap.get(String.valueOf(verifyRowIdBillid));
                    if (checkEntryOfMap == null || checkEntryOfMap.isEmpty()) continue;
                    VerifyRowId verifyRowEId = verifyRow.getVerifyRowEId();
                    String verifyRowEIdBillid = verifyRowEId.getBillid();
                    String verifyRowEIdEntryid = verifyRowEId.getEntryid();
                    ArrayList<String> resultEntryDataList = (ArrayList<String>)resultDataMap.get(verifyRowEIdBillid);
                    if (checkEntryOfMap.contains(verifyRowIdEntryid)) {
                        if (resultEntryDataList != null) {
                            resultEntryDataList.add(verifyRowEIdEntryid);
                        } else {
                            resultEntryDataList = new ArrayList<String>(1024);
                            resultEntryDataList.add(verifyRowEIdEntryid);
                        }
                    }
                    resultDataMap.putIfAbsent(verifyRowEIdBillid, resultEntryDataList);
                }
                resultMap.put("succed", Boolean.FALSE);
                resultMap.put("data", resultDataMap);
            } else {
                resultMap.put("succed", Boolean.TRUE);
                resultMap.put("data", resultDataMap);
            }
        }
        return SerializationUtils.toJsonString(resultMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Object> CanCancelVerify(Map<String, Object> paramMap) throws KDException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("succed", Boolean.FALSE);
        resultMap.put("message", "");
        String verifyMessage = ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u53c2\u6570\u4e0d\u5408\u6cd5\u3002", (String)"CancelVerifyService_0", (String)"scm-pur-mservice", (Object[])new Object[0]);
        if (paramMap == null || paramMap.isEmpty()) throw new KDException(new ErrorCode("VERIFY_CODE_002", verifyMessage), new Object[]{new Throwable()});
        Object entityName = paramMap.get("entityName");
        Object entryKey = paramMap.get("entryKey");
        Object bills = paramMap.get("billIds");
        if (entityName == null || entryKey == null || !(bills instanceof Map)) throw new KDException(new ErrorCode("VERIFY_CODE_002", verifyMessage), new Object[]{new Throwable()});
        Boolean isListEntry = Boolean.TRUE;
        for (Map.Entry entry : ((Map)bills).entrySet()) {
            if (entry.getValue() instanceof List) continue;
            isListEntry = Boolean.FALSE;
        }
        if (!isListEntry.booleanValue()) {
            throw new KDException(new ErrorCode("VERIFY_CODE_002", verifyMessage), new Object[]{new Throwable()});
        }
        resultMap.putAll(this.CanCancelVerify(entityName.toString(), entryKey.toString(), (Map)bills));
        return resultMap;
    }

    private static class VerifyRowId {
        private String billid;
        private String entryid;

        private VerifyRowId() {
        }

        public VerifyRowId(String billid, String entryid) {
            this.billid = billid;
            this.entryid = entryid;
        }

        private String getBillid() {
            return this.billid;
        }

        private void setBillid(String billid) {
            this.billid = billid;
        }

        private String getEntryid() {
            return this.entryid;
        }

        private void setEntryid(String entryid) {
            this.entryid = entryid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VerifyRowId that = (VerifyRowId)o;
            return Objects.equals(this.billid, that.billid) && Objects.equals(this.entryid, that.entryid);
        }

        public int hashCode() {
            return Objects.hash(this.billid, this.entryid);
        }
    }

    private static class VerifyRow {
        private VerifyRowId verifyRowId;
        private VerifyRowId verifyRowEId;

        private VerifyRow() {
        }

        private VerifyRowId getVerifyRowId() {
            return this.verifyRowId;
        }

        private void setVerifyRowId(VerifyRowId verifyRowId) {
            this.verifyRowId = verifyRowId;
        }

        private VerifyRowId getVerifyRowEId() {
            return this.verifyRowEId;
        }

        private void setVerifyRowEId(VerifyRowId verifyRowEId) {
            this.verifyRowEId = verifyRowEId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VerifyRow verifyRow = (VerifyRow)o;
            return Objects.equals(this.verifyRowId, verifyRow.verifyRowId) && Objects.equals(this.verifyRowEId, verifyRow.verifyRowEId);
        }

        public int hashCode() {
            return Objects.hash(this.verifyRowId, this.verifyRowEId);
        }
    }
}

