/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.ScMultiDataHandleServiceHelper;
import kd.scm.common.helper.scdatahandle.ScDataHandleResult;
import kd.scm.common.helper.scdatahandle.ScDataHandleServiceHelper;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.pur.service.IXKNewChangeService;

public class XKNewChangeService
implements IXKNewChangeService {
    private static final Log log = LogFactory.getLog(XKNewChangeService.class);

    public void writeBackStatus(List<String> billNo) {
        try {
            HashMap param = new HashMap(0);
            DynamicObjectCollection orders = QueryServiceHelper.query((String)"pur_order", (String)"id,billno,cfmstatus,materialentry.pobillid pobillid,logstatus", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNo)});
            MultiDataHandleResult result = ScMultiDataHandleServiceHelper.executeManualSceneHandle((String)"xkchangetopur", (List)orders, param);
            ArrayList<Long> confirmOrderIds = new ArrayList<Long>(16);
            ArrayList<Long> unConfirmOrderIds = new ArrayList<Long>(16);
            for (DynamicObject order : orders) {
                String cfmstatus = order.getString("cfmstatus");
                long id = order.getLong("id");
                if ("A".equals(cfmstatus)) {
                    unConfirmOrderIds.add(id);
                    continue;
                }
                if (!"B".equals(cfmstatus)) continue;
                confirmOrderIds.add(id);
            }
            DynamicObjectType type = BusinessDataServiceHelper.newDynamicObject((String)"pur_order").getDynamicObjectType();
            DynamicObject[] confirmOrderArr = BusinessDataServiceHelper.load((Object[])confirmOrderIds.toArray(), (DynamicObjectType)type);
            DynamicObject[] unConfirmOrderArr = BusinessDataServiceHelper.load((Object[])unConfirmOrderIds.toArray(), (DynamicObjectType)type);
            XKNewChangeService.executeOrderConfirmOrUnConfirm(unConfirmOrderArr, "orderunconfirm");
            XKNewChangeService.executeOrderConfirmOrUnConfirm(confirmOrderArr, "orderconfirm");
        }
        catch (Exception e) {
            throw new KDBizException("Failed to reverse write the confirmation status and logistics status of the starry sky order: " + e.getMessage());
        }
    }

    public static ScDataHandleResult executeOrderConfirmOrUnConfirm(DynamicObject[] orderBills, String confirmLog) {
        ScDataHandleResult scDataHandleResult = null;
        if (XKNewChangeService.verifyNeedOffset(confirmLog, XKNewChangeService.getChannelIds(orderBills))) {
            scDataHandleResult = ScDataHandleServiceHelper.executeHandle((String)confirmLog, (DynamicObject[])orderBills);
        } else {
            scDataHandleResult = new ScDataHandleResult();
            scDataHandleResult.setSuccess(true);
            scDataHandleResult.setStartTime(TimeServiceHelper.now());
        }
        return scDataHandleResult;
    }

    private static boolean verifyNeedOffset(String defineScene, Collection<String> channelIds) {
        HashMap<String, Boolean> channelEnableMap = new HashMap<String, Boolean>(channelIds.size());
        Map dataExecuteSchemeCacheMap = BusinessDataServiceHelper.loadFromCache((String)"pbd_dataexecutescheme", (QFilter[])new QFilter[]{new QFilter("executescene.number", "=", (Object)defineScene).and(new QFilter("executechannel.id", "in", channelIds))});
        if (!dataExecuteSchemeCacheMap.isEmpty()) {
            for (Map.Entry entry : dataExecuteSchemeCacheMap.entrySet()) {
                DynamicObject entryValue = (DynamicObject)entry.getValue();
                String executeChannel = entryValue.getString("executechannel.id");
                boolean enable = entryValue.getBoolean("enable");
                if (!enable) continue;
                channelEnableMap.put(executeChannel, true);
            }
        }
        return channelEnableMap.size() < channelIds.size();
    }

    private static Collection<String> getChannelIds(DynamicObject[] dynamicObjects) {
        HashSet<String> jointDataChannelIds = new HashSet<String>(8);
        HashMap<Object, String> logMap = new HashMap<Object, String>(8);
        String jointChannelId = SystemJointChannelHelper.getDefaultJointChannelId();
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            DynamicProperty jointChannelProperty = rows.getDynamicObjectType().getProperty("jointdatachannelid");
            if (jointChannelProperty != null) {
                try {
                    DynamicObject row;
                    Object jointChannelIdValue;
                    if (!rows.isEmpty() && (jointChannelIdValue = jointChannelProperty.getValue((Object)(row = (DynamicObject)rows.get(0)))) != null && !"".equals(jointChannelIdValue)) {
                        jointChannelId = String.valueOf(jointChannelIdValue);
                    }
                }
                catch (RuntimeException runtimeException) {
                    logMap.put(bill.getPkValue(), runtimeException.getMessage());
                }
                jointDataChannelIds.add(jointChannelId);
                continue;
            }
            jointDataChannelIds.add(jointChannelId);
        }
        log.info("getChannelIds# logMap={}", (Object)JSON.toJSONString(logMap));
        return jointDataChannelIds;
    }
}

