/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.autopush;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.helper.multisystemjoint.param.ScMultiCosmicStdParamArgs;
import kd.scm.common.helper.transfer.SDKTransferHelper;
import kd.scm.common.helper.transfer.SRMTransferDataHelper;
import kd.scm.common.helper.transfer.entity.TransferInfo;
import kd.scm.pur.business.AutoPurAcceptBillSupportDefault;

public class PurAutoAcceptApplyStdAssmbleUtil {
    private static Log log = LogFactory.getLog(PurAutoAcceptApplyStdAssmbleUtil.class);
    private static final String PM_PURORDER = "pm_purorderbill";
    private static final String PM_PURACCEPTBILL = "pm_puracceptbill";

    public static ScMultiCosmicStdParamArgs assembleCosmucStdParamArgs(List<DynamicObject> list) {
        ScMultiCosmicStdParamArgs cosmicStdParamArgs = new ScMultiCosmicStdParamArgs();
        HashSet<String> salOutEntryIds = new HashSet<String>(16);
        Map<String, String> autoExtEntryPro = PurAutoAcceptApplyStdAssmbleUtil.assembleAutoExtEntryPro();
        HashMap<String, Object> toStockParamMap = new HashMap<String, Object>(2);
        LinkedHashMap<Long, HashSet<Long>> pushOrderData = new LinkedHashMap<Long, HashSet<Long>>(20);
        LinkedHashMap<String, ArrayList<Map<String, String>>> rowSalOutInfoMap = new LinkedHashMap<String, ArrayList<Map<String, String>>>(56);
        for (DynamicObject bill : list) {
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : rows) {
                String entrystatus = row.getString("entrystatus");
                if ("B".equals(entrystatus)) continue;
                String poBillId = row.getString("pobillid");
                String poEntryId = row.getString("poentryid");
                if (poBillId.isEmpty() || poEntryId.isEmpty()) continue;
                salOutEntryIds.add(row.getString("id"));
                HashSet<Long> orderEntry = (HashSet<Long>)pushOrderData.get(Long.parseLong(poBillId));
                if (orderEntry != null) {
                    orderEntry.add(Long.parseLong(poEntryId));
                } else {
                    orderEntry = new HashSet<Long>(16);
                    orderEntry.add(Long.parseLong(poEntryId));
                    pushOrderData.put(Long.parseLong(poBillId), orderEntry);
                }
                ArrayList<Map<String, String>> salOutInfoS = (ArrayList<Map<String, String>>)rowSalOutInfoMap.get(poEntryId);
                if (salOutInfoS != null) {
                    salOutInfoS.add(PurAutoAcceptApplyStdAssmbleUtil.assembleCosmicSelfParam(poEntryId, bill, row, autoExtEntryPro));
                    continue;
                }
                salOutInfoS = new ArrayList<Map<String, String>>();
                salOutInfoS.add(PurAutoAcceptApplyStdAssmbleUtil.assembleCosmicSelfParam(poEntryId, bill, row, autoExtEntryPro));
                rowSalOutInfoMap.put(poEntryId, salOutInfoS);
            }
        }
        toStockParamMap.put("sourceEntity", PM_PURORDER);
        toStockParamMap.put("targetEntity", PM_PURACCEPTBILL);
        toStockParamMap.put("pushOrderData", pushOrderData);
        toStockParamMap.put("rowSalOutInfoMap", rowSalOutInfoMap);
        toStockParamMap.put("salOutEntryIds", salOutEntryIds);
        toStockParamMap.put("isAmountCriterion", "true");
        cosmicStdParamArgs.setCloudId("scm");
        cosmicStdParamArgs.setAppId("pur");
        cosmicStdParamArgs.setServiceName("IPurAcceptApplyToPuracceptbillService");
        cosmicStdParamArgs.setMethodName("acceptApplyToPuracceptbill");
        cosmicStdParamArgs.setParamMap(toStockParamMap);
        return cosmicStdParamArgs;
    }

    public static Map<String, String> assembleAutoExtEntryPro() {
        LinkedHashMap<String, String> sdkEntryMap = new LinkedHashMap<String, String>(16);
        TransferInfo transferInfo = SRMTransferDataHelper.getTransferInfo((String)"srmautostock");
        Map transferTypeMap = transferInfo.getTransferTypeMap();
        if (!transferTypeMap.isEmpty()) {
            String number = transferTypeMap.getOrDefault("number", "SCM_SCP_AUTOSTOCK_SUPPORT");
            String anInterface = transferTypeMap.getOrDefault("interface", "kd.sdk.scm.scp.extpoint.IAutoStockSupport");
            Class type = null;
            try {
                type = TypesContainer.getOrRegister((String)anInterface);
                sdkEntryMap.putAll(SDKTransferHelper.getSDKEntryMap((String)number, (Class)type, AutoPurAcceptBillSupportDefault.class));
            }
            catch (Throwable throwable) {
                log.error(throwable);
            }
        }
        return sdkEntryMap;
    }

    private static Map<String, String> assembleCosmicSelfParam(String poEntryId, DynamicObject bill, DynamicObject row, Map<String, String> autoExtEntryPro) {
        Map<String, String> autoExtStockBill;
        LinkedHashMap<String, String> salOutInfoMap = new LinkedHashMap<String, String>(50);
        String billNo = bill.getString("billno");
        String billId = bill.getString("id");
        String entryId = row.getString("id");
        BigDecimal qty = row.getBigDecimal("qty");
        String note = row.getString("note");
        BigDecimal taxamount = row.getBigDecimal("taxamount");
        salOutInfoMap.put("qty_" + poEntryId, qty.toPlainString());
        salOutInfoMap.put("amountandtax_" + poEntryId, taxamount.toPlainString());
        salOutInfoMap.put("soubillnumber_" + poEntryId, billNo);
        salOutInfoMap.put("soubillid_" + poEntryId, billId);
        salOutInfoMap.put("soubillentryid_" + poEntryId, entryId);
        if (note != null) {
            salOutInfoMap.put("entrycomment_" + poEntryId, note);
        }
        if (!(autoExtStockBill = PurAutoAcceptApplyStdAssmbleUtil.assembleAutoExtStockBill(row, autoExtEntryPro)).isEmpty()) {
            for (Map.Entry<String, String> entry : autoExtStockBill.entrySet()) {
                salOutInfoMap.put(entry.getKey() + "_" + poEntryId, entry.getValue());
            }
        }
        return salOutInfoMap;
    }

    public static Map<String, String> assembleAutoExtStockBill(DynamicObject bill, Map<String, String> sdkEntryMap) {
        LinkedHashMap<String, String> extStockData = new LinkedHashMap<String, String>(16);
        extStockData.putAll(SDKTransferHelper.executeTransfer((DynamicObject)bill, sdkEntryMap));
        return extStockData;
    }

    public static ScMultiCosmicStdParamArgs assembleDeleteCosmucStdParamArgs(List<DynamicObject> list) {
        ScMultiCosmicStdParamArgs cosmicStdParamArgs = new ScMultiCosmicStdParamArgs();
        Set<Long> assembleStdSalOutDataMap = PurAutoAcceptApplyStdAssmbleUtil.assembleStdCleanAutoReceive(list);
        Set<String> assembleStdAutoReceiveBillNo = PurAutoAcceptApplyStdAssmbleUtil.assembleStdAutoReceiveBillNo(list);
        HashMap<String, Set<Object>> toStockParamMap = new HashMap<String, Set<Object>>(2);
        toStockParamMap.put("imReceiveBillIds", assembleStdSalOutDataMap);
        toStockParamMap.put("imReceiveBillNo", assembleStdAutoReceiveBillNo);
        cosmicStdParamArgs.setCloudId("scm");
        cosmicStdParamArgs.setAppId("pur");
        cosmicStdParamArgs.setServiceName("IPurAcceptApplyToPuracceptbillService");
        cosmicStdParamArgs.setMethodName("acceptApplyDelPuracceptbill");
        cosmicStdParamArgs.setParamMap(toStockParamMap);
        return cosmicStdParamArgs;
    }

    private static Set<Long> assembleStdCleanAutoReceive(List<DynamicObject> dynamicObjects) {
        HashSet<Long> imReceiveBillIds = new HashSet<Long>(8);
        HashSet<Long> salOutBillIds = new HashSet<Long>(8);
        for (DynamicObject bill : dynamicObjects) {
            Long billId = bill.getLong("id");
            salOutBillIds.add(billId);
        }
        if (!salOutBillIds.isEmpty()) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)PM_PURACCEPTBILL, (String)"id", (QFilter[])new QFilter[]{new QFilter("billentry.soubillid", "in", salOutBillIds)}, (String)"id");){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    imReceiveBillIds.add(row.getLong("id"));
                }
            }
        }
        return imReceiveBillIds;
    }

    private static Set<String> assembleStdAutoReceiveBillNo(List<DynamicObject> dynamicObjects) {
        HashSet<String> imReceiveBillIds = new HashSet<String>(8);
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : dynamicObjectCollection) {
                String autorecbillno = row.getString("autorecbillno");
                if (autorecbillno.trim().isEmpty()) continue;
                imReceiveBillIds.add(autorecbillno);
            }
        }
        return imReceiveBillIds;
    }
}

