/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.common.util.SaloutUtil;
import kd.scm.common.util.caldynamic.CalDynamicFactory;
import kd.scm.common.util.caldynamic.ICalDynamic;
import kd.scm.pur.service.IPurReceiptBillService;

public final class PurReceiptBillService
extends BaseECService
implements IPurReceiptBillService {
    private static final Log log = LogFactory.getLog(PurReceiptBillService.class);

    protected DtxResponse doExecute(Object param, Object lastReturn) throws KDException {
        CommonDtxResponse result = new CommonDtxResponse();
        if (!(param instanceof CommonParam)) {
            String errorMessage = ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38", (String)"PurReceiptBillService_0", (String)"scm-pur-mservice", (Object[])new Object[0]);
            log.warn("VerifyService#apVerify" + errorMessage + "\u53c2\u6570\u5fc5\u987b\u662f\u4e00\u4e2akd.bos.kdtx.common.CommonParam");
            throw new KDException(new ErrorCode("VERIFYSERVICE_CODE_002", errorMessage), new Object[0]);
        }
        Map mapAll = ((CommonParam)param).getAll();
        Object purReceiveRowDataListParam = mapAll.get("purReceiveRowDataListParam");
        this.updateReceiptBasicQty((List)purReceiveRowDataListParam);
        result.put((Object)"success", (Object)Boolean.TRUE);
        result.put((Object)"message", (Object)"ok");
        return result;
    }

    public void updateReceiptBasicQty(List<Map<String, String>> purReceiveRowDataListParam) {
        Object billPk;
        HashSet<String> srcBillPks = new HashSet<String>(56);
        HashMap<String, BigDecimal> entryPkMapBasicQty = new HashMap<String, BigDecimal>(56);
        HashMap<Long, BigDecimal> poEntryStockQtyMap = new HashMap<Long, BigDecimal>(56);
        for (Map<String, String> dataMap : purReceiveRowDataListParam) {
            billPk = dataMap.get("billpk");
            srcBillPks.add((String)billPk);
            String entryPk = dataMap.get("entrypk");
            String basicQtyString = dataMap.get("basicqty");
            BigDecimal basicQty = new BigDecimal(basicQtyString);
            String srcSysBillEntryIdString = dataMap.get("srcsysbillentryid");
            entryPkMapBasicQty.put(entryPk, basicQty);
            if (!this.checkValue(srcSysBillEntryIdString)) continue;
            Long srcSysBillEntryId = Long.parseLong(srcSysBillEntryIdString);
            BigDecimal stepBasicQty = (BigDecimal)poEntryStockQtyMap.get(srcSysBillEntryId);
            stepBasicQty = stepBasicQty == null ? basicQty : stepBasicQty.add(basicQty);
            poEntryStockQtyMap.put(srcSysBillEntryId, stepBasicQty);
        }
        HashSet<Long> billIds = new HashSet<Long>(56);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"pur_receipt", (String)"id", (QFilter[])new QFilter[]{new QFilter("materialentry.srcbillid", "in", srcBillPks)}, (String)"id");
        billPk = null;
        try {
            DataSet groupDataSet = dataSet.groupBy(new String[]{"id"}).finish();
            while (groupDataSet.hasNext()) {
                DynamicObject[] row = groupDataSet.next();
                billIds.add(row.getLong("id"));
            }
            groupDataSet.close();
        }
        catch (Throwable groupDataSet) {
            billPk = groupDataSet;
            throw groupDataSet;
        }
        finally {
            if (dataSet != null) {
                if (billPk != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable groupDataSet) {
                        ((Throwable)billPk).addSuppressed(groupDataSet);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (!billIds.isEmpty()) {
            DynamicProperty sumReceiptQtyProperty;
            DynamicObject[] dynamicObjectArray;
            DataSet dataSet2;
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])billIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pur_receipt"));
            HashSet<String> poEntryIdSet = new HashSet<String>(56);
            ICalDynamic calDynamic = new CalDynamicFactory().createCal();
            for (DynamicObject bill : dynamicObjects) {
                DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
                DynamicProperty qtyProperty = rows.getDynamicObjectType().getProperty("qty");
                DynamicProperty basicQtyProperty = rows.getDynamicObjectType().getProperty("basicqty");
                for (int i = 0; i < rows.size(); ++i) {
                    Object srcEntryId;
                    BigDecimal basicQty;
                    DynamicObject row = (DynamicObject)rows.get(i);
                    String poEntryId = row.getString("poentryid");
                    if (this.checkValue(poEntryId)) {
                        poEntryIdSet.add(poEntryId);
                    }
                    if ((basicQty = (BigDecimal)entryPkMapBasicQty.get(srcEntryId = row.getString("srcentryid"))) == null) continue;
                    DynamicObject material = row.getDynamicObject("material");
                    DynamicObject unit = row.getDynamicObject("unit");
                    DynamicObject basicUnit = row.getDynamicObject("basicunit");
                    BigDecimal qty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)basicUnit, (BigDecimal)basicQty, (DynamicObject)unit);
                    qtyProperty.setValue((Object)row, (Object)qty);
                    basicQtyProperty.setValue((Object)row, (Object)basicQty);
                    calDynamic.proChanged(bill, "materialentry", "qty", i);
                }
                calDynamic.calSum(bill, "materialentry");
            }
            SRMStoreDataTraceHelper.updateStoreData((DynamicObject[])dynamicObjects);
            HashMap<String, BigDecimal> poEntryOrderQtyMap = new HashMap<String, BigDecimal>(56);
            try (DataSet dataSet3 = QueryServiceHelper.queryDataSet((String)"", (String)"pur_receipt", (String)"materialentry.basicqty basicqty,materialentry.srcentryid srcentryid,materialentry.saloutentryid saloutentryid,materialentry.poentryid poentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", poEntryIdSet)}, (String)"id");){
                while (dataSet3.hasNext()) {
                    Row row = dataSet3.next();
                    String poEntryId = row.getString("poentryid");
                    if (!this.checkValue(poEntryId)) continue;
                    BigDecimal basicQty = (BigDecimal)poEntryOrderQtyMap.get(poEntryId);
                    basicQty = basicQty == null ? row.getBigDecimal("basicqty") : basicQty.add(row.getBigDecimal("basicqty"));
                    poEntryOrderQtyMap.put(poEntryId, basicQty);
                }
            }
            if (!poEntryOrderQtyMap.isEmpty()) {
                DynamicObject[] orders;
                HashSet<Long> orderBillPks = new HashSet<Long>(56);
                dataSet2 = QueryServiceHelper.queryDataSet((String)"", (String)"pur_order", (String)"id", (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", poEntryOrderQtyMap.keySet())}, (String)"id");
                dynamicObjectArray = null;
                try {
                    DataSet groupDataSet = dataSet2.groupBy(new String[]{"id"}).finish();
                    while (groupDataSet.hasNext()) {
                        orderBillPks.add(groupDataSet.next().getLong("id"));
                    }
                    groupDataSet.close();
                }
                catch (Throwable groupDataSet) {
                    dynamicObjectArray = groupDataSet;
                    throw groupDataSet;
                }
                finally {
                    if (dataSet2 != null) {
                        if (dynamicObjectArray != null) {
                            try {
                                dataSet2.close();
                            }
                            catch (Throwable groupDataSet) {
                                dynamicObjectArray.addSuppressed(groupDataSet);
                            }
                        } else {
                            dataSet2.close();
                        }
                    }
                }
                for (DynamicObject bill : orders = BusinessDataServiceHelper.load((Object[])orderBillPks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pur_order"))) {
                    DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
                    sumReceiptQtyProperty = rows.getDynamicObjectType().getProperty("sumreceiptqty");
                    DynamicProperty sumReceiptBaseQtyProperty = rows.getDynamicObjectType().getProperty("sumreceiptbaseqty");
                    for (DynamicObject row : rows) {
                        BigDecimal basicQty;
                        String poEntryId = row.getString("poentryid");
                        if (!this.checkValue(poEntryId) || (basicQty = (BigDecimal)poEntryOrderQtyMap.get(poEntryId)) == null) continue;
                        DynamicObject material = row.getDynamicObject("material");
                        DynamicObject unit = row.getDynamicObject("unit");
                        DynamicObject basicUnit = row.getDynamicObject("basicunit");
                        BigDecimal qty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)basicUnit, (BigDecimal)basicQty, (DynamicObject)unit);
                        sumReceiptQtyProperty.setValue((Object)row, (Object)qty);
                        sumReceiptBaseQtyProperty.setValue((Object)row, (Object)basicQty);
                    }
                }
                OrderUtil.updateOrderCfmStatus((DynamicObject[])orders, new ArrayList(poEntryOrderQtyMap.keySet()), (Boolean)true);
                SRMStoreDataTraceHelper.updateStoreData((DynamicObject[])orders);
            }
            if (!poEntryStockQtyMap.isEmpty()) {
                DynamicObject[] saloutstocks;
                HashSet<Long> billPks = new HashSet<Long>(56);
                dataSet2 = QueryServiceHelper.queryDataSet((String)"", (String)"pur_saloutstock", (String)"id", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", poEntryStockQtyMap.keySet())}, (String)"id");
                dynamicObjectArray = null;
                try {
                    DataSet groupDataSet = dataSet2.groupBy(new String[]{"id"}).finish();
                    while (groupDataSet.hasNext()) {
                        billPks.add(groupDataSet.next().getLong("id"));
                    }
                    groupDataSet.close();
                }
                catch (Throwable throwable) {
                    dynamicObjectArray = throwable;
                    throw throwable;
                }
                finally {
                    if (dataSet2 != null) {
                        if (dynamicObjectArray != null) {
                            try {
                                dataSet2.close();
                            }
                            catch (Throwable throwable) {
                                dynamicObjectArray.addSuppressed(throwable);
                            }
                        } else {
                            dataSet2.close();
                        }
                    }
                }
                for (DynamicObject bill : saloutstocks = BusinessDataServiceHelper.load((Object[])billPks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pur_saloutstock"))) {
                    DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
                    sumReceiptQtyProperty = rows.getDynamicObjectType().getProperty("sumreceiptqty");
                    for (DynamicObject row : rows) {
                        Long entryId = row.getLong("id");
                        BigDecimal basicQty = (BigDecimal)poEntryStockQtyMap.get(entryId);
                        if (basicQty == null) continue;
                        DynamicObject material = row.getDynamicObject("material");
                        DynamicObject unit = row.getDynamicObject("unit");
                        DynamicObject basicUnit = row.getDynamicObject("basicunit");
                        BigDecimal qty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)basicUnit, (BigDecimal)basicQty, (DynamicObject)unit);
                        sumReceiptQtyProperty.setValue((Object)row, (Object)qty);
                    }
                }
                SaloutUtil.updateCfmStatus((DynamicObject[])saloutstocks);
                SRMStoreDataTraceHelper.updateStoreData((DynamicObject[])saloutstocks);
            }
        }
    }

    private boolean checkValue(String value) {
        return value != null && !value.isEmpty() && !"0".equals(value);
    }
}

