/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.scm.pur.business.changemodel.helper.ChangeMicroservicesHelp;
import kd.scm.pur.service.entity.QueryPropertiesDTO;

public class AuditPmOmWXPurOrderEventService
implements IEventServicePlugin {
    public Object handleEvent(KDBizEvent e) {
        EntityEvent entityEvent = null;
        if (e instanceof EntityEvent) {
            entityEvent = (EntityEvent)e;
        }
        if (entityEvent == null) {
            return e.getEventId();
        }
        String omXEntityNumber = entityEvent.getEntityNumber();
        List ids = entityEvent.getBusinesskeys();
        if (ids == null || ids.isEmpty()) {
            return e.getEventId();
        }
        Map<Long, List<Map<String, Object>>> omXOrder = this.processOrders(omXEntityNumber, ids);
        if (omXOrder.isEmpty()) {
            throw new KDBizException("The selected process outsourcing change order is empty.");
        }
        Map res = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"PurXOrderOmService", (String)"createPurXOrder", (Object[])new Object[]{omXOrder});
        if (res.get("fail") != null) {
            throw new KDBizException((String)res.get("fail"));
        }
        return e.getEventId();
    }

    public Map<Long, List<Map<String, Object>>> processOrders(String omXEntityNumber, List<String> ids) {
        QueryPropertiesDTO queryProperties = this.buildQueryProperties();
        String selectProperties = queryProperties.getSelectProperties();
        Object[] longIds = ids.stream().map(Long::parseLong).toArray();
        DynamicObjectCollection omXOrderEntryLines = QueryServiceHelper.query((String)omXEntityNumber, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)longIds)});
        HashMap<Long, List<Map<String, Object>>> omOrders = new HashMap<Long, List<Map<String, Object>>>(16);
        if (omXOrderEntryLines == null || omXOrderEntryLines.isEmpty()) {
            return omOrders;
        }
        for (DynamicObject entryLine : omXOrderEntryLines) {
            Long srcBillId = entryLine.getLong("sourceid");
            List orderDetails = omOrders.computeIfAbsent(srcBillId, k -> new ArrayList());
            List<String> fields = queryProperties.getFields();
            HashMap<String, Object> line = new HashMap<String, Object>(fields.size());
            for (String field : fields) {
                line.put(field, entryLine.get(field));
            }
            orderDetails.add(line);
        }
        return omOrders;
    }

    private QueryPropertiesDTO buildQueryProperties() {
        String[] changeEntryProperties;
        String[] changeProperties;
        QueryPropertiesDTO queryPropertiesDTO = new QueryPropertiesDTO();
        StringBuilder selectProperties = new StringBuilder();
        ArrayList<String> fields = new ArrayList<String>();
        Map botpMap = ChangeMicroservicesHelp.buildOmToPurFiledMap();
        DynamicObjectType purXOrderType = BusinessDataServiceHelper.newDynamicObject((String)"pur_xorder").getDynamicObjectType();
        for (String field : changeProperties = ChangeModelHelper.getEnableProperty((IDataEntityType)purXOrderType)) {
            String omXField = (String)botpMap.get(field);
            if (StringUtils.isBlank((CharSequence)omXField)) continue;
            this.appendFieldAndAddToList(selectProperties, fields, omXField);
        }
        String entryName = "billentry";
        for (String entryField : changeEntryProperties = ChangeModelHelper.getEnableProperty((IDataEntityType)purXOrderType, (String)"materialentry")) {
            String omXField = (String)botpMap.get(entryField);
            if (StringUtils.isBlank((CharSequence)omXField)) continue;
            this.appendFieldAndAddToList(selectProperties, fields, entryName + "." + omXField);
        }
        this.appendFieldAndAddToList(selectProperties, fields, "id");
        this.appendFieldAndAddToList(selectProperties, fields, "reason");
        this.appendFieldAndAddToList(selectProperties, fields, "confirmstatus");
        this.appendFieldAndAddToList(selectProperties, fields, "sourceid");
        this.appendFieldAndAddToList(selectProperties, fields, "operator");
        this.appendFieldAndAddToList(selectProperties, fields, entryName + ".id");
        this.appendFieldAndAddToListEnd(selectProperties, fields, entryName + ".sourceentryid");
        queryPropertiesDTO.setSelectProperties(selectProperties.toString());
        queryPropertiesDTO.setFields(fields);
        return queryPropertiesDTO;
    }

    private void appendFieldAndAddToList(StringBuilder selectProperties, List<String> fields, String field) {
        selectProperties.append(field).append(",");
        fields.add(field);
    }

    private void appendFieldAndAddToListEnd(StringBuilder selectProperties, List<String> fields, String field) {
        selectProperties.append(field);
        fields.add(field);
    }
}

