/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.jointplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.common.helper.multisystemjoint.param.MultiCustomParam;
import kd.scm.common.helper.transfer.SDKTransferHelper;
import kd.scm.pur.business.PurBatchStockHelper;

public class PurBatchStockPushParamAssmbleUtil {
    public static Map<String, Object> buildPushParam(MultiCustomParam multiCustomParam, List<DynamicObject> dynamicObjects, String sourceEntity, String targetEntity) {
        Map transferPropertyMap = null;
        String botpNumber = "";
        if (multiCustomParam != null) {
            String transferPropertyMapStr = (String)multiCustomParam.get((Object)"transferPropertyMap");
            if (StringUtils.isNotBlank((CharSequence)transferPropertyMapStr)) {
                transferPropertyMap = (Map)JSON.parseObject((String)transferPropertyMapStr, Map.class);
            }
            botpNumber = (String)multiCustomParam.get((Object)"botpNumber");
        }
        Map batchExtEntryPro = PurBatchStockHelper.assembleBatchExtEntryPro();
        LinkedHashMap receipt = new LinkedHashMap(1024);
        LinkedHashMap<Long, HashSet<Long>> pushOrderData = new LinkedHashMap<Long, HashSet<Long>>(1024);
        HashSet<String> salOutEntryIds = new HashSet<String>(1024);
        for (DynamicObject bill : dynamicObjects) {
            Map transferPropertyBill;
            String poEntryId = bill.getString("poentryid1");
            String poBillId = bill.getString("pobillid1");
            if (poEntryId.isEmpty() || poBillId.isEmpty()) continue;
            HashSet<Long> poEntryIdSet = null;
            poEntryIdSet = (HashSet<Long>)pushOrderData.get(Long.parseLong(poBillId));
            if (poEntryIdSet == null) {
                poEntryIdSet = new HashSet<Long>(1024);
                poEntryIdSet.add(Long.parseLong(poEntryId));
                pushOrderData.put(Long.parseLong(poBillId), poEntryIdSet);
            } else {
                poEntryIdSet.add(Long.parseLong(poEntryId));
                pushOrderData.put(Long.parseLong(poBillId), poEntryIdSet);
            }
            ArrayList salOutInfoS = (ArrayList)receipt.get(poEntryId);
            LinkedHashMap<String, String> salOutInfoMap = new LinkedHashMap<String, String>(1024);
            BigDecimal receiveqty = bill.getBigDecimal("receiveqty1");
            if (receiveqty.compareTo(BigDecimal.ZERO) > 0) {
                salOutInfoMap.put("qty_" + poEntryId, receiveqty.toPlainString());
            }
            String saloutNo = bill.getString("billno1");
            String saloutId = bill.getString("billid1");
            String saloutEntryId = bill.getString("entryid1");
            salOutEntryIds.add(saloutEntryId);
            String suplot1 = bill.getString("suplot1");
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:MM:ss");
            Date proddate1 = bill.getDate("proddate1");
            Date duedate1 = bill.getDate("duedate1");
            if (StringUtils.isNotEmpty((CharSequence)saloutNo)) {
                salOutInfoMap.put("saloutNo_" + poEntryId, saloutNo);
            }
            if (StringUtils.isNotEmpty((CharSequence)saloutId)) {
                salOutInfoMap.put("saloutId_" + poEntryId, saloutId);
            }
            if (StringUtils.isNotEmpty((CharSequence)saloutEntryId)) {
                salOutInfoMap.put("saloutEntryId_" + poEntryId, saloutEntryId);
            }
            if (StringUtils.isNotEmpty((CharSequence)suplot1)) {
                salOutInfoMap.put("suplot_" + poEntryId, suplot1);
            }
            if (null != proddate1 && StringUtils.isNotEmpty((CharSequence)sf.format(proddate1))) {
                salOutInfoMap.put("proddate_" + poEntryId, sf.format(proddate1));
            }
            if (null != duedate1 && StringUtils.isNotEmpty((CharSequence)sf.format(duedate1))) {
                salOutInfoMap.put("duedate_" + poEntryId, sf.format(duedate1));
            }
            Map autoExtStockBill = SDKTransferHelper.executeTransfer((DynamicObject)bill, (Map)batchExtEntryPro);
            for (Map.Entry entry : autoExtStockBill.entrySet()) {
                salOutInfoMap.put((String)entry.getKey() + "_" + poEntryId, (String)entry.getValue());
            }
            if (transferPropertyMap != null && !(transferPropertyBill = SDKTransferHelper.executeTransfer((DynamicObject)bill, (Map)transferPropertyMap, (boolean)false)).isEmpty()) {
                for (Map.Entry proDataEntry : transferPropertyBill.entrySet()) {
                    salOutInfoMap.put((String)proDataEntry.getKey() + "_" + poEntryId, (String)proDataEntry.getValue());
                }
            }
            if (salOutInfoS == null) {
                salOutInfoS = new ArrayList(64);
            }
            salOutInfoS.add(salOutInfoMap);
            receipt.put(poEntryId, salOutInfoS);
        }
        HashMap<String, Object> toStockParamMap = new HashMap<String, Object>(16);
        toStockParamMap.put("sourceEntity", sourceEntity);
        toStockParamMap.put("targetEntity", targetEntity);
        toStockParamMap.put("pushOrderData", pushOrderData);
        toStockParamMap.put("rowSalOutInfoMap", receipt);
        toStockParamMap.put("salOutEntryIds", salOutEntryIds);
        toStockParamMap.put("needWriteBillNo", Boolean.FALSE);
        toStockParamMap.put("botpNumber", botpNumber);
        return toStockParamMap;
    }
}

