/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.jointplugin;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.enums.QualityRectificEnum;
import kd.scm.common.helper.multisystemjoint.constant.MServiceParamType;
import kd.scm.common.helper.multisystemjoint.param.ScMultiCosmicStdParamArgs;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.helper.multisystemjoint.param.plugin.AbstractCustomParamPlugin;
import kd.scm.pur.business.PurQualityrectificConfirmHelper;

public final class PurQualityRectificConfirmForCosmicStdPlugin
extends AbstractCustomParamPlugin {
    private static final Log log = LogFactory.getLog(PurQualityrectificConfirmHelper.class);

    protected Boolean verifyEnable(List<DynamicObject> dynamicObjects) {
        for (DynamicObject dataEntity : dynamicObjects) {
            String srctype = dataEntity.getString("srctype");
            if (!"2".equals(srctype)) {
                return false;
            }
            String icastatus = dataEntity.getString("icastatus");
            String pcastatus = dataEntity.getString("pcastatus");
            String verifystatus = dataEntity.getString("verifystatus");
            if (!QualityRectificEnum.PENDINGREFEEDBACK.getValue().equals(icastatus) && !QualityRectificEnum.PENDINGREFEEDBACK.getValue().equals(pcastatus) && !QualityRectificEnum.PENDINGREFEEDBACK.getValue().equals(verifystatus)) continue;
            return false;
        }
        return true;
    }

    public List<DynamicObject> getDynamicObjects(Long[] pkIds) {
        return super.loadDynamicObjects(pkIds);
    }

    protected ScMultiParamArgs assembleJointParam(List<DynamicObject> list) {
        ScMultiCosmicStdParamArgs cosmicStdParamArgs = new ScMultiCosmicStdParamArgs();
        LinkedHashMap toStockParamMap = new LinkedHashMap(16);
        cosmicStdParamArgs.setCloudId("qmc");
        cosmicStdParamArgs.setAppId("qcqi");
        cosmicStdParamArgs.setServiceName("CorrectPreventService");
        cosmicStdParamArgs.setMethodName("batchAddNewEntry");
        cosmicStdParamArgs.setParamType(MServiceParamType.PARAMLIST);
        LinkedList reqParamList = new LinkedList();
        log.info("\u8c03\u7528\u8d28\u91cf\u4e91\u5fae\u670d\u52a1\u5f00\u59cb\u3002");
        for (DynamicObject dataEntity : list) {
            String icastatus = dataEntity.getString("icastatus");
            String pcastatus = dataEntity.getString("pcastatus");
            String verifystatus = dataEntity.getString("verifystatus");
            String status = "";
            Boolean isICAPCA = false;
            if (QualityRectificEnum.CONFIRMED.getValue().equals(icastatus) && !QualityRectificEnum.CONFIRMED.getValue().equals(pcastatus) && !QualityRectificEnum.CONFIRMED.getValue().equals(verifystatus)) {
                status = "ica";
            } else if (QualityRectificEnum.CONFIRMED.getValue().equals(icastatus) && QualityRectificEnum.CONFIRMED.getValue().equals(pcastatus) && !QualityRectificEnum.CONFIRMED.getValue().equals(verifystatus)) {
                Date pcaconfirmtime;
                status = "pca";
                Date icaconfirmtime = dataEntity.getDate("icaconfirmtime");
                if (icaconfirmtime.compareTo(pcaconfirmtime = dataEntity.getDate("pcaconfirmtime")) == 0) {
                    isICAPCA = true;
                }
            } else if (QualityRectificEnum.CONFIRMED.getValue().equals(verifystatus)) {
                status = "verify";
            }
            PurQualityrectificConfirmHelper.buildReqParamList((DynamicObject)dataEntity, reqParamList, (String)status, (Boolean)isICAPCA);
        }
        log.info("\u8c03\u7528\u8d28\u91cf\u4e91\u5fae\u670d\u52a1\u53c2\u6570 reqParamList={}", reqParamList);
        toStockParamMap.put("reqParamList", reqParamList);
        cosmicStdParamArgs.setParamMap(toStockParamMap);
        return cosmicStdParamArgs;
    }
}

