/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.DiscountTypeEnum;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.calmodel.CalModelFactory;
import kd.scm.common.util.calmodel.ICalModel;
import kd.scm.pur.formplugin.PurCoreBillEditPlugin;

public class PurCheckEditPlugin
extends PurCoreBillEditPlugin
implements HyperLinkClickListener {
    private ICalModel iCalDynamic = new CalModelFactory().createCal();

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBarStatus();
        this.setIsPersentUnable("materialentry", "ispresent", "actcheckprice", "actchecktaxprice", "actcheckamount", "actchecktaxamount");
    }

    public void setIsPersentUnable(String entry, String ispresentProp, String ... entryprop) {
        DynamicObjectCollection cols = this.getModel().getEntryEntity(entry);
        for (int i = 0; i < cols.size(); ++i) {
            DynamicObject dy = (DynamicObject)cols.get(i);
            boolean ispresent = dy.getBoolean(ispresentProp);
            if (!ispresent) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, entryprop);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData[] changeSets = e.getChangeSet();
        model.beginInit();
        block12: for (ChangeData changeSet : changeSets) {
            int rowIndex = changeSet.getRowIndex();
            Object newValue = changeSet.getNewValue();
            Object oldValue = changeSet.getOldValue();
            switch (propertyName) {
                case "qty": {
                    this.iCalDynamic.proChanged(model, "materialentry", propertyName, "", rowIndex);
                    continue block12;
                }
                case "actchecktaxprice": 
                case "actcheckprice": {
                    boolean isCompliance = this.checkIsCompliance(propertyName, newValue, oldValue, "", rowIndex);
                    if (!isCompliance) continue block12;
                    this.iCalDynamic.proChanged(model, "materialentry", propertyName, "", rowIndex);
                    continue block12;
                }
                case "actchecktaxamount": 
                case "actcheckamount": {
                    this.iCalDynamic.proChanged(model, "materialentry", propertyName, "", rowIndex);
                    continue block12;
                }
            }
        }
        model.endInit();
        this.getView().updateView("materialentry");
        DynamicObjectCollection entryCol = model.getDataEntity().getDynamicObjectCollection("materialentry");
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (DynamicObject obj : entryCol) {
            sumAmount = sumAmount.add(obj.getBigDecimal("actchecktaxamount"));
        }
        model.setValue("sumtaxamount", (Object)sumAmount);
    }

    private boolean checkIsCompliance(String fielKey, Object newValue, Object oldValue, String suffix, int rowIndex) {
        IDataModel model = this.getModel();
        String discountType = (String)model.getValue("discounttype" + suffix, rowIndex);
        String taxtype = (String)model.getValue("taxtype");
        BigDecimal discountRate = (BigDecimal)model.getValue("dctrate" + suffix, rowIndex);
        BigDecimal actchecktaxprice = (BigDecimal)model.getValue("actchecktaxprice", rowIndex);
        BigDecimal actcheckprice = (BigDecimal)model.getValue("actcheckprice", rowIndex);
        boolean isPresent = (Boolean)model.getValue("ispresent", rowIndex);
        boolean isCompliance = true;
        boolean isTax = this.isContainTax(taxtype);
        if (!isPresent && DiscountTypeEnum.UNITDIS.getVal().equals(discountType)) {
            if (isTax && discountRate.compareTo(actchecktaxprice) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PurCheckEditPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                isCompliance = false;
            } else if (!isTax && discountRate.compareTo(actcheckprice) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"PurCheckEditPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                isCompliance = false;
            }
        }
        if (!isCompliance) {
            model.setValue(fielKey, oldValue, rowIndex);
        }
        return isCompliance;
    }

    protected boolean isContainTax(String taxType) {
        return TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid headGrid = (EntryGrid)this.getView().getControl("materialentry");
        headGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent heperLinkEvent) {
        EntryGrid grid = (EntryGrid)heperLinkEvent.getSource();
        String gridKey = grid.getKey();
        String val = null;
        String entityKey = null;
        String property = heperLinkEvent.getFieldName();
        if (gridKey.equals("materialentry")) {
            boolean isFindBill;
            val = (String)grid.getModel().getValue(property);
            if ("inbillno".equals(property)) {
                Object srcBillTypeObj = grid.getModel().getValue("srcbilltype");
                if (null != srcBillTypeObj && !"pur_receipt".equals(srcBillTypeObj.toString().replace("scp", "pur"))) {
                    entityKey = srcBillTypeObj.toString().replace("scp", "pur");
                } else if (QueryServiceHelper.exists((String)"pur_receipt", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)val).and(new QFilter("isreturn", "=", (Object)"0"))})) {
                    entityKey = "pur_receipt";
                } else if (QueryServiceHelper.exists((String)"pur_receipt_return", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)val).and(new QFilter("isreturn", "=", (Object)"1"))})) {
                    entityKey = "pur_receipt_return";
                } else if (QueryServiceHelper.exists((String)"pur_instock", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)val)})) {
                    entityKey = "pur_instock";
                } else if (QueryServiceHelper.exists((String)"pur_return", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)val)})) {
                    entityKey = "pur_return";
                }
            } else if ("pobillno".equals(property)) {
                entityKey = "pur_order";
            }
            if ("outbillno".equals(property) && !(isFindBill = this.assembleBill("pur_saloutstock", val, false))) {
                this.assembleBill("pur_salreturn", val, true);
            }
            this.showBillForm(val, entityKey);
        }
    }

    private boolean assembleBill(String billKey, Object billNo, boolean isShowMsg) {
        DynamicObjectCollection cols;
        boolean isFindBill = true;
        HashMap params = new HashMap(1);
        HashMap<String, Object[]> billNoMap = new HashMap<String, Object[]>(1);
        Object[] billNoObjs = null;
        if (null != billNo) {
            billNoObjs = CommonUtil.str2objs((String)billNo.toString(), (String)",");
            billNoMap.put("in", billNoObjs);
            params.put("billno", billNoMap);
        }
        if ((cols = ORMUtil.queryDynamicObjectCollection((String)billKey, (String)"id,billno", params)) == null || cols.size() == 0) {
            if (isShowMsg) {
                this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\u4e0d\u5b58\u5728\u3002", (String)"PurCheckEditPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]), billNo));
            }
            isFindBill = false;
        } else {
            List idList = DynamicObjectUtil.col2ListId((DynamicObjectCollection)cols, (String)"id");
            if (idList.size() == 1) {
                BillShowParameter showParam = BillFormUtil.assembleShowBillFormParam((String)billKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)((Long)idList.get(0)), null, null);
                this.getView().showForm((FormShowParameter)showParam);
            } else {
                HashMap<String, Object> customeParam = new HashMap<String, Object>(1);
                customeParam.put("billno", billNo);
                ListShowParameter listParam = BillFormUtil.assembleShowListFormParam((String)billKey, customeParam, null);
                this.getView().showForm((FormShowParameter)listParam);
            }
        }
        return isFindBill;
    }

    public void showBillForm(Object val, String entityKey) {
        if (val == null || entityKey == null || entityKey.isEmpty()) {
            return;
        }
        ArrayList<Long> billPks = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)entityKey, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", val)}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long pk = row.getLong("id");
                if (pk == null || billPks.contains(pk)) continue;
                billPks.add(pk);
            }
        }
        if (!billPks.isEmpty()) {
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)entityKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)((Long)billPks.get(0)), null, null));
        } else {
            this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e{0}\u4e0d\u5b58\u5728\u3002", (String)"PurCheckEditPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]), val));
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "confirm": 
            case "agreecheck": {
                this.setBarStatus();
                break;
            }
            case "submit": {
                BillModel billModel = (BillModel)this.getModel();
                billModel.load(billModel.getPKValue());
                this.getView().updateView("materialentry");
                break;
            }
        }
    }

    private void setBarStatus() {
        IDataModel datamodel = this.getModel();
        if (datamodel.getValue("cfmstatus").equals("B")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_confirm"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit"});
        }
    }
}

