/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.pur.common.blueprintshare.po.BluePrintDTO;
import kd.scm.pur.common.blueprintshare.po.BluePrintMateriel;
import kd.scm.pur.common.blueprintshare.po.DocumentSaveMessage;
import kd.scm.pur.common.blueprintshare.support.PurGetBlueprintSupport;
import kd.scm.pur.common.blueprintshare.task.SaveBluePrintTask;
import kd.scm.pur.common.blueprintshare.task.SaveBluePrintTaskClick;
import kd.scm.pur.common.constant.PurBlueprintShareConstant;
import org.apache.commons.lang.StringUtils;

public class PurGetBluePrint
extends AbstractFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(PurGetBluePrint.class);
    private static final IAppCache cache = AppCache.get((String)"scm");
    private final PurGetBlueprintSupport purGetBlueprintSupport = new PurGetBlueprintSupport();

    public void afterCreateNewData(EventObject e) {
        try {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            String type = (String)customParams.get("getType");
            if ("get".equals(type)) {
                this.getModel().batchCreateNewEntryRow("getblueprintentry", 10);
            } else if ("update".equals(type)) {
                this.openUpdateView(customParams);
            }
        }
        catch (Exception exception) {
            log.error("kd.scm.pur.formplugin.PurGetBluePrint.afterCreateNewData \u51fa\u9519\uff1a" + exception.getMessage());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{0}", (String)"PurBluePrintPlugin_4", (String)"scm-pur-formplugin", (Object[])new Object[]{exception.getMessage()}));
        }
    }

    public void afterBindData(EventObject e) {
        try {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            String type = (String)customParams.get("getType");
            if ("update".equals(type)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"newentry"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"deleteentry"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap"});
                int rowCount = this.getModel().getEntryRowCount("getblueprintentry");
                for (int i = 0; i < rowCount; ++i) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"materiel"});
                }
            }
        }
        catch (Exception exception) {
            log.error("afterBindData\uff1a" + exception);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurBluePrintPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    private void openUpdateView(Map<String, Object> customParams) throws Exception {
        JSONArray param = (JSONArray)customParams.get("blueprintmateriel");
        List bluePrintMateriels = param.toJavaList(BluePrintMateriel.class);
        if (bluePrintMateriels == null || bluePrintMateriels.isEmpty()) {
            return;
        }
        for (int i = 0; i < bluePrintMateriels.size(); ++i) {
            BluePrintMateriel bluePrintMateriel = (BluePrintMateriel)bluePrintMateriels.get(i);
            Long materielId = bluePrintMateriel.getMaterielId();
            String materielNumber = bluePrintMateriel.getMaterielNumber();
            Long id = bluePrintMateriel.getId();
            this.getModel().createNewEntryRow("getblueprintentry");
            this.getModel().setValue("materiel", (Object)materielId, i);
            HashSet<String> materielNumberSet = new HashSet<String>(0);
            materielNumberSet.add(materielNumber);
            Map bluePrintMap = this.purGetBlueprintSupport.getBluePrintDTOS(materielNumberSet);
            List bluePrintDTOS = (List)bluePrintMap.get(materielNumber);
            if (bluePrintDTOS == null || bluePrintDTOS.isEmpty()) continue;
            BluePrintDTO bluePrintDTO = (BluePrintDTO)bluePrintDTOS.get(0);
            this.getModel().setValue("version", (Object)bluePrintDTO.getVersion(), i);
            this.getModel().setValue("documentname", (Object)bluePrintDTO.getDocumentName(), i);
            this.getModel().setValue("documentids", (Object)bluePrintDTO.getFileId(), i);
            this.getModel().setValue("sourceid", (Object)id, i);
        }
    }

    private List<DynamicObject> getSelectBluePrint() {
        ArrayList<DynamicObject> getBluePrints = new ArrayList<DynamicObject>(16);
        EntryGrid entryGrid = (EntryGrid)this.getControl("getblueprintentry");
        int[] selectRowsIndex = entryGrid.getSelectRows();
        if (selectRowsIndex.length == 0) {
            return getBluePrints;
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity("getblueprintentry");
        for (int rowsIndex : selectRowsIndex) {
            DynamicObject getBluePrint = (DynamicObject)entry.get(rowsIndex);
            getBluePrints.add(getBluePrint);
        }
        return getBluePrints;
    }

    public void registerListener(EventObject e) {
        try {
            super.registerListener(e);
            BasedataEdit materiel = (BasedataEdit)this.getControl("materiel");
            EntryGrid entryGrid = (EntryGrid)this.getControl("getblueprintentry");
            materiel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
            this.addClickListeners(new String[]{"btnok"});
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurBluePrintPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        try {
            int rowIndex = event.getRowIndex();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("getblueprintentry");
            DynamicObject row = (DynamicObject)entryEntity.get(rowIndex);
            String materielNumber = row.getString("materiel.number");
            Long materielId = row.getLong("materiel.id");
            if (StringUtils.isEmpty((String)materielNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"PurGetBluePrint_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("pur_get_document");
            formShowParameter.setCustomParam("materiel.number", (Object)materielNumber);
            formShowParameter.setCustomParam("materiel.id", (Object)materielId);
            formShowParameter.setCustomParam("rowIndex", (Object)rowIndex);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btnok"));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
        catch (Exception e) {
            log.error("hyperLinkClick\uff1a" + e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurBluePrintPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        try {
            String actionId = event.getActionId();
            if (StringUtils.equals((String)actionId, (String)"btnok")) {
                List documentSaveMessages = (List)event.getReturnData();
                if (documentSaveMessages == null || documentSaveMessages.isEmpty()) {
                    return;
                }
                int index = ((DocumentSaveMessage)documentSaveMessages.get(0)).getIndex();
                StringBuilder documentNames = new StringBuilder();
                StringBuilder ids = new StringBuilder();
                for (DocumentSaveMessage documentSaveMessage : documentSaveMessages) {
                    String documentName = documentSaveMessage.getDocumentName();
                    String id = documentSaveMessage.getId();
                    if (documentNames.length() > 0) {
                        documentNames.append(" , ").append(documentName);
                    } else {
                        documentNames.append(documentName);
                    }
                    if (ids.length() > 0) {
                        ids.append(" , ").append(id);
                        continue;
                    }
                    ids.append(id);
                }
                this.getModel().setValue("documentname", (Object)documentNames.toString(), index);
                this.getModel().setValue("documentids", (Object)ids.toString(), index);
            } else if (StringUtils.equals((String)actionId, (String)"ACTION_ID_SAVE_OR_UPDATE")) {
                this.taskCallBack(event.getReturnData());
                this.getView().close();
            }
        }
        catch (Exception e) {
            log.error("\u56de\u8c03\u65b9\u6cd5\u51fa\u9519\uff1a" + e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurBluePrintPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        cache.remove("BLUEPRINT_MAP_CACHE_KEY_" + currentUserId);
    }

    public boolean isSupportBatchPropChanged() {
        return true;
    }

    public void initialize() {
        try {
            BasedataEdit edit = (BasedataEdit)this.getView().getControl("materiel");
            edit.setBatchFirePropChanged(true);
        }
        catch (Exception e) {
            log.error("initialize\uff1a" + e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurBluePrintPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String filedName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("materiel".equals(filedName)) {
            try {
                HashSet<String> materielNumbers = new HashSet<String>(changeSet.length);
                HashMap<String, Integer> materielNumberToIndex = new HashMap<String, Integer>(changeSet.length);
                for (ChangeData changeData : changeSet) {
                    int rowIndex = changeData.getRowIndex();
                    if (rowIndex + 1 > 1000) continue;
                    Object newValue = changeData.getNewValue();
                    DynamicObject materiel = (DynamicObject)newValue;
                    String materielNumber = materiel.getString("number");
                    materielNumbers.add(materielNumber);
                    materielNumberToIndex.put(materielNumber, rowIndex);
                }
                Map bluePrintMap = this.purGetBlueprintSupport.getBluePrintDTOS(materielNumbers);
                if (bluePrintMap == null || bluePrintMap.isEmpty()) {
                    return;
                }
                for (Map.Entry entry : materielNumberToIndex.entrySet()) {
                    String materielNumber = (String)entry.getKey();
                    Integer rowIndex = (Integer)entry.getValue();
                    List bluePrintDTOS = (List)bluePrintMap.get(materielNumber);
                    if (bluePrintDTOS == null || bluePrintDTOS.isEmpty()) continue;
                    BluePrintDTO bluePrintDTO = (BluePrintDTO)bluePrintDTOS.get(0);
                    String documentName = bluePrintDTO.getDocumentName();
                    String version = bluePrintDTO.getVersion();
                    String id = bluePrintDTO.getFileId();
                    this.getModel().setValue("version", (Object)version, rowIndex.intValue());
                    this.getModel().setValue("documentname", (Object)documentName, rowIndex.intValue());
                    this.getModel().setValue("documentids", (Object)id, rowIndex.intValue());
                }
            }
            catch (Exception exception) {
                log.error("\u70b9\u51fb\u7269\u6599\u7f16\u7801\u83b7\u53d6\u661f\u7a7aplm\u56fe\u7eb8\u4fe1\u606f\u5931\u8d25\uff01");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{0}", (String)"PurBluePrintPlugin_4", (String)"scm-pur-formplugin", (Object[])new Object[]{exception.getMessage()}));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        try {
            String fieldName = event.getProperty().getName();
            if (fieldName.equals("materiel")) {
                String param = PurBlueprintShareConstant.buildQueryParma((String[])new String[]{"materiel"});
                long orgId = RequestContext.get().getOrgId();
                DynamicObjectCollection materiels = QueryServiceHelper.query((String)"pur_blueprint_share", (String)param, (QFilter[])new QFilter[]{new QFilter("createorg.id", "=", (Object)orgId)});
                Set materielIds = materiels.stream().map(m -> m.getLong("materiel")).collect(Collectors.toSet());
                event.getCustomQFilters().add(new QFilter("id", "not in", materielIds));
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurBluePrintPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        try {
            Control source = (Control)evt.getSource();
            if (StringUtils.equalsIgnoreCase((String)"btnok", (String)source.getKey())) {
                EntryGrid entryGrid = (EntryGrid)this.getControl("getblueprintentry");
                int[] selectRowsIndex = entryGrid.getSelectRows();
                if (selectRowsIndex.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PurGetBluePrint_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection entry = this.getModel().getEntryEntity("getblueprintentry");
                HashSet<Long> idSet = new HashSet<Long>();
                StringBuilder duplicateMateriel = new StringBuilder();
                StringBuilder emptyIdsMaterielNames = new StringBuilder();
                HashSet<String> duplicateMaterielSet = new HashSet<String>(0);
                boolean isMax = false;
                for (int index : selectRowsIndex) {
                    DynamicObject getBluePrint = (DynamicObject)entry.get(index);
                    long materielId = getBluePrint.getLong("materiel.id");
                    if (materielId == 0L) continue;
                    String materielName = getBluePrint.getString("materiel.name");
                    String documentIds = getBluePrint.getString("documentids");
                    if (StringUtils.isBlank((String)documentIds)) {
                        if (emptyIdsMaterielNames.length() == 0) {
                            emptyIdsMaterielNames.append(materielName);
                        } else if (emptyIdsMaterielNames.length() >= 1000) {
                            if (isMax) continue;
                            emptyIdsMaterielNames.append("......");
                            isMax = true;
                        } else {
                            emptyIdsMaterielNames.append(" , ").append(materielName);
                        }
                    }
                    if (idSet.add(materielId) || !duplicateMaterielSet.add(materielName)) continue;
                    if (duplicateMateriel.length() == 0) {
                        duplicateMateriel.append(materielName);
                        continue;
                    }
                    duplicateMateriel.append(" , ").append(materielName);
                }
                if (duplicateMateriel.length() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\uff1a \u201c{0}\u201d \u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PurGetBluePrint_2", (String)"scm-pur-formplugin", (Object[])new Object[]{duplicateMateriel.toString()}));
                    return;
                }
                if (emptyIdsMaterielNames.length() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\uff1a \u201d{0}\u201c \u5728\u661f\u7a7aplm\u7cfb\u7edf\u4e2d\u672a\u67e5\u8be2\u5230\u6709\u6548\u6570\u636e\u3002", (String)"PurGetBluePrint_3", (String)"scm-pur-formplugin", (Object[])new Object[]{emptyIdsMaterielNames.toString()}));
                    return;
                }
                this.publishSaveOrUpdateTask();
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u670d\u52a1\u51fa\u9519\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PurBluePrintPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    private void publishSaveOrUpdateTask() {
        List<DynamicObject> selectBluePrint = this.getSelectBluePrint();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String type = (String)customParams.get("getType");
        String groupId = (String)customParams.get("group");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pur_get_blueprint", selectBluePrint);
        params.put("getType", type);
        params.put("sender", "sender_view");
        params.put("group", groupId);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("pur");
        jobInfo.setJobType(JobType.REALTIME);
        String taskId = UUID.randomUUID().toString();
        jobInfo.setId(taskId);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setTaskClassname(SaveBluePrintTask.class.getName());
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ACTION_ID_SAVE_OR_UPDATE");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        String caption = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"PurGetBluePrint_6", (String)"scm-pur-formplugin", (Object[])new Object[0]);
        jobFormInfo.setCaption(caption);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName(SaveBluePrintTaskClick.class.getName());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private void taskCallBack(Object returnData) {
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((String)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            Map map = (Map)JSON.parseObject((String)data, Map.class);
            StringBuilder message = new StringBuilder();
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (StringUtils.isBlank((String)value)) {
                    message.append(key).append("\n");
                    continue;
                }
                message.append(key).append("\uff0c").append(value).append("\u3002").append("\n");
            }
            this.getView().showMessage(message.toString());
        }
    }
}

