/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.check.HandCheckUtil;

public class PurOrderCheckPushPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(PurOrderCheckPushPlugin.class);
    private static final String KEY_CONFIRM = "confirm";
    private static final String CONFIRMCALLBACK = "ConfirmCallBack";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        try {
            IDataModel model = this.getModel();
            Map param = parameter.getCustomParams();
            model.setValue("ordernum", (Object)param.get("ordernum").toString());
            model.setValue("supnum", (Object)param.get("supnum").toString());
            model.setValue("orgnum", (Object)param.get("orgnum").toString());
            model.setValue("orderamt", (Object)param.get("orderamt").toString());
            model.setValue("settleamt", (Object)param.get("settleamt").toString());
            model.setValue("saloutamt", (Object)param.get("settleamt").toString());
            model.setValue("sup_currnum", (Object)param.get("sup_currnum").toString());
            model.setValue("sup_orgnum", (Object)param.get("sup_orgnum").toString());
            model.setValue("datefrom", (Object)param.get("datefrom").toString());
            model.setValue("dateto", (Object)param.get("dateto").toString());
            List rules = ConvertMetaServiceHelper.loadRules((String)"pur_ordercheck", (String)"pur_check");
            if (rules.size() == 0) {
                return;
            }
            String ruleId = null;
            for (ConvertRuleElement convertRuleElement : rules) {
                if (convertRuleElement.isEnabled()) {
                    ruleId = convertRuleElement.getId();
                }
                if (!convertRuleElement.isDefRule() || !convertRuleElement.isEnabled()) continue;
                ruleId = convertRuleElement.getId();
                break;
            }
            if (ruleId == null) {
                ruleId = ((ConvertRuleElement)rules.get(0)).getId();
            }
            this.getModel().setValue("rule", ruleId);
        }
        catch (NullPointerException exp) {
            log.warn((Throwable)exp);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "confirm": {
                Integer sup_orgnum = (Integer)this.getModel().getValue("sup_orgnum");
                Integer sup_currnum = (Integer)this.getModel().getValue("sup_currnum");
                if (sup_orgnum == 0 && sup_currnum == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"Sorry\uff0c\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8ba2\u5355\uff0c\u4e0d\u9700\u8981\u751f\u6210\u5bf9\u8d26\u5355\u3002", (String)"PurOrderCheckPushPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object rule = this.getModel().getValue("rule");
                if (null == rule) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u751f\u6210\u89c4\u5219\uff0c\u5426\u5219\u65e0\u6cd5\u751f\u6210\u5bf9\u8d26\u5355\u3002", (String)"PurOrderCheckPushPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    return;
                }
                String cfmInfo = "";
                DynamicObject ruleObj = this.getModel().getDataEntity().getDynamicObject("rule");
                cfmInfo = MessageFormat.format(ResManager.loadKDString((String)"\u6309\u89c4\u5219\u201c{0}\u201d\u751f\u6210\u5bf9\u8d26\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PurOrderCheckPushPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]), ruleObj.getLocaleString("name").getLocaleValue());
                this.getView().showConfirm(cfmInfo, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACK));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRMCALLBACK.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.confirm();
            this.getView().close();
        }
    }

    private void confirm() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List idLists = new ArrayList();
        Map param = new HashMap();
        try {
            param = parameter.getCustomParams();
            idLists = (List)param.get("billlist");
        }
        catch (NullPointerException exp) {
            log.warn((Throwable)exp);
        }
        if (idLists == null || idLists.size() == 0) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", idLists)};
        DynamicObjectCollection orderObjs = QueryServiceHelper.query((String)"pur_ordercheck", (String)"id,entryentity.id", (QFilter[])filters);
        if (orderObjs == null || orderObjs.size() == 0) {
            return;
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("pur_ordercheck");
        pushArgs.setTargetEntityNumber("pur_check");
        String ruleId = (String)this.getModel().getDataEntity().getDynamicObject("rule").getPkValue();
        pushArgs.setRuleId(ruleId);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        for (DynamicObject obj : orderObjs) {
            if (obj.getString("entryentity.id").equalsIgnoreCase("0")) continue;
            ListSelectedRow row = new ListSelectedRow();
            row.setEntryEntityKey("entryentity");
            row.setEntryPrimaryKeyValue((Object)Long.valueOf(obj.getString("entryentity.id")));
            row.setPrimaryKeyValue((Object)obj.getLong("id"));
            selectedRowList.add(row);
        }
        pushArgs.setSelectedRows(selectedRowList);
        pushArgs.setBuildConvReport(true);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"pur_check");
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
            }
        };
        if (result.isSuccess()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            option.setVariableValue("ishasright", String.valueOf(true));
            List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
            Integer billNum = 0;
            for (DynamicObject obj : targetData) {
                String dateTo;
                String dateFrom = (String)param.get("datefrom");
                if (dateFrom != null && !dateFrom.equalsIgnoreCase("")) {
                    obj.set("datefrom", (Object)Date.valueOf(dateFrom));
                }
                if ((dateTo = (String)param.get("dateto")) != null && !dateTo.equalsIgnoreCase("")) {
                    obj.set("dateto", (Object)Date.valueOf(dateTo));
                }
                obj.set("remark", (Object)this.getModel().getDataEntity().getString("remark"));
                obj.set("origin", (Object)"2");
                Integer n = billNum;
                Integer n2 = billNum = Integer.valueOf(billNum + 1);
            }
            OperationResult opResult = SaveServiceHelper.saveOperate((String)"pur_check", (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)option);
            String billNo = DynamicObjectUtil.getBillPro2Str((Object[])targetData.toArray(new DynamicObject[0]), (String)"billno");
            if (opResult.isSuccess()) {
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"pur_check", (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)option);
                if (submitResult.isSuccess()) {
                    OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"pur_check", (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)option);
                    if (auditResult.isSuccess()) {
                        HandCheckUtil.writeBackSrcBill((DynamicObject[])targetData.toArray(new DynamicObject[0]), (String)"audit", (String)"materialentry", (String)"");
                        this.getView().showMessage(MessageFormat.format(ResManager.loadKDString((String)"\u5df2\u987a\u5229\u751f\u6210{0}\u5f20\u5bf9\u8d26\u5355\u3002", (String)"PurOrderCheckPushPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]), billNum), MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a{0}", (String)"PurOrderCheckPushPlugin_4", (String)"scm-pur-formplugin", (Object[])new Object[0]), billNo), MessageTypes.Default);
                    } else {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u5bf9\u8d26\u5355\u5931\u8d25\uff0c\u8bf7\u770b\u8be6\u60c5\u3002", (String)"PurOrderCheckPushPlugin_5", (String)"scm-pur-formplugin", (Object[])new Object[0]), auditResult.getMessage() + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo()), MessageTypes.Default);
                    }
                } else {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u5bf9\u8d26\u5355\u5931\u8d25\uff0c\u8bf7\u770b\u8be6\u60c5\u3002", (String)"PurOrderCheckPushPlugin_5", (String)"scm-pur-formplugin", (Object[])new Object[0]), submitResult.getMessage() + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo()), MessageTypes.Default);
                    OperationServiceHelper.executeOperate((String)"delete", (String)"pur_check", (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)option);
                }
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u5bf9\u8d26\u5355\u5931\u8d25\uff0c\u8bf7\u770b\u8be6\u60c5\u3002", (String)"PurOrderCheckPushPlugin_5", (String)"scm-pur-formplugin", (Object[])new Object[0]), opResult.getMessage() + ExceptionUtil.getErrorInfoDetails((List)opResult.getAllErrorOrValidateInfo()), MessageTypes.Default);
            }
        } else {
            log.info(result.getMessage());
            log.info(result.getBillReports().toString());
            this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u5bf9\u8d26\u5355\u5931\u8d25\uff0c\u8bf7\u770b\u8be6\u60c5\u3002", (String)"PurOrderCheckPushPlugin_5", (String)"scm-pur-formplugin", (Object[])new Object[0]), result.getBillReports().toString(), MessageTypes.Business);
        }
    }
}

