/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.pur.formplugin.PurCoreBillEditPlugin;

public class PurOrderEditPlugin
extends PurCoreBillEditPlugin {
    private static final String BIZPARTNER = "bizpartner";
    private static final String SUPGROUP = "supgroup";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModel().getValue("billstatus").equals("D")) {
            this.setBarStatus(false);
        }
        BasedataEdit textEdit = (BasedataEdit)this.getControl("material");
        DynamicObject businesstype = this.getModel().getDataEntity().getDynamicObject("businesstype");
        if (MalNewOrderUtils.checkIsGoodsBizType((DynamicObject)businesstype)) {
            textEdit.setMustInput(false);
        } else {
            textEdit.setMustInput(true);
        }
        Object curr = this.getModel().getValue("curr");
        if (curr != null) {
            this.setDiscountRateScale(curr, "materialentry", "taxrate");
            this.setDiscountRateScale(curr, "materialentry", "dctrate");
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (ApiConfigUtil.hasEASConfig()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"issyn"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"issyn"});
        }
    }

    @Override
    protected String getStatusTabVal() {
        DynamicObject inquiryObject = this.getModel().getDataEntity();
        String logStatus = inquiryObject.getString("logstatus");
        return logStatus == null ? "" : logStatus.toLowerCase();
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "orderclose": {
                this.setBarStatus(false);
                break;
            }
            case "openorder": {
                this.setBarStatus(true);
                break;
            }
        }
    }

    protected void setBarStatus(boolean ifopen) {
        this.getView().setVisible(Boolean.valueOf(ifopen), new String[]{"bar_new", "bar_save", "bar_del", "bar_submit", "bar_audit", "bar_print"});
        this.getView().setEnable(Boolean.valueOf(ifopen), new String[]{"bar_closeorder"});
        this.getView().setEnable(Boolean.valueOf(!ifopen), new String[]{"bar_openorder"});
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        switch (propertyName) {
            case "bizpartner": {
                DynamicObject bizpartner = (DynamicObject)model.getValue(BIZPARTNER);
                DynamicObjectCollection suppliers = BizPartnerUtil.getSupplierByBizPartner((String)bizpartner.getPkValue().toString());
                if (suppliers.size() <= 0) break;
                DynamicObject supplier = (DynamicObject)suppliers.get(0);
                model.setValue(SUPGROUP, supplier.get("group.id"));
                break;
            }
        }
    }
}

