/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.suppliercollenable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.helper.scdatahandle.util.CacheKeyUtil;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.pur.business.suppliercoll.PurSupplierCollInitiateHelper;
import kd.scm.pur.common.constant.SupplierAssignConstants;

public final class PurDragBillToolPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
TabSelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit org;
        super.registerListener(e);
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("supplier");
        if (supplier != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((org = (BasedataEdit)this.getView().getControl("purorg")) != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addItemClickListeners(new String[]{"toolbarap", "confirminitiate"});
        Tab tab = (Tab)this.getView().getControl("tabap");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject channelData = SystemJointChannelHelper.getCosmicJointDataChannel();
        if (channelData != null) {
            ComboEdit executeChannelEdit = (ComboEdit)this.getView().getControl("executechannel");
            if (executeChannelEdit != null) {
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
                ComboItem linkBillConfig = new ComboItem(new LocaleString(channelData.getString("name") + "(" + channelData.getString("name") + ")"), channelData.getString("id"));
                comboItems.add(linkBillConfig);
                executeChannelEdit.setComboItems(comboItems);
            }
            this.getModel().setValue("executechannel", (Object)channelData.getString("id"));
        }
        this.getModel().setValue("entity", (Object)"pm_purorderbill");
        this.updateFilterGridValue();
        boolean orgFilterAvailable = Boolean.FALSE;
        boolean supplierFilterAvailable = Boolean.FALSE;
        Collection availablePurOrgUnits = PurSupplierCollInitiateHelper.assembleAvailablePurOrgUnits();
        if (!availablePurOrgUnits.isEmpty()) {
            this.getModel().setValue("purorg", (Object)availablePurOrgUnits.toArray());
            orgFilterAvailable = Boolean.TRUE;
        }
        Date now = TimeServiceHelper.now();
        Date lastYearDate = DateUtil.addMonth((Date)now, (int)-12);
        this.getModel().setValue("billdaterange_enddate", (Object)DateUtil.formatEndDate((Date)now));
        this.getModel().setValue("billdaterange_startdate", (Object)DateUtil.formatStartDate((Date)lastYearDate));
        Object supplierCollIdsString = this.getView().getFormShowParameter().getCustomParam(SupplierAssignConstants.SUPPLIERCOLLIDS);
        if (supplierCollIdsString != null && !supplierCollIdsString.toString().isEmpty()) {
            HashSet<Long> supplierIds = new HashSet<Long>();
            Collection supplierCollIds = (Collection)SerializationUtils.fromJsonString((String)supplierCollIdsString.toString(), Collection.class);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"pur_suppliercollinfo", (String)"supplier.id supplier", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)supplierCollIds).and(new QFilter("issuppliercoll", "=", (Object)Boolean.TRUE))}, (String)"id");){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    supplierIds.add(row.getLong("supplier"));
                }
            }
            if (!supplierIds.isEmpty()) {
                this.getModel().setValue("supplier", (Object)supplierIds.toArray());
                supplierFilterAvailable = Boolean.TRUE;
            }
        }
        if (supplierFilterAvailable && orgFilterAvailable) {
            ((ReportView)this.getView()).fireQuery();
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if (this.getNeedClick(tabKey)) {
            Map<String, Object> linkCustomShowParam;
            if ("pur_pmorderbill".equals(tabKey)) {
                linkCustomShowParam = this.getOrderCustomShowParam();
                this.putClickCache(tabKey);
            } else {
                linkCustomShowParam = this.getCustomShowParam();
                Collection<String> coreBillIds = this.getAvailableSubFormData("pur_pmorderbill");
                if (!coreBillIds.isEmpty()) {
                    linkCustomShowParam.put(SupplierAssignConstants.COREBILLIDS, SerializationUtils.toJsonString(coreBillIds));
                    this.putClickCache(tabKey);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u672a\u52fe\u9009\u6570\u636e\uff0c\u8bf7\u5148\u52fe\u9009\u91c7\u8d2d\u8ba2\u5355\u518d\u5207\u6362\u9875\u7b7e\u67e5\u770b\u5355\u636e\u6570\u636e\u3002", (String)"PurDragBillToolPlugin_7", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    Tab tab = (Tab)this.getView().getControl("tabap");
                    tab.selectTab("pur_pmorderbill");
                    tab.activeTab("pur_pmorderbill");
                }
            }
            this.showForm(tabKey, linkCustomShowParam);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection orgDataColl;
        DynamicObjectCollection supplierDataColl;
        Date tryStartDate;
        super.verifyQuery(queryParam);
        boolean checkFlag = Boolean.TRUE;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date startDate = dataEntity.getDate("billdaterange_startdate");
        Date endDate = dataEntity.getDate("billdaterange_enddate");
        if (startDate != null && endDate != null && (tryStartDate = DateUtil.formatStartDate((Date)DateUtil.addMonth((Date)endDate, (int)-12))).after(startDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4e1a\u52a1\u65e5\u671f\u8303\u56f4\u8de8\u5ea6\u8d85\u8fc7\u4e00\u5e74\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PurDragBillToolPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            checkFlag = Boolean.FALSE;
        }
        if ((supplierDataColl = dataEntity.getDynamicObjectCollection("supplier")) == null || supplierDataColl.isEmpty()) {
            checkFlag = Boolean.FALSE;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u672a\u586b\u5199\uff0c\u8bf7\u5148\u9009\u62e9\u3002", (String)"PurDragBillToolPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
        if ((orgDataColl = dataEntity.getDynamicObjectCollection("purorg")) == null || orgDataColl.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u672a\u586b\u5199\uff0c\u8bf7\u5148\u9009\u62e9\u3002", (String)"PurDragBillToolPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            checkFlag = Boolean.FALSE;
        }
        return checkFlag;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.showQueryClick();
    }

    private void showQueryClick() {
        this.resetQueryClick();
        this.resetAllSubPageCache();
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.selectTab("pur_pmorderbill");
        tab.activeTab("pur_pmorderbill");
    }

    private void resetQueryClick() {
        HashSet clickCacheSet = new HashSet(16);
        this.getPageCache().put("queryClick", SerializationUtils.toJsonString(clickCacheSet));
        HashMap orderSelectCacheMap = new HashMap(16);
        this.getPageCache().put("orderSelectedSize", SerializationUtils.toJsonString(orderSelectCacheMap));
    }

    private boolean getNeedClick(String tabKey) {
        boolean verifyClick = Boolean.FALSE;
        String queryClick = this.getPageCache().get("queryClick");
        if (queryClick != null && !queryClick.isEmpty()) {
            Collection clickCacheSet = (Collection)SerializationUtils.fromJsonString((String)queryClick, Collection.class);
            if (!clickCacheSet.contains(tabKey)) {
                verifyClick = Boolean.TRUE;
            }
        } else {
            verifyClick = Boolean.TRUE;
        }
        if (!"pur_pmorderbill".equals(tabKey)) {
            String tabSelectSize;
            String orderCacheString = this.getPageCache().get("orderSelectedSize");
            Map orderSelectCacheMap = null;
            Collection<String> orderHaveSelect = this.getAvailableSubFormData("pur_pmorderbill");
            String orderSelectedSize = String.valueOf(orderHaveSelect.size());
            if (!orderSelectedSize.equals(tabSelectSize = (String)(orderSelectCacheMap = orderCacheString != null && !orderCacheString.isEmpty() ? (Map)SerializationUtils.fromJsonString((String)orderCacheString, Map.class) : new HashMap(16)).get(tabKey))) {
                orderSelectCacheMap.put(tabKey, orderSelectedSize);
                this.getPageCache().put("orderSelectedSize", SerializationUtils.toJsonString(orderSelectCacheMap));
                verifyClick = Boolean.TRUE;
            }
        }
        return verifyClick;
    }

    private void putClickCache(String tabKey) {
        String queryClick = this.getPageCache().get("queryClick");
        Collection<String> clickCacheSet = null;
        if (queryClick != null && !queryClick.isEmpty()) {
            clickCacheSet = (Collection)SerializationUtils.fromJsonString((String)queryClick, Collection.class);
            clickCacheSet.add(tabKey);
        } else {
            clickCacheSet = new HashSet<String>(16);
            clickCacheSet.add(tabKey);
        }
        this.getPageCache().put("queryClick", SerializationUtils.toJsonString(clickCacheSet));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataEntityProperty dataEntityProperty = beforeF7SelectEvent.getProperty();
        String propertyName = dataEntityProperty.getName();
        if ("supplier".equals(propertyName)) {
            QFilter qFilter = PurSupplierCollInitiateHelper.assembleAvailableSupplierQFilter();
            qFilter = qFilter.and(new QFilter("issuppcolla", "=", (Object)"1"));
            beforeF7SelectEvent.getCustomQFilters().add(qFilter);
        }
        if ("purorg".equals(propertyName)) {
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", (Object)PurSupplierCollInitiateHelper.assembleAvailablePurOrgUnits()));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("confirminitiate".equals(key)) {
            StringBuilder message = new StringBuilder();
            Collection<String> orderHaveSelect = this.getAvailableSubFormData("pur_pmorderbill");
            String orderChangeHaveClick = this.getSubOrderSizeCache("pur_pmorderchangebill");
            String acceptDataHaveClick = this.getSubOrderSizeCache("pur_pmacceptbill");
            String receiptDataHaveClick = this.getSubOrderSizeCache("pur_imreceiptbill");
            String inStockDataHaveClick = this.getSubOrderSizeCache("pur_iminbill");
            if (orderHaveSelect.isEmpty()) {
                message.append(ResManager.loadKDString((String)"\u201c\u91c7\u8d2d\u8ba2\u5355\u201d\u5217\u8868\u672a\u52fe\u9009\uff0c\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u540c\u6b65\u7684\u6570\u636e\u3002", (String)"PurDragBillToolPlugin_8", (String)"scm-pur-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
            }
            if (orderChangeHaveClick.isEmpty()) {
                message.append(ResManager.loadKDString((String)"\u8ba2\u5355\u53d8\u66f4\u5355\u672a\u6267\u884c\u68c0\u67e5\uff0c\u8bf7\u70b9\u51fb\u201c\u8ba2\u5355\u53d8\u66f4\u5355\u201d\u9875\u7b7e\u68c0\u67e5\u6570\u636e\u3002", (String)"PurDragBillToolPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
            }
            if (acceptDataHaveClick.isEmpty()) {
                message.append(ResManager.loadKDString((String)"\u91c7\u8d2d\u9a8c\u6536\u5355\u672a\u6267\u884c\u68c0\u67e5\uff0c\u8bf7\u70b9\u51fb\u201c\u91c7\u8d2d\u9a8c\u6536\u5355\u201d\u9875\u7b7e\u68c0\u67e5\u6570\u636e\u3002", (String)"PurDragBillToolPlugin_4", (String)"scm-pur-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
            }
            if (receiptDataHaveClick.isEmpty()) {
                message.append(ResManager.loadKDString((String)"\u91c7\u8d2d\u6536\u8d27\u5355\u672a\u6267\u884c\u68c0\u67e5\uff0c\u8bf7\u70b9\u51fb\u201c\u91c7\u8d2d\u6536\u8d27\u5355\u201d\u9875\u7b7e\u68c0\u67e5\u6570\u636e\u3002", (String)"PurDragBillToolPlugin_5", (String)"scm-pur-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
            }
            if (inStockDataHaveClick.isEmpty()) {
                message.append(ResManager.loadKDString((String)"\u91c7\u8d2d\u5165\u5e93\u5355\u672a\u6267\u884c\u68c0\u67e5\uff0c\u8bf7\u70b9\u51fb\u201c\u91c7\u8d2d\u5165\u5e93\u5355\u201d\u9875\u7b7e\u68c0\u67e5\u6570\u636e\u3002", (String)"PurDragBillToolPlugin_6", (String)"scm-pur-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
            }
            if (message.length() > 0) {
                evt.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u68c0\u67e5\u5931\u8d25\u3002", (String)"PurDragBillToolPlugin_9", (String)"scm-pur-formplugin", (Object[])new Object[0]), message.toString(), MessageTypes.Default);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("confirminitiate".equals(key)) {
            this.confirmInitiatePanel();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("processTaskAction".equals(actionId)) {
            this.getView().close();
        }
    }

    private void updateFilterGridValue() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("commonfilter");
        String entityNumber = this.getModel().getDataEntity().getString("entity");
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType, false);
        ArrayList availableFilterColumns = new ArrayList(56);
        HashSet<String> availablePro = new HashSet<String>(50);
        availablePro.add("billno");
        availablePro.add("billtype");
        availablePro.add("biztype");
        availablePro.add("org");
        availablePro.add("operatorgroup");
        availablePro.add("operator");
        availablePro.add("totalallamount");
        availablePro.add("paidpreallamount");
        availablePro.add("paidallamount");
        availablePro.add("material");
        availablePro.add("qty");
        availablePro.add("receiveqty");
        availablePro.add("recretqty");
        availablePro.add("invqty");
        availablePro.add("invretqty");
        availablePro.add("amountandtax");
        availablePro.add("entryrecorg");
        availablePro.add("entrysettleorg");
        availablePro.add("deliverdate");
        availablePro.add("joinqty");
        availablePro.add("joinpayablepriceqty");
        availablePro.add("payablepriceqty");
        availablePro.add("joinamount");
        availablePro.add("performamount");
        availablePro.add("payableamount");
        availablePro.add("rowclosestatus");
        availablePro.add("rowterminatestatus");
        for (Map objectMap : filterColumns) {
            String fieldName = String.valueOf(objectMap.get("fieldName"));
            String[] fieldNames = fieldName.split("\\.");
            int atLeastOneLevel = fieldNames.length;
            availablePro.forEach(row -> {
                if (atLeastOneLevel == 2 && (fieldName.equals(row + ".number") || fieldName.equals(row + ".name"))) {
                    availableFilterColumns.add(objectMap);
                } else if (atLeastOneLevel == 1 && fieldName.equals(row)) {
                    availableFilterColumns.add(objectMap);
                }
            });
        }
        filterGrid.SetValue(new FilterCondition());
        filterGrid.setFieldColumns(availableFilterColumns);
        filterGrid.setEntityNumber(entityType.getName());
        filterGrid.setFilterColumns(availableFilterColumns);
        filterGrid.setFilterFields(new ArrayList(availablePro));
        this.getView().updateView("commonfilter");
    }

    private Map<String, Object> getOrderCustomShowParam() {
        Map<String, Object> customShowParam = this.getCustomShowParam();
        QFilter qFilter = null;
        FilterGrid grid = (FilterGrid)this.getControl("commonfilter");
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String entityNumber = this.getModel().getDataEntity().getString("entity");
        if (entityNumber != null) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            FilterBuilder filterBuilder = new FilterBuilder(entityType, condition);
            filterBuilder.buildFilter(false);
            qFilter = filterBuilder.getQFilter();
        }
        if (qFilter != null) {
            customShowParam.put(SupplierAssignConstants.CUSTOMQFILTER, SerializationUtils.toJsonString(qFilter));
        }
        return customShowParam;
    }

    private Map<String, Object> getCustomShowParam() {
        HashMap<String, Object> customShowParam = new HashMap<String, Object>(64);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection supplierDataColl = dataEntity.getDynamicObjectCollection("supplier");
        HashSet<Long> supplierIds = new HashSet<Long>(64);
        if (supplierDataColl != null) {
            for (DynamicObject supplier : supplierDataColl) {
                supplierIds.add(supplier.getLong("fbasedataid_id"));
            }
        }
        if (!supplierIds.isEmpty()) {
            customShowParam.put(SupplierAssignConstants.SUPPLIERIDS, SerializationUtils.toJsonString(supplierIds));
        }
        HashSet<Long> purOrgIds = new HashSet<Long>(64);
        DynamicObjectCollection purOrgDataColl = dataEntity.getDynamicObjectCollection("purorg");
        if (purOrgDataColl != null) {
            for (DynamicObject purorg : purOrgDataColl) {
                purOrgIds.add(purorg.getLong("fbasedataid_id"));
            }
        }
        if (!purOrgIds.isEmpty()) {
            customShowParam.put(SupplierAssignConstants.PURORGIDS, SerializationUtils.toJsonString(purOrgIds));
        }
        Date startdate = dataEntity.getDate("billdaterange_startdate");
        Date enddate = dataEntity.getDate("billdaterange_enddate");
        if (startdate != null && enddate != null) {
            customShowParam.put(SupplierAssignConstants.BILLDATERANGESTART, DateUtil.formatStartDate((Date)startdate));
            customShowParam.put(SupplierAssignConstants.BILLDATERANGEEND, DateUtil.formatEndDate((Date)enddate));
        }
        int maxReturnData = PurSupplierCollInitiateHelper.getMaxReturnData();
        customShowParam.put(SupplierAssignConstants.MAXRETURNDATA, maxReturnData);
        return customShowParam;
    }

    private void confirmInitiatePanel() {
        HashMap<String, Collection<String>> executeBillMap = new HashMap<String, Collection<String>>(1024);
        Collection<String> orderData = this.getAvailableSubFormData("pur_pmorderbill");
        executeBillMap.put(PurSupplierCollInitiateHelper.ORDERBILLIDS, orderData);
        Collection<String> orderChangeData = this.getAvailableSubFormData("pur_pmorderchangebill");
        executeBillMap.put(PurSupplierCollInitiateHelper.ORDERCHANGEBILLIDS, orderChangeData);
        Collection<String> acceptData = this.getAvailableSubFormData("pur_pmacceptbill");
        executeBillMap.put(PurSupplierCollInitiateHelper.ACCEPTBILLIDS, acceptData);
        Collection<String> receiptData = this.getAvailableSubFormData("pur_imreceiptbill");
        executeBillMap.put(PurSupplierCollInitiateHelper.RECEIPTBILLIDS, receiptData);
        Collection<String> receiptReturnData = this.getAvailableSubFormData("pur_iminbill");
        executeBillMap.put(PurSupplierCollInitiateHelper.INBILLBILLIDS, receiptReturnData);
        HashMap<String, String> customParamMap = new HashMap<String, String>(16);
        customParamMap.put(PurSupplierCollInitiateHelper.EXECUTECHANNEL, this.getModel().getDataEntity().getString("executechannel"));
        customParamMap.put(PurSupplierCollInitiateHelper.BATCHSIZE, String.valueOf(PurSupplierCollInitiateHelper.getOpBatchCount()));
        String taskId = PurSupplierCollInitiateHelper.dispatchExecuteBillTask(executeBillMap, customParamMap);
        this.showProcessTask(taskId);
        this.getView().setVisible(Boolean.FALSE, new String[]{"preview_image", "preview_imaged", "matchorder_image", "matchorder_imaged", "fs_previewschdule", "fs_matchorderinfo", "fs_modifymatchdata", "fs_matchdeliverbar"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"fs_matchdeliverbar", "fs_previewschdule", "preview_imaged", "matchorder_image"});
    }

    private void putSubpageIdCache(String entityNumber, String pageId) {
        this.getPageCache().put(CacheKeyUtil.makeCacheKey((String)"pur", (String)entityNumber), pageId);
    }

    private String getSubpageIdCache(String entityNumber) {
        return this.getPageCache().get(CacheKeyUtil.makeCacheKey((String)"pur", (String)entityNumber));
    }

    private void resetAllSubPageCache() {
        ArrayList<String> pageCacheList = new ArrayList<String>(8);
        pageCacheList.add(CacheKeyUtil.makeCacheKey((String)"pur", (String)"pur_pmorderbill"));
        pageCacheList.add(CacheKeyUtil.makeCacheKey((String)"pur", (String)"pur_pmacceptbill"));
        pageCacheList.add(CacheKeyUtil.makeCacheKey((String)"pur", (String)"pur_imreceiptbill"));
        pageCacheList.add(CacheKeyUtil.makeCacheKey((String)"pur", (String)"pur_iminbill"));
        this.getPageCache().batchRemove(pageCacheList);
    }

    private String getSubOrderSizeCache(String tabKey) {
        Map orderSelectCacheMap;
        String orderSelectCache = null;
        String orderCacheString = this.getPageCache().get("orderSelectedSize");
        Collection<String> orderHaveSelect = this.getAvailableSubFormData("pur_pmorderbill");
        String orderSelectedSize = String.valueOf(orderHaveSelect.size());
        orderSelectCache = orderCacheString != null && !orderCacheString.isEmpty() ? (orderSelectedSize.equals(orderSelectCache = (String)(orderSelectCacheMap = (Map)SerializationUtils.fromJsonString((String)orderCacheString, Map.class)).get(tabKey)) ? orderSelectedSize : "") : "";
        return orderSelectCache;
    }

    private Collection<String> getAvailableSubFormData(String entityNumber) {
        String subBillPageId = this.getSubpageIdCache(entityNumber);
        HashSet<String> availableBillIds = new HashSet<String>(1024);
        if (subBillPageId != null) {
            FormView formView = (FormView)this.getView().getView(subBillPageId);
            BillList billlistap = (BillList)formView.getControl("billlistap");
            ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
            if ("pur_pmorderbill".equals(entityNumber)) {
                listSelectedRows.addAll((Collection)this.getSelectRows(billlistap));
            } else {
                listSelectedRows.addAll((Collection)billlistap.getCurrentListAllRowCollection());
            }
            listSelectedRows.forEach(listSelectedRow -> availableBillIds.add(listSelectedRow.getPrimaryKeyValue().toString()));
        }
        return availableBillIds;
    }

    private ListSelectedRowCollection getSelectRows(BillList billlistap) {
        return billlistap.getSelectedRows();
    }

    private void showForm(String subPageFormId, Map<String, Object> customShowParam) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(subPageFormId);
        if (customShowParam != null && !customShowParam.isEmpty()) {
            for (Map.Entry<String, Object> entry : customShowParam.entrySet()) {
                param.setCustomParam(entry.getKey(), entry.getValue());
            }
        }
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(subPageFormId);
        this.getView().showForm(param);
        this.putSubpageIdCache(subPageFormId, param.getPageId());
    }

    private void showProcessTask(String taskId) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("pur_taskprogress");
        param.setCustomParam("taskId", (Object)taskId);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.getOpenStyle().setTargetKey("taskId");
        param.setStatus(OperationStatus.VIEW);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "processTaskAction"));
        this.getView().showForm(param);
    }
}

