/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.suppliercollenable.data;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.pur.common.constant.SupplierAssignConstants;

abstract class AbstractPurDataPlugin
extends AbstractFormPlugin {
    AbstractPurDataPlugin() {
    }

    public final void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshData(true);
    }

    protected void executeCreateNewData(List<QFilter> qFilterList) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        qFilterList.add(new QFilter("billstatus", "=", (Object)"C"));
        Object supplierIds = customParams.get(SupplierAssignConstants.SUPPLIERIDS);
        if (supplierIds != null) {
            qFilterList.add(new QFilter("supplier.id", "in", SerializationUtils.fromJsonString((String)supplierIds.toString(), Collection.class)));
        } else {
            qFilterList.add(new QFilter("supplier.id", "=", (Object)0L));
        }
        Object bizDateStart = customParams.get(SupplierAssignConstants.BILLDATERANGESTART);
        if (bizDateStart instanceof String) {
            qFilterList.add(new QFilter("biztime", ">=", (Object)DateUtil.string2date((String)bizDateStart.toString(), (String)"yyyy-MM-dd HH:mm:ss")));
        } else {
            Date now = TimeServiceHelper.now();
            qFilterList.add(new QFilter("biztime", ">=", (Object)DateUtil.formatStartDate((Date)DateUtil.addMonth((Date)now, (int)-12))));
        }
    }

    public final void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.refreshData(false);
    }

    protected final void refreshData(boolean clear) {
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        if (billlistap != null) {
            List qFilterList = billlistap.getQueryFilterParameter().getQFilters();
            this.executeCreateNewData(qFilterList);
            billlistap.setSelectedAll(clear);
            billlistap.refreshData();
        }
    }
}

