/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.PlatformEnums;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.jd.errorcode.JDAPIErrorCode;
import kd.scm.common.jd.util.JDAccessTokenUtil;
import kd.scm.common.jd.util.JDHttpsUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pur.common.ecinvoice.service.impl.GenericEcInvoiceService;
import net.sf.json.JSONObject;

public class PurEcInvoiceAllHelper {
    private static Log log = LogFactory.getLog(PurEcInvoiceAllHelper.class);

    private void updateinvoceType(DynamicObject[] malJdOrderdyos, Map<String, Object> dataMap) {
        Map invoiceTypeMap = (Map)dataMap.get("invoceTypeMap");
        HashMap<String, String> invoiceTypeToEcInvTypeMap = new HashMap<String, String>();
        for (DynamicObject dyo : malJdOrderdyos) {
            String number = dyo.getString("number");
            String invoicetype = (String)invoiceTypeMap.get(number);
            if (invoicetype == null) continue;
            String ecInvType = (String)invoiceTypeToEcInvTypeMap.get(invoicetype);
            if (ecInvType == null) {
                ecInvType = GenericEcInvoiceService.ierpMapEcInvType((String)invoicetype, (String)EcPlatformEnum.ECPLATFORM_JD.getVal());
                invoiceTypeToEcInvTypeMap.put(invoicetype, ecInvType);
            }
            if (StringUtils.isNotEmpty((CharSequence)ecInvType)) {
                dyo.set("invoicetype", (Object)ecInvType);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("@@\u53d1\u7968\u7c7b\u578b\u503c\u4e3a\u7a7a\u3002" + invoiceTypeMap);
        }
        SaveServiceHelper.save((DynamicObject[])malJdOrderdyos);
    }

    public List<String> invoiceSubmit(Map<String, Object> dataMap) {
        String[] jdAddress;
        DynamicObjectCollection dyoCol = (DynamicObjectCollection)dataMap.get("data");
        ArrayList<String> failList = new ArrayList<String>();
        HashMap<String, Object> invoiceMap = new HashMap<String, Object>();
        HashMap<String, String> invoiceStateMap = new HashMap<String, String>();
        HashMap<String, String> markIdMap = new HashMap<String, String>();
        HashSet<String> jdChildOrderSet = new HashSet<String>(dyoCol.size());
        Set childOrderSet = null;
        for (DynamicObject dyo : dyoCol) {
            jdChildOrderSet.add(dyo.getString("jdchildorderid"));
        }
        QFilter malOrderFilter = new QFilter("number", "in", jdChildOrderSet);
        DynamicObject[] malJDOrderdyos = BusinessDataServiceHelper.load((String)"pbd_jdorder", (String)"number,invoicestate,markid,invoiceresult,invoicetype", (QFilter[])new QFilter[]{malOrderFilter});
        this.updateinvoceType(malJDOrderdyos, dataMap);
        log.info("@@@\u672c\u6b21\u7533\u8bf7\u5f00\u7968\u7684\u5b50\u8ba2\u5355\u53f7\uff1a" + jdChildOrderSet);
        List<DynamicObject> targetData = this.autoCreatePurInvoice(jdChildOrderSet);
        if (targetData == null) {
            throw new KDBizException(new ErrorCode("getSourceBill error", ResManager.loadKDString((String)"\u7533\u8bf7\u5f00\u7968\u5f02\u5e38\uff0c\u751f\u6210\u53d1\u7968\u7b7e\u6536\u5355\u5f02\u5e38\u3002", (String)"PurEcInvoiceAllHelper_0", (String)"scm-pur-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        StringBuilder submitData = new StringBuilder();
        int billToProvinceId = 0;
        int billToCityId = 1;
        int billToCountyId = 2;
        String[] stringArray = jdAddress = dataMap.get("jdaddressnum") != null ? String.valueOf(dataMap.get("jdaddressnum")).split("_") : new String[]{};
        if (jdAddress.length == 3) {
            submitData.append("&billToProvince=").append(jdAddress[billToProvinceId]);
            submitData.append("&billToCity=").append(jdAddress[billToCityId]);
            submitData.append("&billToCounty=").append(jdAddress[billToCountyId]);
            submitData.append("&billToTown=").append('0');
            submitData.append("&billToAddress=").append(dataMap.get("revaddressdetail"));
        }
        if (StringUtils.isNotBlank((Object)dataMap.get("revname")) && StringUtils.isNotBlank((Object)dataMap.get("revphone"))) {
            submitData.append("&billToer=").append(dataMap.get("revname"));
            submitData.append("&billToContact=").append(dataMap.get("revphone"));
        }
        String token = this.getInvoiceToken();
        submitData.append("&token=").append(token);
        String invoiceOrg = this.getInvoiceOrgCode();
        submitData.append("&invoiceOrg=").append(invoiceOrg);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        submitData.append("&invoiceDate=").append(format.format(new Date()));
        StringBuilder saveErrorSb = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        block23: for (DynamicObject targetbill : targetData) {
            String data = this.getInvoiceSubmitData(targetbill, dataMap, invoiceMap);
            data = new StringBuilder(submitData).append(data).toString();
            childOrderSet = (Set)invoiceMap.get("childOrderSet");
            String json = JDHttpsUtil.httpsJDPost((String)"https://bizapi.jd.com/api/invoice/submit", (String)data);
            sb.append("data:").append(data).append("result:").append(json);
            JSONObject node = JSONObject.fromObject((Object)json);
            if (node.getBoolean("success")) {
                String code;
                switch (code = node.getString("resultCode")) {
                    case "2007": 
                    case "3304": 
                    case "5002": 
                    case "3302": {
                        for (String childid : childOrderSet) {
                            failList.add(childid);
                            invoiceStateMap.put(childid, PurEcInvoiceEnum.INVOICEFAILED.getVal());
                        }
                        continue block23;
                    }
                    default: {
                        try {
                            for (String childid : childOrderSet) {
                                invoiceStateMap.put(childid, PurEcInvoiceEnum.HANDLING.getVal());
                                markIdMap.put(childid, (String)invoiceMap.get("markId"));
                            }
                            OperationResult saveResult = this.aftercreateBill(targetbill, dataMap, invoiceMap);
                            if (saveResult.isSuccess()) continue block23;
                            throw new KDBizException(new ErrorCode("operation error", ResManager.loadKDString((String)"\u751f\u6210\u5f00\u7968\u8bb0\u5f55\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PurEcInvoiceAllHelper_3", (String)"scm-pur-formplugin", (Object[])new Object[0])), new Object[]{ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo())});
                        }
                        catch (Exception e) {
                            saveErrorSb.append("@@@kd.scm.pur.formplugin.util.PurEcInvoiceAllHelper.autoCreatePurInvoice save error:").append(ExceptionUtil.getStackTrace((Throwable)e)).append(System.lineSeparator());
                            for (String childid : childOrderSet) {
                                failList.add(childid);
                                invoiceStateMap.put(childid, PurEcInvoiceEnum.INVOICEFAILED.getVal());
                            }
                            continue block23;
                        }
                    }
                }
            }
            for (String childid : childOrderSet) {
                failList.add(0, childid);
                invoiceStateMap.put(childid, PurEcInvoiceEnum.INVOICEFAILED.getVal());
            }
        }
        if (sb.length() > 0) {
            log.info("@@@invoiceSubmit\u7533\u8bf7\u5f00\u7968data\u53ca\u8c03\u7528\u7533\u8bf7\u5f00\u7968\u63a5\u53e3\u7ed3\u679c\uff1a", (Object)sb.toString());
        }
        if (saveErrorSb.length() > 0) {
            log.error("@@@\u751f\u6210\u5f00\u7968\u5355\u5931\u8d25\uff1a{}", (Object)saveErrorSb.toString());
        }
        try (TXHandle h = TX.requiresNew();){
            this.updateJdInvoiceState(invoiceStateMap, markIdMap, malJDOrderdyos);
        }
        catch (Exception e) {
            log.error("@@@kd.scm.pur.formplugin.util.PurEcInvoiceAllHelper.invoiceSubmit\u5f00\u7968\u53cd\u5199\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0" + ExceptionUtil.getStackTrace((Throwable)e));
        }
        return failList;
    }

    private void updateJdInvoiceState(Map<String, String> invoiceStateMap, Map<String, String> markIdMap, DynamicObject[] dyos) {
        for (DynamicObject dyo : dyos) {
            String markIdNum;
            String number = dyo.getString("number");
            String invoiceStateNum = invoiceStateMap.get(number);
            if (invoiceStateNum != null) {
                dyo.set("invoicestate", (Object)invoiceStateNum);
                dyo.set("invoiceresult", (Object)" ");
            }
            if ((markIdNum = markIdMap.get(number)) == null) continue;
            dyo.set("markid", (Object)markIdNum);
        }
        SaveServiceHelper.save((DynamicObject[])dyos);
    }

    private String getInvoiceSubmitData(DynamicObject targetbill, Map<String, Object> dataMap, Map<String, Object> invoiceMap) {
        StringBuilder data = new StringBuilder();
        Map amountMap = (Map)dataMap.get("amountmap");
        DynamicObjectCollection entries = null;
        HashSet<String> childOrderSet = new HashSet<String>();
        String invType = null;
        String markId = null;
        String childOrder = null;
        StringBuilder childOrderStr = new StringBuilder();
        DynamicObject invoiceorg = null;
        BigDecimal invoiceAmount = new BigDecimal("0.00");
        entries = targetbill.getDynamicObjectCollection("entryentity1");
        invType = targetbill.getString("invtype");
        invoiceorg = targetbill.getDynamicObject("org");
        for (DynamicObject entry : entries) {
            DynamicObject entryjdorder = entry.getDynamicObject("entryjdorder");
            if (entryjdorder == null || !childOrderSet.add(childOrder = entryjdorder.getString("number"))) continue;
            childOrderStr.append(childOrder).append(',');
            if (amountMap.get(childOrder) == null) continue;
            invoiceAmount = invoiceAmount.add((BigDecimal)amountMap.get(childOrder));
        }
        markId = this.createMarkId(childOrder);
        data.append("&supplierOrder=").append(childOrderStr.toString().substring(0, childOrderStr.length() - 1));
        if (StringUtils.equals((CharSequence)invType, (CharSequence)"6")) {
            data.append("&invoiceType=").append(2);
        } else {
            data.append("&invoiceType=").append(3);
        }
        data.append("&markId=").append(markId);
        data.append("&settlementId=").append(markId);
        if (invoiceorg != null) {
            data.append("&enterpriseTaxpayer=").append(invoiceorg.getString("ftaxregnum").trim());
            data.append("&title=").append(invoiceorg.getString("ffirmname.zh_CN").trim());
        }
        data.append("&bizInvoiceContent=").append(1);
        data.append("&invoiceNum=").append(childOrderSet.size());
        data.append("&invoicePrice=").append(invoiceAmount);
        data.append("&currentBatch=").append(1);
        data.append("&totalBatch=").append(1);
        data.append("&totalBatchInvoiceAmount=").append(invoiceAmount);
        invoiceMap.put("jdchildorderid", childOrderStr.toString());
        invoiceMap.put("invtype", invType);
        invoiceMap.put("markId", markId);
        invoiceMap.put("invdetail", "1");
        invoiceMap.put("invoiceamount", String.valueOf(invoiceAmount));
        invoiceMap.put("childOrderSet", childOrderSet);
        return data.toString();
    }

    private String getInvoiceOrgCode() {
        String enterpriseId = RequestContext.getOrCreate().getTenantId();
        String selectFields = "invoiceorgcode";
        QFilter qfiter = new QFilter("tenantid", "=", (Object)enterpriseId);
        qfiter.and(new QFilter("platform", "=", (Object)PlatformEnums.JD.getValue()));
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"pmm_ecadmit", (String)selectFields, (QFilter[])new QFilter[]{qfiter});
        if (null != dyo && StringUtils.isNotBlank((CharSequence)dyo.getString("invoiceorgcode"))) {
            return dyo.getString("invoiceorgcode");
        }
        return "544";
    }

    private String createMarkId(String jdChildOrderId) {
        Calendar calendar = Calendar.getInstance();
        StringBuilder markId = new StringBuilder();
        String d = new SimpleDateFormat("yyyyMMddHHmmSS").format(calendar.getTime());
        markId.append(d).append('-').append(jdChildOrderId);
        return markId.toString();
    }

    public String getInvoiceToken() {
        String enterpriseId = RequestContext.getOrCreate().getTenantId();
        try {
            return JDAccessTokenUtil.getAccessTokenByKD((String)enterpriseId);
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                throw new KDBizException(JDAPIErrorCode.GET_JDTOKEN_FAILED, new Object[0]);
            }
            throw new KDException(JDAPIErrorCode.SYS_ERROR, new Object[]{ExceptionUtil.getStackTrace((Throwable)e)});
        }
    }

    private DynamicObjectCollection getPurOrderData(Set<String> jdChildOrderSet, String entityKey) {
        QFilter filter = new QFilter("materialentry.jdorder.number", "in", jdChildOrderSet);
        return QueryServiceHelper.query((String)entityKey, (String)"id,materialentry.id entryentity", (QFilter[])new QFilter[]{filter});
    }

    public List<DynamicObject> autoCreatePurInvoice(Set<String> jdChildOrderSet) {
        List targetData = null;
        DynamicObjectCollection billColl = this.getPurOrderData(jdChildOrderSet, "pur_order");
        if (null == billColl) {
            throw new KDBizException(new ErrorCode("getSourceBill error", ResManager.loadKDString((String)"\u7533\u8bf7\u5f00\u7968\u751f\u6210\u5f00\u7968\u8bb0\u5f55\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PurEcInvoiceAllHelper_1", (String)"scm-pur-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        if (null != billColl && billColl.size() > 0) {
            PushArgs pushArgs = new PushArgs();
            pushArgs.setRuleId("919591508682895360");
            pushArgs.setSourceEntityNumber("pur_order");
            pushArgs.setTargetEntityNumber("pur_invoice");
            pushArgs.setBuildConvReport(true);
            ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
            for (DynamicObject billData : billColl) {
                ListSelectedRow row = new ListSelectedRow((Object)billData.getLong("id"));
                row.setEntryEntityKey("materialentry");
                row.setEntryPrimaryKeyValue((Object)billData.getLong("entryentity"));
                selectedRowList.add(row);
            }
            pushArgs.setSelectedRows(selectedRowList);
            ConvertOperationResult result = null;
            try {
                result = ConvertServiceHelper.push((PushArgs)pushArgs);
            }
            catch (Exception e) {
                throw new KDException(new ErrorCode("push error", ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u6267\u884c\u3002", (String)"PurEcInvoiceAllHelper_2", (String)"scm-pur-formplugin", (Object[])new Object[0])), new Object[]{e.getMessage()});
            }
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"pur_invoice");
            if (result.isSuccess()) {
                targetData = result.loadTargetDataObjects(new IRefrencedataProvider(){

                    public void fillReferenceData(Object[] objects, IDataEntityType iDataEntityType) {
                        BusinessDataServiceHelper.loadRefence((Object[])objects, (IDataEntityType)iDataEntityType);
                    }
                }, mainType);
            } else {
                log.info("@@@kd.scm.pur.formplugin.util.PurEcInvoiceAllHelper.autoCreatePurInvoice:\u5355\u636e\u4e0b\u63a8\u5931\u8d25\uff1a" + result.getMessage() + result.getReports());
            }
        }
        return targetData;
    }

    private OperationResult aftercreateBill(DynamicObject targetbill, Map<String, Object> dataMap, Map<String, Object> invoiceMap) {
        this.handleAfterPushBills(targetbill, dataMap, invoiceMap);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("WF", String.valueOf(false));
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pur_invoice", (DynamicObject[])new DynamicObject[]{targetbill}, (OperateOption)option);
        return saveResult;
    }

    public void handleAfterPushBills(DynamicObject targetData, Map<String, Object> dataMap, Map<String, Object> invoiceMap) {
        targetData.set("revname", dataMap.get("revname"));
        targetData.set("revphone", dataMap.get("revphone"));
        targetData.set("revaddress", (Object)(dataMap.get("wholeaddress") + "&" + dataMap.get("revaddress") + "&" + dataMap.get("jdaddressnum")));
        targetData.set("invdetail", (Object)"2");
        targetData.set("reqperson", (Object)RequestContext.get().getUserId());
        targetData.set("sumtaxamount", (Object)CommonUtil.getBigDecimalPro((Object)invoiceMap.get("invoiceamount")));
        targetData.set("payableamt", (Object)CommonUtil.getBigDecimalPro((Object)invoiceMap.get("invoiceamount")));
    }
}

