/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.InquiryUtil;
import kd.scm.pur.common.utils.SouPermUtils;

public class PurInquiryOpHelper {
    public static void openCompareToolPage(AbstractMobBillPlugIn plugin, IDataModel model, IFormView view, String formId, int selectedInqryEIdx) {
        Map<String, List<Map<String, Object>>> idxToQuoParams;
        Object id = model.getValue("id");
        DynamicObject inquiryBill = PurInquiryOpHelper.getInquiryBill(id);
        if (null == inquiryBill) {
            return;
        }
        if (PurInquiryOpHelper.validateCompare(view, inquiryBill)) {
            return;
        }
        String billSatus = inquiryBill.getString("billstatus");
        String bizstatus = String.valueOf(inquiryBill.getString("bizstatus"));
        String opentype = inquiryBill.getString("opentype");
        Date enddate = inquiryBill.getDate("enddate");
        DynamicObjectCollection materialEntry = model.getEntryEntity("materialentry");
        HashMap<String, String> entryIdToIdx = new HashMap<String, String>(16);
        for (DynamicObject row : materialEntry) {
            String entryId = String.valueOf(row.getLong("id"));
            String index = String.valueOf(row.getInt("seq") - 1);
            entryIdToIdx.put(entryId, index);
        }
        if (entryIdToIdx.size() == 0) {
            return;
        }
        if (BillStatusEnum.AUDIT.getVal().equals(billSatus) && ("B".equals(bizstatus) || "1".equals(opentype) && enddate.before(new Date()))) {
            String inquiryNo = (String)model.getValue("billno");
            String indexToQuoInfo = plugin.getPageCache().get("quotecustomparams");
            idxToQuoParams = new HashMap(16);
            if (StringUtils.isEmpty((CharSequence)indexToQuoInfo)) {
                Map<String, List<Map<String, Object>>> entryIdToQuoInfo = PurInquiryOpHelper.buildQuoCustomParams(inquiryNo, entryIdToIdx.keySet());
                if (entryIdToQuoInfo == null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6709\u6548\u7684\u4f9b\u5e94\u5546\u62a5\u4ef7,\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"PurInquiryOpHelper_15", (String)"scm-pur-mobile", (Object[])new Object[0]));
                    return;
                }
                for (Map.Entry<String, List<Map<String, Object>>> quoParams : entryIdToQuoInfo.entrySet()) {
                    PurInquiryOpHelper.reSetDefAdoptQuoPrice(entryIdToIdx, idxToQuoParams, quoParams);
                }
            } else {
                idxToQuoParams = (Map)SerializationUtils.fromJsonString((String)indexToQuoInfo, Map.class);
            }
            if (idxToQuoParams == null || idxToQuoParams.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6709\u6548\u7684\u4f9b\u5e94\u5546\u62a5\u4ef7,\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"PurInquiryOpHelper_15", (String)"scm-pur-mobile", (Object[])new Object[0]));
                return;
            }
            List currIndexQuoteInfo = (List)idxToQuoParams.get(String.valueOf(selectedInqryEIdx));
            if (currIndexQuoteInfo == null || currIndexQuoteInfo.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6709\u6548\u7684\u4f9b\u5e94\u5546\u62a5\u4ef7,\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"PurInquiryOpHelper_15", (String)"scm-pur-mobile", (Object[])new Object[0]));
                return;
            }
        } else {
            view.showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"PurInquiryOpHelper_16", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return;
        }
        Map<String, Map<String, Object>> indexToInqryParams = PurInquiryOpHelper.getMulInquiryCustParams(model);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("inquiryBillId", model.getDataEntity().getPkValue());
        paramMap.put("inquiryid", model.getValue("id"));
        paramMap.put("inquiryno", model.getValue("billno"));
        paramMap.put("currentryrowindex", String.valueOf(selectedInqryEIdx));
        paramMap.put("quotecustomparams", idxToQuoParams);
        paramMap.put("inquirycustomparams", indexToInqryParams);
        view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)formId, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)plugin, "compareToolAtionId"), (ShowType)ShowType.Floating));
    }

    private static void reSetDefAdoptQuoPrice(Map<String, String> entryIdToIdx, Map<String, List<Map<String, Object>>> idxToQuoParams, Map.Entry<String, List<Map<String, Object>>> quoParams) {
        Long quoEntryId;
        Map<String, Object> quoInfo;
        int i;
        Long minTaxPriceEntryId = 0L;
        BigDecimal minTaxPrice = BigDecimal.ZERO;
        String index = entryIdToIdx.get(quoParams.getKey());
        List<Map<String, Object>> quoInfos = quoParams.getValue();
        for (i = 0; i < quoInfos.size(); ++i) {
            quoInfo = quoInfos.get(i);
            quoEntryId = (Long)quoInfo.get("entryid");
            BigDecimal taxPrice = (BigDecimal)quoInfo.get("taxprice");
            if (i != 0 && minTaxPrice.compareTo(taxPrice) <= 0) continue;
            minTaxPrice = taxPrice;
            minTaxPriceEntryId = quoEntryId;
        }
        for (i = 0; i < quoInfos.size(); ++i) {
            quoInfo = quoInfos.get(i);
            quoEntryId = (Long)quoInfo.get("entryid");
            if (!minTaxPriceEntryId.equals(quoEntryId)) continue;
            quoInfo.put("isadopt", "1");
        }
        idxToQuoParams.put(index, quoInfos);
    }

    private static boolean validateCompare(IFormView view, DynamicObject inquiryBill) {
        Long pkId = inquiryBill.getLong("id");
        ArrayList<String> errMsgList = new ArrayList<String>();
        if (!SouPermUtils.hasSouBillViewRightForOrg(pkId, "sou_inquiry", "sou_inquiry")) {
            errMsgList.add(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709[\u8be2\u4ef7\u5355]\u7684[\u67e5\u8be2]\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"PurInquiryOpHelper_6", (String)"scm-pur-mobile", (Object[])new Object[0]));
        }
        if (!SouPermUtils.hasSouBillViewRightForOrg(pkId, "sou_inquiry", "sou_quote")) {
            errMsgList.add(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709[\u62a5\u4ef7\u67e5\u8be2]\u7684[\u67e5\u8be2]\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"PurInquiryOpHelper_7", (String)"scm-pur-mobile", (Object[])new Object[0]));
        }
        if (!SouPermUtils.hasSouBillViewRightForOrg(pkId, "sou_inquiry", "sou_comparetool")) {
            errMsgList.add(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709[\u6bd4\u4ef7\u52a9\u624b]\u7684[\u67e5\u8be2]\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"PurInquiryOpHelper_8", (String)"scm-pur-mobile", (Object[])new Object[0]));
        }
        if (!errMsgList.isEmpty()) {
            view.showErrorNotification(String.join((CharSequence)"\uff0c", errMsgList));
            return true;
        }
        String billSatus = inquiryBill.getString("billstatus");
        String bizstatus = String.valueOf(inquiryBill.getString("bizstatus"));
        if (!BillStatusEnum.AUDIT.getVal().equals(billSatus)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"PurInquiryOpHelper_9", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return true;
        }
        Date enddate = inquiryBill.getDate("enddate");
        String billno = inquiryBill.getString("billno");
        ArrayList<String> billNos = new ArrayList<String>();
        billNos.add(inquiryBill.getString("billno"));
        DynamicObject[] quoteBills = InquiryUtil.getQuoteBillByInquiryBillNo(billNos);
        if (enddate.after(new Date())) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u672a\u5230\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"PurInquiryOpHelper_10", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return true;
        }
        if (BizStatusEnum.ENROLMENT.getVal().equals(bizstatus)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u672a\u5f00\u6807\uff0c\u4e0d\u80fd\u8fdb\u884c\u6bd4\u4ef7\u3002", (String)"PurInquiryOpHelper_11", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return true;
        }
        if (BizStatusEnum.END.getVal().equals(bizstatus)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u7ec8\u6b62\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"PurInquiryOpHelper_12", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return true;
        }
        DynamicObject[] compareCol = PurInquiryOpHelper.getCompareData(billno);
        if (compareCol != null && compareCol.length >= 1) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u6bd4\u4ef7\u5355\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"PurInquiryOpHelper_13", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return true;
        }
        if (quoteBills.length == 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4f9b\u5e94\u5546\u62a5\u4ef7\uff0c\u65e0\u6cd5\u6bd4\u4ef7\u3002", (String)"PurInquiryOpHelper_14", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public static DynamicObject[] getCompareData(String inquiryNo) {
        HashMap paramMap = new HashMap(16);
        HashMap<String, String> inquiryNoMap = new HashMap<String, String>(16);
        inquiryNoMap.put("=", inquiryNo);
        paramMap.put("inquiryno", inquiryNoMap);
        return ORMUtil.load((String)"sou_compare", (String)"billno", paramMap);
    }

    public static Map<String, Object> getInquiryCustParams(IDataModel model) {
        int currEntryIndex = model.getEntryCurrentRowIndex("materialentry");
        HashMap<String, Object> inquiryCustParams = new HashMap<String, Object>(16);
        DynamicObject material = (DynamicObject)model.getValue("material", currEntryIndex);
        Long materialId = material == null ? 0L : material.getLong("id");
        String materialModel = material == null ? "" : material.getString("modelnum");
        String materialDesc = (String)model.getValue("materialdesc", currEntryIndex);
        BigDecimal qty = (BigDecimal)model.getValue("qty", currEntryIndex);
        DynamicObject unit = (DynamicObject)model.getValue("unit", currEntryIndex);
        Long unitId = unit == null ? 0L : unit.getLong("id");
        inquiryCustParams.put("material", materialId);
        inquiryCustParams.put("materialmodel", materialModel);
        inquiryCustParams.put("materialdesc", materialDesc);
        inquiryCustParams.put("qty", qty);
        inquiryCustParams.put("unit", unitId);
        return inquiryCustParams;
    }

    public static Map<String, Map<String, Object>> getMulInquiryCustParams(IDataModel model) {
        HashMap<String, Map<String, Object>> indexToInquiryInfo = new HashMap<String, Map<String, Object>>(16);
        DynamicObjectCollection entryEntity = model.getEntryEntity("materialentry");
        for (DynamicObject entry : entryEntity) {
            String index = String.valueOf(entry.getInt("seq") - 1);
            HashMap<String, Object> inquiryCustParams = new HashMap<String, Object>(16);
            DynamicObject material = entry.getDynamicObject("material");
            Long materialId = material == null ? 0L : material.getLong("id");
            String materialModel = material == null ? "" : material.getString("modelnum");
            String materialDesc = entry.getString("materialdesc");
            BigDecimal qty = entry.getBigDecimal("qty");
            DynamicObject unit = entry.getDynamicObject("unit");
            Long unitId = unit == null ? 0L : unit.getLong("id");
            DynamicObject rcvOrg = entry.getDynamicObject("entryrcvorg");
            Long rcvOrgId = rcvOrg == null ? 0L : rcvOrg.getLong("id");
            DynamicObject reqOrg = entry.getDynamicObject("entryreqorg");
            Long reqOrgId = reqOrg == null ? 0L : reqOrg.getLong("id");
            inquiryCustParams.put("material", materialId);
            inquiryCustParams.put("materialmodel", materialModel);
            inquiryCustParams.put("materialdesc", materialDesc);
            inquiryCustParams.put("qty", qty);
            inquiryCustParams.put("unit", unitId);
            inquiryCustParams.put("entryrcvorg", rcvOrgId);
            inquiryCustParams.put("entryreqorg", reqOrgId);
            indexToInquiryInfo.put(index, inquiryCustParams);
        }
        return indexToInquiryInfo;
    }

    public static void terminate(IFormPlugin plugin, IDataModel model, IFormView view, String formId) {
        Object id = model.getValue("id");
        DynamicObject inquiryObj = PurInquiryOpHelper.getInquiryBill(id);
        if (null == inquiryObj) {
            return;
        }
        String bizStatusPage = (String)model.getValue("bizstatus");
        String bizStatus = inquiryObj.getString("bizstatus");
        if (bizStatus != null && !bizStatus.equals(bizStatusPage) || bizStatus == null && bizStatusPage != null) {
            view.showMessage(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u66f4\u65b0\uff0c\u8bf7\u5148\u5237\u65b0\u6570\u636e\u3002", (String)"PurInquiryOpHelper_5", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return;
        }
        if (BillStatusEnum.CLOSED.getVal().equals(bizStatus)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u6267\u884c\uff0c\u4e0d\u80fd\u7ec8\u6b62\u3002", (String)"PurInquiryOpHelper_0", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return;
        }
        if (BillStatusEnum.CHANGED.getVal().equals(bizStatus)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u7ec8\u6b62\uff0c\u65e0\u9700\u7ec8\u6b62\u3002", (String)"PurInquiryOpHelper_1", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return;
        }
        PurInquiryOpHelper.openPage(plugin, model, view, formId, "inquiryTerminateAtionId", ShowType.Modal);
    }

    public static List<Map<String, Object>> buildQuoCustomParams(IDataModel model, String entryId) {
        String turns;
        String inquiryNo = (String)model.getValue("billno");
        DynamicObjectCollection quoteDyObjs = PurInquiryOpHelper.queryRelatedQuteBill(inquiryNo, turns = (String)model.getValue("turns"), entryId);
        int quoteDataSize = quoteDyObjs.size();
        if (quoteDataSize == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> quoteBillParams = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject quoteDyObj : quoteDyObjs) {
            Long supplierId = quoteDyObj.getLong("supplier");
            Long currId = quoteDyObj.getLong("curr");
            BigDecimal taxPrice = quoteDyObj.getBigDecimal("materialentry.taxprice");
            BigDecimal taxAmount = quoteDyObj.getBigDecimal("materialentry.taxamount");
            BigDecimal qty = quoteDyObj.getBigDecimal("materialentry.qty");
            Long unitId = quoteDyObj.getLong("materialentry.unit");
            String result = quoteDyObj.getString("materialentry.result");
            HashMap<String, Object> customParam = new HashMap<String, Object>();
            customParam.put("supplier", supplierId);
            customParam.put("curr", currId);
            customParam.put("taxprice", taxPrice);
            customParam.put("taxamount", taxAmount);
            customParam.put("qty", qty);
            customParam.put("unit", unitId);
            customParam.put("result", result);
            quoteBillParams.add(customParam);
        }
        if (quoteBillParams.size() == 0) {
            return null;
        }
        return quoteBillParams;
    }

    public static Map<String, List<Map<String, Object>>> buildQuoCustomParams(String inquiryNo, Set<String> inqryEntryIds) {
        DynamicObjectCollection quoteDyObjs = PurInquiryOpHelper.queryRelatedQuteBills(inquiryNo, inqryEntryIds);
        int quoteDataSize = quoteDyObjs.size();
        if (quoteDataSize == 0) {
            return null;
        }
        HashMap<String, List<Map<String, Object>>> entryIdToQuoParams = new HashMap<String, List<Map<String, Object>>>(16);
        for (DynamicObject quoteDyObj : quoteDyObjs) {
            Long quoBillId = quoteDyObj.getLong("id");
            Long supplierId = quoteDyObj.getLong("supplier");
            Long currId = quoteDyObj.getLong("curr");
            Long quoEntryId = quoteDyObj.getLong("materialentry.id");
            String inqryEntryId = quoteDyObj.getString("materialentry.srcentryid");
            Long material = quoteDyObj.getLong("materialentry.material");
            String materialDesc = quoteDyObj.getString("materialentry.materialdesc");
            BigDecimal taxPrice = quoteDyObj.getBigDecimal("materialentry.taxprice");
            BigDecimal amount = quoteDyObj.getBigDecimal("materialentry.amount");
            BigDecimal tax = quoteDyObj.getBigDecimal("materialentry.tax");
            BigDecimal taxAmount = quoteDyObj.getBigDecimal("materialentry.taxamount");
            Long taxRateId = quoteDyObj.getLong("materialentry.taxrateid");
            BigDecimal taxRate = quoteDyObj.getBigDecimal("materialentry.taxrate");
            BigDecimal inquiryQty = quoteDyObj.getBigDecimal("materialentry.inquiryqty");
            BigDecimal qty = quoteDyObj.getBigDecimal("materialentry.qty");
            Long unitId = quoteDyObj.getLong("materialentry.unit");
            String result = quoteDyObj.getString("materialentry.result");
            BigDecimal cfmQty = quoteDyObj.getBigDecimal("materialentry.cfmqty");
            BigDecimal basicQty = quoteDyObj.getBigDecimal("materialentry.basicqty");
            BigDecimal price = quoteDyObj.getBigDecimal("materialentry.price");
            BigDecimal cfmPrice = quoteDyObj.getBigDecimal("materialentry.cfmprice");
            BigDecimal cfmTaxPrice = quoteDyObj.getBigDecimal("materialentry.cfmtaxprice");
            BigDecimal cfmTaxRate = quoteDyObj.getBigDecimal("materialentry.cfmtaxrate");
            Long cfmTaxRateId = quoteDyObj.getLong("materialentry.cfmtaxrateid");
            String note = quoteDyObj.getString("materialentry.note");
            BigDecimal minOrderQty = quoteDyObj.getBigDecimal("materialentry.minorderqty");
            int purLeadDay = quoteDyObj.getInt("materialentry.purleadday");
            String prEntryId = quoteDyObj.getString("materialentry.prentryid");
            String prBillId = quoteDyObj.getString("materialentry.prbillid");
            Long basicUnitId = quoteDyObj.getLong("materialentry.basicunit");
            Long rcvOrgId = quoteDyObj.getLong("materialentry.entryrcvorg");
            if (!entryIdToQuoParams.containsKey(inqryEntryId)) {
                entryIdToQuoParams.put(inqryEntryId, new ArrayList(10));
            }
            List quoParams = (List)entryIdToQuoParams.get(inqryEntryId);
            HashMap<String, Object> customParam = new HashMap<String, Object>(16);
            customParam.put("billid", quoBillId);
            customParam.put("supplier", supplierId);
            customParam.put("curr", currId);
            customParam.put("taxprice", taxPrice);
            customParam.put("amount", amount);
            customParam.put("tax", tax);
            customParam.put("taxamount", taxAmount);
            customParam.put("inquiryqty", inquiryQty);
            customParam.put("qty", qty);
            customParam.put("unit", unitId);
            customParam.put("result", result);
            customParam.put("entryid", quoEntryId);
            customParam.put("material", material);
            customParam.put("materialdesc", materialDesc);
            customParam.put("cfmqty", PurInquiryOpHelper.getCfmQtyOrPriceValue(qty, cfmQty));
            customParam.put("basicqty", basicQty);
            customParam.put("cfmprice", PurInquiryOpHelper.getCfmQtyOrPriceValue(price, cfmPrice));
            customParam.put("cfmtaxprice", PurInquiryOpHelper.getCfmQtyOrPriceValue(taxPrice, cfmTaxPrice));
            customParam.put("cfmtaxrate", PurInquiryOpHelper.getCfmQtyOrPriceValue(taxRate, cfmTaxRate));
            customParam.put("cfmtaxrateid", cfmTaxRateId == null || cfmTaxRateId.equals(0L) ? taxRateId : cfmTaxRateId);
            customParam.put("note", note);
            customParam.put("minorderqty", minOrderQty);
            customParam.put("purleadday", purLeadDay);
            customParam.put("prentryid", prEntryId);
            customParam.put("prbillid", prBillId);
            customParam.put("basicunit", basicUnitId);
            customParam.put("entryrcvorg", rcvOrgId);
            customParam.put("isadopt", "2");
            quoParams.add(customParam);
        }
        if (entryIdToQuoParams.size() == 0) {
            return null;
        }
        return entryIdToQuoParams;
    }

    private static BigDecimal getCfmQtyOrPriceValue(BigDecimal qtyOrPrice, BigDecimal cfmQtyOrPrice) {
        return cfmQtyOrPrice == null || BigDecimal.ZERO.compareTo(cfmQtyOrPrice) == 0 ? qtyOrPrice : cfmQtyOrPrice;
    }

    public static DynamicObjectCollection queryRelatedQuteBill(String inquiryNo, String turns, String inqryEntryId) {
        QFilter filter = new QFilter("inquiryno", "=", (Object)inquiryNo);
        filter.and("turns", "=", (Object)turns);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("materialentry.entrystatus", "=", (Object)"A");
        filter.and("materialentry.srcentryid", "=", (Object)inqryEntryId);
        return QueryServiceHelper.query((String)"sou_quote", (String)"supplier,curr,materialentry.material,materialentry.unit,materialentry.qty,materialentry.taxprice,materialentry.taxamount,materialentry.result", (QFilter[])filter.toArray(), null, (int)1000);
    }

    public static DynamicObjectCollection queryRelatedQuteBills(String inquiryNo, Set<String> inqryEntryIds) {
        QFilter filter = new QFilter("inquiryno", "=", (Object)inquiryNo);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("materialentry.entrystatus", "=", (Object)"A");
        filter.and("materialentry.srcentryid", "in", inqryEntryIds);
        filter.and("materialentry.taxprice", ">", (Object)BigDecimal.ZERO);
        return QueryServiceHelper.query((String)"sou_quote", (String)"id,supplier,curr,materialentry.material,materialentry.materialdesc,materialentry.unit,materialentry.inquiryqty,materialentry.qty,materialentry.taxprice,materialentry.amount,materialentry.tax,materialentry.taxamount,materialentry.result,materialentry.cfmqty,materialentry.basicqty,materialentry.price,materialentry.cfmprice,materialentry.cfmtaxprice,materialentry.taxrate,materialentry.cfmtaxrate,materialentry.taxrateid,materialentry.cfmtaxrateid,materialentry.note,materialentry.minorderqty,materialentry.purleadday,materialentry.id,materialentry.srcentryid,materialentry.prentryid,materialentry.prbillid,materialentry.basicunit,materialentry.entryrcvorg,materialentry.entryreqorg", (QFilter[])filter.toArray(), null, (int)1000);
    }

    private static void openPage(IFormPlugin plugin, IDataModel model, IFormView view, String formId, String actionId, ShowType showType) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("inquiryBillId", model.getDataEntity().getPkValue());
        paramMap.put("inquiryno", model.getValue("billno"));
        view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)formId, paramMap, (CloseCallBack)new CloseCallBack(plugin, actionId), (ShowType)showType));
    }

    public static void alertdate(IFormPlugin plugin, IDataModel model, IFormView view, String formId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Object id = model.getValue("id");
        DynamicObject inquiryObj = PurInquiryOpHelper.getInquiryBill(id);
        if (null == inquiryObj) {
            return;
        }
        String bizStatusPage = (String)model.getValue("bizstatus");
        String bizStatus = inquiryObj.getString("bizstatus");
        if (bizStatus != null && !bizStatus.equals(bizStatusPage) || bizStatus == null && bizStatusPage != null) {
            view.showMessage(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u66f4\u65b0\uff0c\u8bf7\u5148\u5237\u65b0\u6570\u636e\u3002", (String)"PurInquiryOpHelper_5", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return;
        }
        if (null != bizStatus && !BizStatusEnum.ENROLMENT.getVal().equals(bizStatus)) {
            view.showMessage(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u9879\u76ee\u72b6\u6001\u4e3a\u62a5\u4ef7\u4e2d\u7684\u624d\u80fd\u53d8\u66f4\u65f6\u95f4\u3002", (String)"PurInquiryOpHelper_4", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return;
        }
        if (null != bizStatus && BizStatusEnum.OPENEDTHEBID.getVal().equals(bizStatus)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u5df2\u5f00\u6807\uff0c\u4e0d\u80fd\u53d8\u66f4\u65f6\u95f4\u3002", (String)"PurInquiryOpHelper_2", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return;
        }
        String openTypeObj = inquiryObj.getString("opentype");
        int supQuoNumObj = inquiryObj.getInt("supquonum");
        if (supQuoNumObj > 0 && ("1".equals(openTypeObj) || "2".equals(openTypeObj)) && inquiryObj.getDate("enddate").getTime() <= TimeServiceHelper.now().getTime()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u6b63\u5728\u6267\u884c\u5f00\u6807\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u3002", (String)"PurInquiryOpHelper_3", (String)"scm-pur-mobile", (Object[])new Object[0]));
            return;
        }
        paramMap.put("billid", inquiryObj.getPkValue());
        paramMap.put("enddate", inquiryObj.getDate("enddate"));
        view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)formId, paramMap, (CloseCallBack)new CloseCallBack(plugin, "alertDateAction"), (ShowType)ShowType.Modal));
    }

    public static void refresh(IFormView view) {
        view.invokeOperation("refresh");
    }

    public static DynamicObject getInquiryBill(Object id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"sou_inquiry");
    }
}

