/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;

public class ListUtils {
    public static <E> Collection<E> union(Collection<E> one, Collection<E> other) {
        ArrayList<E> unionSet = new ArrayList<E>(one);
        if (one == null || one.size() == 0) {
            return other;
        }
        if (other == null || other.size() == 0) {
            return one;
        }
        for (E e : other) {
            if (unionSet.contains(e)) continue;
            unionSet.add(e);
        }
        return unionSet;
    }

    public static <E> List<E> intersect(Collection<E> one, Collection<E> other) {
        ArrayList<E> intersectSet = new ArrayList<E>(10);
        if (one == null || one.size() == 0) {
            return intersectSet;
        }
        if (other == null || other.size() == 0) {
            return intersectSet;
        }
        for (E e : one) {
            if (!other.contains(e)) continue;
            intersectSet.add(e);
        }
        return intersectSet;
    }

    public static <T> String listToString(List<T> list) {
        return ListUtils.listToString(list, "");
    }

    public static <T> String listToString(List<T> list, String suffix) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder strBuilder = new StringBuilder();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T t = list.get(i);
            strBuilder.append(t);
            if (StringUtils.isNotEmpty((CharSequence)suffix)) {
                strBuilder.append(suffix);
            }
            if (i >= size - 1) continue;
            strBuilder.append(",");
        }
        return strBuilder.toString();
    }

    public static List<Long> stringToLongList(List<String> list) {
        ArrayList<Long> toList = new ArrayList<Long>(10);
        if (list == null || list.size() == 0) {
            return toList;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String str = list.get(i);
            if (StringUtils.isEmpty((CharSequence)str)) {
                toList.add(0L);
                continue;
            }
            toList.add(Long.valueOf(str));
        }
        return toList;
    }
}

