/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.mobile;

import java.util.EventObject;
import java.util.List;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.util.OrgUtil;
import kd.scm.pur.formplugin.mobile.CoreMobileBillList;

public class PurMobileSaloutstockList
extends CoreMobileBillList
implements TabSelectListener,
SetFilterListener {
    private final List<Long> allInvPermssionOrgs = OrgUtil.getAllInvViewPermissionOrgs((String)"pur_saloutstock");

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{"bar_pushall"});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                evt.setCancel(true);
                PurMobileSaloutstockList.this.openBatchReceive(evt.getCurrentListSelectedRow().getPrimaryKeyValue());
            }
        });
        billList.addSetFilterListener((SetFilterListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey;
        switch (tabKey = tabSelectEvent.getTabKey()) {
            case "noreceipt": {
                this.getPageCache().put("activeTab", tabKey);
                break;
            }
            case "nostorage": {
                this.getPageCache().put("activeTab", tabKey);
                break;
            }
            case "all": {
                this.getPageCache().put("activeTab", tabKey);
            }
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
        this.initInfoVisible(billList);
    }

    private void openBatchReceive(Object pkId) {
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setAppId("eae607fb000143ac");
        mobileFormShowParameter.setFormId("pur_batreceive_m");
        mobileFormShowParameter.setCustomParam("pkId", pkId);
        mobileFormShowParameter.setCustomParam("fromType", (Object)"list");
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Button button = (Button)evt.getSource();
        BillList billList = (BillList)this.getControl("billlistap");
        switch (key = button.getKey()) {
            case "bar_pushall": {
                this.openBatchReceive(billList.getCurrentSelectedRowInfo().getPrimaryKeyValue());
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        String activeTab = (String)this.getView().getFormShowParameter().getCustomParam("activeTab");
        if (activeTab == null || activeTab.length() == 0) {
            activeTab = "all";
        }
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab(activeTab);
        this.getPageCache().put("activeTab", activeTab);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
        this.initInfoVisible(billList);
        this.initBatchVisible(billList);
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("org", "in", this.allInvPermssionOrgs));
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        QFilter qFilter = this.getQFilter();
        if (qFilter != null) {
            qFilters.add(qFilter);
        }
    }

    public QFilter getQFilter() {
        String activeTab = this.getPageCache().get("activeTab");
        QFilter qFilter = null;
        switch (activeTab) {
            case "noreceipt": {
                qFilter = new QFilter("logstatus", "=", (Object)LogisticsStatusEnum.ALLOUTSTOCK.getVal()).or(new QFilter("logstatus", "=", (Object)" ")).or("logstatus", "=", (Object)LogisticsStatusEnum.PARTRECIPT.getVal());
                QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.CLOSED.getVal());
                qFilter.and(billStatusFilter);
                break;
            }
            case "nostorage": {
                qFilter = new QFilter("logstatus", "=", (Object)LogisticsStatusEnum.PARTRECIPT.getVal());
                break;
            }
        }
        return qFilter;
    }
}

