/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.mobile.compare;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pur.common.utils.MobileControlUtils;

public class PurCompareMobEdit
extends AbstractMobBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"queryquotebtn"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPlayer();
        this.initPriceCurrSign();
    }

    private void setPlayer() {
        String player;
        String quoBillNo;
        CardEntry cardEntry = (CardEntry)this.getControl("quoentry");
        DynamicObject[] quoteEntry = cardEntry.getEntryData().getDataEntitys();
        ArrayList<String> quoBillNos = new ArrayList<String>(10);
        for (DynamicObject entry : quoteEntry) {
            String quoBillNo2 = entry.getString("quobillno");
            quoBillNos.add(quoBillNo2);
        }
        HashMap<String, String> quoBillNoToPlayer = new HashMap<String, String>(16);
        QFilter qFilter = new QFilter("billno", "in", quoBillNos);
        DynamicObjectCollection quotes = QueryServiceHelper.query((String)"sou_quote", (String)"billno,contacter.name as player", (QFilter[])qFilter.toArray());
        if (quotes == null || quotes.size() == 0) {
            return;
        }
        for (DynamicObject quote : quotes) {
            quoBillNo = quote.getString("billno");
            player = quote.getString("player");
            quoBillNoToPlayer.put(quoBillNo, player);
        }
        for (int i = 0; i < quoteEntry.length; ++i) {
            DynamicObject entry = quoteEntry[i];
            quoBillNo = entry.getString("quobillno");
            player = (String)quoBillNoToPlayer.get(quoBillNo);
            if (StringUtils.isEmpty((CharSequence)player)) continue;
            MobileControlUtils.setCardEntryRowProperty(cardEntry, i, "text", player, "player");
        }
    }

    private void initPriceCurrSign() {
        IDataModel model = this.getModel();
        CardEntry cardEntry = (CardEntry)this.getControl("materialentry");
        DynamicObject curr = (DynamicObject)model.getValue("curr");
        String currSign = curr == null ? "" : curr.getString("sign");
        int rows = cardEntry.getEntryData().getDataEntitys().length;
        for (int i = 0; i < rows; ++i) {
            BigDecimal taxPrice = (BigDecimal)model.getValue("taxprice", i);
            BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", i);
            if (taxPrice != null && BigDecimal.ZERO.compareTo(taxPrice) != 0) {
                MobileControlUtils.setCardEntryRowProperty(cardEntry, i, "text", currSign, "taxpricecurrsign");
            }
            if (taxAmount == null || BigDecimal.ZERO.compareTo(taxAmount) == 0) continue;
            MobileControlUtils.setCardEntryRowProperty(cardEntry, i, "text", currSign, "taxamtcurrsign");
        }
    }

    public void click(EventObject e) {
        String opKey;
        super.click(e);
        Control control = (Control)e.getSource();
        switch (opKey = control.getKey()) {
            case "queryquotebtn": {
                this.openQuoteBillPage();
                break;
            }
        }
    }

    private void openQuoteBillPage() {
        MobileBillShowParameter showParameter = new MobileBillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setFormId("pur_quote_m_list");
        String quoBillNo = (String)this.getModel().getValue("quobillno");
        QFilter qFilter = new QFilter("billno", "=", (Object)quoBillNo);
        DynamicObject inquiryObj = BusinessDataServiceHelper.loadSingleFromCache((String)"sou_quote", (QFilter[])qFilter.toArray());
        showParameter.setPkId(inquiryObj.getPkValue());
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

