/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.mobile.quote;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pur.common.utils.MobileControlUtils;

public class PurQuoteMobEdit
extends AbstractMobBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"inquirybillnoflex"});
    }

    public void click(EventObject e) {
        String opKey;
        super.click(e);
        Control source = (Control)e.getSource();
        switch (opKey = source.getKey()) {
            case "inquirybillnoflex": {
                this.openInquiryBillPage();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initPriceCurrSign();
    }

    private void initPriceCurrSign() {
        IDataModel model = this.getModel();
        CardEntry cardEntry = (CardEntry)this.getControl("materialentry");
        DynamicObject curr = (DynamicObject)model.getValue("curr");
        String currSign = curr == null ? "" : curr.getString("sign");
        int rows = cardEntry.getEntryData().getDataEntitys().length;
        for (int i = 0; i < rows; ++i) {
            BigDecimal taxPrice = (BigDecimal)model.getValue("taxprice", i);
            BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", i);
            if (taxPrice != null && BigDecimal.ZERO.compareTo(taxPrice) != 0) {
                MobileControlUtils.setCardEntryRowProperty(cardEntry, i, "text", currSign, "taxpricecsgn");
            }
            if (taxAmount == null || BigDecimal.ZERO.compareTo(taxAmount) == 0) continue;
            MobileControlUtils.setCardEntryRowProperty(cardEntry, i, "text", currSign, "taxamtcsgn");
        }
    }

    private void openInquiryBillPage() {
        MobileBillShowParameter showParameter = new MobileBillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setFormId("pur_inquiry_m_list");
        String inquiryNo = (String)this.getModel().getValue("inquiryno");
        QFilter qFilter = new QFilter("billno", "=", (Object)inquiryNo);
        DynamicObject inquiryObj = BusinessDataServiceHelper.loadSingleFromCache((String)"sou_inquiry", (QFilter[])qFilter.toArray());
        showParameter.setPkId(inquiryObj.getPkValue());
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

