/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.report.deliveryrate.trans;

import java.util.List;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.scm.common.algox.SupplierDeliverQtyMapFunc;
import kd.scm.pur.report.util.RptParam;

public class PurDeliverQtyTransform
implements IDataXTransform {
    private ReportDataCtx ctx;
    private RptParam reportParam;
    private static final String[] GROUP_COLS = new String[]{"org", "supplier", "material", "materialnametext", "materialmodel", "orderqty", "poentryid"};

    public PurDeliverQtyTransform(ReportDataCtx ctx, RptParam reportParam) {
        this.ctx = ctx;
        this.reportParam = reportParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        List<Long> matIds;
        QFilter qFilter = new QFilter("org", "in", this.reportParam.getOrgs());
        List<Long> spIds = this.reportParam.getSpIds();
        if (spIds != null && !spIds.isEmpty()) {
            qFilter.and(new QFilter("supplier", "in", spIds));
        }
        if ((matIds = this.reportParam.getMatIds()) != null && !matIds.isEmpty()) {
            qFilter.and(new QFilter("materialentry.material", "in", matIds));
        }
        if ("pur_receipt".equals(this.reportParam.getEntitytype())) {
            qFilter.and(new QFilter("isreturn", "=", (Object)Boolean.FALSE));
        }
        String selectFields = "billdate,materialentry.poentryid poentryid_right,materialentry.basicqty basicqty";
        OrmInput input = new OrmInput("PurDeliverTransform", this.reportParam.getEntitytype(), selectFields, qFilter.toArray());
        String joinRightField = "poentryid_right";
        DataSetX subData = this.ctx.getCurrentJob().fromInput((Input)input);
        srcData = srcData.leftJoin(subData).on("poentryid", joinRightField).removeFields(new String[]{joinRightField});
        srcData = srcData.groupBy(GROUP_COLS).reduceGroup((GroupReduceFunction)new SupplierDeliverQtyMapFunc(srcData.getRowMeta()));
        return srcData;
    }
}

