/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.ArrayList;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.MalOrderWriteBackUtil;
import kd.scm.common.util.ScmcUtil;
import kd.scm.pur.business.PurInStockHelper;
import kd.scm.pur.business.PurJointChannelHelper;
import kd.scm.pur.opplugin.util.PurReturnUtil;

public class PurInstockAuditOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PurInstockAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("basicqty");
        e.getFieldKeys().add("poentryid");
        e.getFieldKeys().add("pobillid");
        e.getFieldKeys().add("srcentryid");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("businesstype");
        e.getFieldKeys().add("businessdirect");
        e.getFieldKeys().add("replenishtype");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dyns = e.getDataEntities();
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        OperationServiceHelper.executeOperate((String)"sendmsgtosup", (String)"pur_instock", (DynamicObject[])dyns, (OperateOption)option);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dyns = e.getDataEntities();
        if (PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])dyns, (String)"self")) {
            DynamicObject[] returnDyArray;
            ArrayList<DynamicObject> normalDys = new ArrayList<DynamicObject>(8);
            ArrayList<DynamicObject> returnDys = new ArrayList<DynamicObject>(8);
            for (DynamicObject dy : dyns) {
                String businessdirect = dy.getString("businessdirect");
                if ("return".equals(businessdirect)) {
                    returnDys.add(dy);
                    continue;
                }
                normalDys.add(dy);
            }
            log.info("###\u6267\u884c\u53cd\u5199!");
            DynamicObject[] normalDyArray = normalDys.toArray(new DynamicObject[0]);
            if (normalDyArray != null && normalDyArray.length > 0) {
                PurInStockHelper.updateAutoConfirmStatus((DynamicObject[])normalDyArray);
                ScmcUtil.writeBackData((DynamicObject[])normalDyArray, (String)"audit");
                MalOrderWriteBackUtil.writeBackMalOrder((DynamicObject[])normalDyArray);
            }
            if ((returnDyArray = returnDys.toArray(new DynamicObject[0])) != null && returnDyArray.length > 0) {
                PurReturnUtil.writeBackRefundApplyConfirmStatus(returnDyArray, "F");
                PurReturnUtil.writeBackPoSumReturnQty(returnDyArray, true);
            }
        }
    }
}

