/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.scm.common.invcloud.InvoiceCloudHelper;
import kd.scm.common.invcloud.bean.ValidateInvocieRespParam;
import kd.scm.common.invcloud.enums.InvCheckStatusEnum;
import kd.scm.common.invcloud.enums.InvSourceEnum;

public class PurInvoiceCloudConfirmOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PurInvoiceCloudConfirmOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("entryentity.invcode");
        e.getFieldKeys().add("entryentity.invno");
        e.getFieldKeys().add("entryentity.invserialnum");
        e.getFieldKeys().add("entryentity.invsource");
        e.getFieldKeys().add("entryentity.invcheckstatus");
        e.getFieldKeys().add("entryentity.invid");
        e.getFieldKeys().add("entryentity.invdate");
        e.getFieldKeys().add("entryentity.invoiceamount");
        e.getFieldKeys().add("entryentity.invamount");
        e.getFieldKeys().add("entryentity.invtax");
        e.getFieldKeys().add("entryentity.reccompany");
        e.getFieldKeys().add("entryentity.invcompany");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] invoices = e.getDataEntities();
        StringBuilder sb = new StringBuilder();
        for (DynamicObject invoiceObject : invoices) {
            DynamicObject org = invoiceObject.getDynamicObject("org");
            if (!InvoiceCloudHelper.hasInvCloudConfig((DynamicObject)org)) continue;
            sb = this.validInvioceAndUpdateCheckStatus(invoiceObject);
        }
        if (!StringUtils.isEmpty((Object)sb.toString())) {
            e.setCancel(true);
            e.setCancelMessage(sb.toString());
        }
    }

    private StringBuilder validInvioceAndUpdateCheckStatus(DynamicObject invoiceObject) {
        StringBuilder sb = new StringBuilder();
        String billno = invoiceObject.getString("billno");
        DynamicObjectCollection entryentityCol = invoiceObject.getDynamicObjectCollection(this.getEntryentitykey());
        ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>(8);
        for (DynamicObject dynamicObject : entryentityCol) {
            String invcheckstatus = dynamicObject.getString("invcheckstatus");
            String invsource = dynamicObject.getString("invsource");
            if (InvCheckStatusEnum.PASS.getVal().equals(invcheckstatus) || !InvSourceEnum.INVOICECLOUD.getVal().equals(invsource)) continue;
            invoiceList.add(dynamicObject);
        }
        List validateInvoices = InvoiceCloudHelper.check((DynamicObject)invoiceObject, invoiceList);
        if (CollectionUtils.isEmpty((Collection)validateInvoices)) {
            return sb;
        }
        for (ValidateInvocieRespParam validateInvoice : validateInvoices) {
            if (!validateInvoice.isPass()) {
                sb.append(ResManager.loadKDString((String)MessageFormat.format("\u5355\u636e\u7f16\u53f7\u4e3a{0}\u7684\u53d1\u7968\u660e\u7ec6\u67e5\u9a8c\u4e0d\u901a\u8fc7\u3002\u53d1\u7968\u4ee3\u7801\uff1a{1},\u5931\u8d25\u539f\u56e0\uff1a{2}\u3002", billno, validateInvoice.getInvoiceNo(), validateInvoice.getMsg()), (String)"PurInvoiceCloudConfirmOp_1", (String)"scm-scp-formplugin", (Object[])new Object[0]));
                sb.append(System.lineSeparator());
                continue;
            }
            for (DynamicObject dynamicObject : entryentityCol) {
                String invno = dynamicObject.getString("invno");
                if (invno == null || !invno.equals(validateInvoice.getInvoiceNo())) continue;
                dynamicObject.set("invcheckstatus", (Object)InvCheckStatusEnum.PASS.getVal());
                if (!StringUtils.isEmpty((Object)validateInvoice.getSerialNo())) {
                    dynamicObject.set("invserialnum", (Object)validateInvoice.getSerialNo());
                }
                if (validateInvoice.getTotalAmount() != null) {
                    dynamicObject.set("invamount", (Object)validateInvoice.getTotalAmount());
                }
                if (validateInvoice.getInvoiceCode() != null) {
                    dynamicObject.set("invcode", (Object)validateInvoice.getInvoiceCode());
                }
                if (validateInvoice.getInvoiceNo() != null) {
                    dynamicObject.set("invno", (Object)validateInvoice.getInvoiceNo());
                }
                if (validateInvoice.getCheckCode() != null) {
                    dynamicObject.set("invid", (Object)validateInvoice.getCheckCode());
                }
                if (validateInvoice.getInvoiceAmount() != null) {
                    dynamicObject.set("invoiceamount", (Object)validateInvoice.getInvoiceAmount());
                }
                if (validateInvoice.getTotalTaxAmount() != null) {
                    dynamicObject.set("invtax", (Object)validateInvoice.getTotalTaxAmount());
                }
                if (validateInvoice.getBuyerName() != null) {
                    dynamicObject.set("reccompany", (Object)validateInvoice.getBuyerName());
                }
                if (validateInvoice.getSalerName() == null) continue;
                dynamicObject.set("invcompany", (Object)validateInvoice.getSalerName());
            }
        }
        return sb;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] invoices;
        for (DynamicObject invoiceObject : invoices = e.getDataEntities()) {
            this.signInvoice(invoiceObject);
        }
    }

    private void signInvoice(DynamicObject invoiceObject) {
        DynamicObjectCollection entryEntityCol = invoiceObject.getDynamicObjectCollection(this.getEntryentitykey());
        ArrayList<String> serialNos = new ArrayList<String>();
        for (DynamicObject dynamicObject : entryEntityCol) {
            String invCheckStatus = dynamicObject.getString("invcheckstatus");
            String invSource = dynamicObject.getString("invsource");
            if (!InvCheckStatusEnum.PASS.getVal().equals(invCheckStatus) || !InvSourceEnum.INVOICECLOUD.getVal().equals(invSource)) continue;
            String invSerialNum = dynamicObject.getString("invserialnum");
            serialNos.add(invSerialNum);
        }
        if (serialNos.size() > 0) {
            InvoiceCloudHelper.signInvoice((DynamicObject)invoiceObject, serialNos);
        }
    }

    private String getEntryentitykey() {
        return "entryentity";
    }
}

