/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.pur.business.PurEasInvoiceSendHelper;
import kd.scm.pur.opplugin.util.PurEasInvoiceConfirmInvoiceOpUtil;
import kd.scm.pur.opplugin.util.UpdateTagUtil;

public class PurInvoiceConfirmOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PurInvoiceConfirmOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("cfmstatus");
        e.getFieldKeys().add("ispay");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("entryentity.invcode");
        e.getFieldKeys().add("entryentity.invno");
        e.getFieldKeys().add("entryentity1.pobillid1");
        e.getFieldKeys().add("entryentity1.poentryid1");
        e.getFieldKeys().add("entryentity1.pobillno1");
        e.getFieldKeys().add("entryentity1.srcentryid1");
        e.getFieldKeys().add("materialentry.ischeckorinvoice");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] invoices = e.getDataEntities();
        if (ApiConfigUtil.getEasConfig() != null) {
            boolean status = PurEasInvoiceSendHelper.getParamStatus((DynamicObject[])invoices);
            if (!status) {
                return;
            }
            PurEasInvoiceConfirmInvoiceOpUtil.checkEasInvioces(e, invoices, "receive", "B", "2");
        }
        if (!e.isCancel()) {
            PurEasInvoiceConfirmInvoiceOpUtil.setCfmStatus("B", "2", invoices);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] Objs = e.getDataEntities();
        UpdateTagUtil.updateTag(Objs, (boolean)Boolean.TRUE);
    }
}

