/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.jd.JDAccessTokenUtil;
import kd.scm.common.ecapi.jd.JdApiUtil;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.enums.PurOrderSrcTypeEnum;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.ScMultiDataHandleServiceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BussinessTypeUtils;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JDOrderUtil;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.MessageSendUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.pur.business.PurOrderBillHelper;
import kd.scm.pur.opplugin.validator.PurOrderValidator;

public class PurOrderAuditOp
extends AbstractOperationServicePlugIn {
    private static final String PUR_ENTRYENTITY = "materialentry";
    private static Log log = LogFactory.getLog(PurOrderAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        log.info("@@@kd.scm.pur.opplugin.PurOrderAuditOp.onPreparePropertys");
        List filds = e.getFieldKeys();
        filds.add("materialentry.pobillid");
        filds.add("materialentry.pobillno");
        filds.add("materialentry.poentryid");
        filds.add("materialentry.entrystatus");
        filds.add("rowlogstatus");
        filds.add("materialentry.goods");
        filds.add("materialentry.jdorder");
        filds.add("cfmstatus");
        filds.add("jdorderid");
        filds.add("sumtaxamount");
        filds.add("srctype");
        filds.add("bizpartner");
        filds.add("logstatus");
        filds.add("settleorg");
        filds.add("org");
        filds.add("businesstype");
        filds.add("materialentry.mftorderentryid");
        e.getFieldKeys().add("jointdatachannelid");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        log.info("@@@kd.scm.pur.opplugin.PurOrderAuditOp.beforeExecuteOperationTransaction\u5f00\u59cb\u6267\u884c");
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
            List Objs = e.getValidExtDataEntities();
            log.info("@@@kd.scm.pur.opplugin.PurOrderAuditOp.beforeExecuteOperationTransaction\u5ba1\u6838\u5f00\u59cb\u6267\u884c");
            Map numberJdOrderIdMap = new HashMap();
            for (ExtendedDataEntity obj : Objs) {
                DynamicObject bill = obj.getDataEntity();
                bill.set("cfmstatus", (Object)"A");
                bill.set("logstatus", (Object)"");
                DynamicObjectCollection maColl = bill.getDynamicObjectCollection(PUR_ENTRYENTITY);
                for (Object row : maColl) {
                    row.set("rowlogstatus", (Object)"");
                }
                String srctype = bill.getString("srctype");
                if (srctype.equals(PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_JD.getVal())) {
                    Object row;
                    bill.set("cfmstatus", (Object)"B");
                    bill.set("logstatus", (Object)"C");
                    row = maColl.iterator();
                    while (row.hasNext()) {
                        DynamicObject row2 = (DynamicObject)row.next();
                        row2.set("rowlogstatus", (Object)LogisticsStatusEnum.ALLOUTSTOCK.getVal());
                    }
                }
                String jdOrderId = bill.getString("jdorderid");
                String remittanceCode = "";
                if (bill.getString("srctype").equals(PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_JD.getVal()) && StringUtils.isNotBlank((CharSequence)jdOrderId) && "1".equals(MalOrderUtil.confirmOrder()) && !MalOrderParamUtil.getDefaultMalVersion() && !StringUtils.equalsIgnoreCase((CharSequence)MalOrderParamUtil.getBizFlowParam(), (CharSequence)"3")) {
                    Map childJdOrderIdMap;
                    DynamicObject jdOrder = JDOrderUtil.getJdOrder((String)jdOrderId);
                    if (null == jdOrder) {
                        throw new KDBizException(new ErrorCode("Submit JD Order fail", ResManager.loadKDString((String)"\u4eac\u4e1c\u8ba2\u5355\u786e\u8ba4\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PurOrderAuditOp_2", (String)"scm-pur-opplugin", (Object[])new Object[0])), new Object[0]);
                    }
                    String token = JDAccessTokenUtil.getAccessTokenByKD((String)RequestContext.get().getTenantId());
                    boolean flag = JDOrderUtil.confirmJDOrder((String)token, (String)jdOrderId);
                    if (flag) {
                        childJdOrderIdMap = JDOrderUtil.getJdChildOrderIdMap((String)token, (String)jdOrderId);
                        remittanceCode = JdApiUtil.selectRemittanceCode((int)2, (int)0, (String)jdOrderId, (int)0, (int)1, (String)"", (int)0, (BigDecimal)bill.getBigDecimal("sumtaxamount"));
                        if (childJdOrderIdMap != null) {
                            numberJdOrderIdMap = JDOrderUtil.getNumberJdOrderIdMap((Map)childJdOrderIdMap, (String)remittanceCode, (DynamicObject)jdOrder);
                        }
                    } else {
                        throw new KDBizException(new ErrorCode("Submit JD Order fail", ResManager.loadKDString((String)"\u4eac\u4e1c\u8ba2\u5355\u786e\u8ba4\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PurOrderAuditOp_2", (String)"scm-pur-opplugin", (Object[])new Object[0])), new Object[0]);
                    }
                    for (DynamicObject coll : maColl) {
                        if (childJdOrderIdMap == null || !bill.getString("srctype").equals(ProductSourceEnum.PRODUCTSOURCE_JD.getVal())) continue;
                        if (Boolean.parseBoolean((String)childJdOrderIdMap.get("isHasChildOrder"))) {
                            coll.set("jdorder", numberJdOrderIdMap.get(((DynamicObject)coll.get("goods")).get("number")));
                            continue;
                        }
                        coll.set("jdorder", numberJdOrderIdMap.get("jdorder"));
                    }
                }
                numberJdOrderIdMap.clear();
            }
        }
        log.info("@@@kd.scm.pur.opplugin.PurOrderAuditOp.beforeExecuteOperationTransaction\u7ed3\u675f\u6267\u884c");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        log.info("@@@kd.scm.pur.opplugin.PurOrderAuditOp.beginOperationTransaction\u5f00\u59cb\u6267\u884c");
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        if (!MalOrderParamUtil.getDefaultMalVersion() && "audit".equals(operationKey)) {
            for (DynamicObject bill : dataEntities) {
                Object billId = bill.getPkValue();
                String billNo = bill.getString("billno");
                DynamicObjectCollection maColl = bill.getDynamicObjectCollection(PUR_ENTRYENTITY);
                for (DynamicObject coll : maColl) {
                    if (coll != null && coll.getString("pobillid").trim().isEmpty()) {
                        coll.set("pobillid", billId);
                    }
                    if (coll != null && coll.getString("pobillno").trim().isEmpty()) {
                        coll.set("pobillno", (Object)billNo);
                    }
                    if (coll == null || !coll.getString("poentryid").trim().isEmpty()) continue;
                    coll.set("poentryid", coll.getPkValue());
                }
            }
            log.info("@@@kd.scm.pur.opplugin.PurOrderAuditOp.beginOperationTransaction\u7ed3\u675f\u6267\u884c");
        } else {
            new KDException(new ErrorCode("illegality use opplugin", ResManager.loadKDString((String)"\u975e\u6cd5\u4f7f\u7528\u63d2\u4ef6\uff0c\u8bf7\u6ce8\u610f\u3002", (String)"PurOrderAuditOp_1", (String)"scm-pur-opplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PurOrderValidator());
    }

    public void handleAfterSynOrder(Object result, DynamicObject[] objs) {
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dyns = e.getDataEntities();
        log.info("@@@kd.scm.pur.opplugin.PurOrderAuditOp.afterExecuteOperationTransaction\u8bbe\u7f6e\u72b6\u6001\uff0c\u53d1\u6d88\u606f\u5f00\u59cb\u6267\u884c");
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
            log.info("@@@kd.scm.pur.opplugin.PurOrderAuditOp.afterExecuteOperationTransaction\u8bbe\u7f6e\u72b6\u6001\uff0c\u53d1\u6d88\u606f\u5f00\u59cb\u6267\u884c");
            DynamicObject[] Objs = e.getDataEntities();
            ArrayList<Object> pks = new ArrayList<Object>(Objs.length);
            for (DynamicObject obj : Objs) {
                String srctype = obj.getString("srctype");
                if (srctype.equals(PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_JD.getVal()) || srctype.equals(PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_SELF.getVal())) {
                    pks.add(obj.get("id"));
                }
                if (!PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_ERP.getVal().equals(srctype) && !PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_SELF.getVal().equals(srctype)) continue;
                HashMap<String, String> extraMap = new HashMap<String, String>();
                extraMap.put("tplScene", "purorderconfirm");
                extraMap.put("configUrlForm", "scp_order_mob");
                extraMap.put("orgScopeType", "purorgscope");
                MessageSendUtil.send((DynamicObject)obj, extraMap);
            }
            log.info("@@@kd.scm.pur.opplugin.PurOrderAuditOp.afterExecuteOperationTransaction\u8bbe\u7f6e\u72b6\u6001\uff0c\u53d1\u6d88\u606f\u7ed3\u675f\u6267\u884c");
            log.info("@@@kd.scm.pur.opplugin.PurOrderAuditOp.afterExecuteOperationTransaction\u540c\u6b65EAS\u5f00\u59cb\u6267\u884c");
            if (!MalOrderParamUtil.getDefaultMalVersion() && !StringUtils.equalsIgnoreCase((CharSequence)MalOrderParamUtil.getBizFlowParam(), (CharSequence)"3") && ApiConfigUtil.hasEASConfig() && StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)MalOrderUtil.getGenerateErpBill()) && StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)MalOrderParamUtil.getBizFlowParam()) && pks.size() > 0) {
                try {
                    Map batchExtEntryPro = PurOrderBillHelper.assembleCreateOrderExtEntryPro();
                    Object result = OrderUtil.synCreateEasOrder(pks, (String)"pur_order", (Map)batchExtEntryPro);
                    this.handleAfterSynOrder(result, Objs);
                }
                catch (Exception exception) {
                    log.error("@@@kd.scm.pur.opplugin.PurOrderAuditOp.afterExecuteOperationTransaction(AfterOperationArgs)\u540c\u6b65\u51fa\u9519\uff0c\u51fa\u9519\u539f\u56e0\uff1a" + ExceptionUtil.getStackTrace((Throwable)exception));
                }
                SaveServiceHelper.update((DynamicObject[])Objs);
            }
            log.info("@@@kd.scm.pur.opplugin.PurOrderAuditOp.afterExecuteOperationTransaction\u540c\u6b65EAS\u7ed3\u675f\u6267\u884c");
            for (DynamicObject obj : Objs) {
                DynamicObject businesstype = obj.getDynamicObject("businesstype");
                if (businesstype == null || !BussinessTypeUtils.checkIsCpOmBussinessType((DynamicObject)businesstype)) continue;
                ArrayList objList = new ArrayList();
                objList.addAll(obj.getDynamicObjectCollection(PUR_ENTRYENTITY));
                HashMap<String, String> customParam = new HashMap<String, String>(1);
                customParam.put("keyField", "pobillid");
                customParam.put("billNoField", "pobillno");
                MultiDataHandleResult dataHandleResult = ScMultiDataHandleServiceHelper.executeManualSceneHandle((String)"manualautocreatemodulelist", objList, (String)"pobillid", (String)"jointdatachannelid", customParam);
                String messageJsonString = dataHandleResult.getMessage();
                if (StringUtils.isEmpty((CharSequence)messageJsonString)) continue;
                try {
                    Boolean isSuccess;
                    Map map = (Map)SerializationUtils.fromJsonString((String)messageJsonString, Map.class);
                    if (map == null || map.isEmpty() || (isSuccess = (Boolean)map.get("isSuccess")).booleanValue()) continue;
                    Object errorMsg = map.get("errorMsg");
                    new KDException(new ErrorCode("illegality use opplugin", String.valueOf(errorMsg)), new Object[0]);
                }
                catch (Exception e1) {
                    log.warn((Throwable)e1);
                }
            }
        } else {
            new KDException(new ErrorCode("illegality use opplugin", ResManager.loadKDString((String)"\u975e\u6cd5\u4f7f\u7528\u63d2\u4ef6\uff0c\u8bf7\u6ce8\u610f\u3002", (String)"PurOrderAuditOp_1", (String)"scm-pur-opplugin", (Object[])new Object[0])), new Object[0]);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        OperationServiceHelper.executeOperate((String)"sendmsgtosup", (String)"pur_order", (DynamicObject[])dyns, (OperateOption)option);
    }
}

