/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.isc.util.PurOrderChangeSaveUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pur.business.PurJointChannelHelper;
import kd.scm.pur.business.erp.IPurOrderQtyService;
import kd.scm.pur.business.erp.OrderQtyServiceFactory;

public class PurOrderChangeDefaultOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("*");
        e.getFieldKeys().add("materialentry.*");
        e.getFieldKeys().add("iscontrolqty");
        e.getFieldKeys().add("saloutratedown");
        e.getFieldKeys().add("saloutrateup");
        e.getFieldKeys().add("saloutqtydown");
        e.getFieldKeys().add("saloutbaseqtydown");
        e.getFieldKeys().add("saloutqtyup");
        e.getFieldKeys().add("saloutbaseqtyup");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        if (PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"eas") || PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"xkcloud")) {
            HashMap headDataMap = new HashMap((int)((double)dynamicObjects.length / 0.75));
            HashMap<String, Map> entryDataMap = new HashMap<String, Map>();
            DynamicObjectCollection entryCol = null;
            DynamicObject[] dynamicObjectArray = dynamicObjects;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject dyn = dynamicObjectArray[i];
                String number = dyn.getString("billno").toLowerCase();
                headDataMap.put(number, DynamicObjectUtil.plainObject2Map((DynamicObject)dyn));
                entryCol = dyn.getDynamicObjectCollection("materialentry");
                for (DynamicObject entry : entryCol) {
                    entryDataMap.put(number + "_" + entry.get("seq"), DynamicObjectUtil.plainObject2Map((DynamicObject)entry));
                }
            }
            PurOrderChangeSaveUtil helper = new PurOrderChangeSaveUtil();
            helper.beforeAddEntity(Arrays.asList(dynamicObjects), (Map)headDataMap, entryDataMap);
            helper.afterAddEntityTransaction(Arrays.asList(dynamicObjects), (Map)headDataMap, entryDataMap);
        }
        for (DynamicObject dyn : dynamicObjects) {
            dyn.set("modifier", (Object)dyn.getDynamicObject("creator"));
        }
        String jointSystemType = PurJointChannelHelper.getJointSystemType((DynamicObject[])dynamicObjects);
        IPurOrderQtyService qtyService = OrderQtyServiceFactory.getJointOrderQtyService((String)jointSystemType, (String)"pur_ordchange");
        for (DynamicObject dyn : dynamicObjects) {
            DynamicObjectCollection entryList = dyn.getDynamicObjectCollection("materialentry");
            if (entryList == null || entryList.isEmpty()) continue;
            qtyService.qtyCalculate(entryList);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        boolean easConfig = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"eas");
        boolean xkConfig = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"xkcloud");
        if (easConfig || xkConfig) {
            DynamicObject[] dyns = e.getDataEntities();
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            OperationServiceHelper.executeOperate((String)"sendmsgtosup", (String)"pur_ordchange", (DynamicObject[])dyns, (OperateOption)option);
        }
    }
}

