/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.PurOrderSrcTypeEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.pur.opplugin.validator.PurOrderUnAuditValidator;

public class PurOrderUnAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("srctype");
        e.getFieldKeys().add("cfm");
        e.getFieldKeys().add("cfmdate");
        e.getFieldKeys().add("cfmstatus");
        e.getFieldKeys().add("logstatus");
        e.getFieldKeys().add("paystatus");
        e.getFieldKeys().add("materialentry");
        e.getFieldKeys().add("materialentry.srcbillid");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] Objs;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject obj : Objs = e.getDataEntities()) {
            obj.set("cfmstatus", null);
            obj.set("cfm", null);
            obj.set("cfmdate", null);
            obj.set("logstatus", null);
            obj.set("paystatus", null);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PurOrderUnAuditValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey;
        switch (operationKey = e.getOperationKey()) {
            case "unaudit": {
                DynamicObject[] Objs = e.getDataEntities();
                HashSet<String> srcids = new HashSet<String>(56);
                HashSet<Long> billIds = new HashSet<Long>(56);
                HashSet<String> entryIdSet = new HashSet<String>(56);
                String bizFlowParam = MalOrderUtil.getBizFlowParam();
                for (DynamicObject obj : Objs) {
                    billIds.add(obj.getLong("id"));
                    DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("materialentry");
                    for (DynamicObject entryDyo : entryCol) {
                        boolean source;
                        entryIdSet.add(entryDyo.getString("id"));
                        if (!StringUtils.equalsIgnoreCase((CharSequence)bizFlowParam, (CharSequence)"3")) continue;
                        String srcType = obj.getString("srctype");
                        boolean bl = source = StringUtils.equals((CharSequence)PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_JD.getVal(), (CharSequence)srcType) || StringUtils.equals((CharSequence)PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_SELF.getVal(), (CharSequence)srcType);
                        if (!StringUtils.isNotBlank((CharSequence)entryDyo.getString("srcbillid")) || !source) continue;
                        srcids.add(entryDyo.getString("srcbillid"));
                    }
                }
                this.updateMalOrder(srcids);
                this.deleteSupOrderChange(entryIdSet);
                this.deleteDeliveryScheduleBill(billIds);
                break;
            }
        }
    }

    private void updateMalOrder(Set<String> srcids) {
        DynamicObject[] objs;
        if (srcids == null || srcids.size() == 0) {
            return;
        }
        String selectFields = "id,entryentity.id,entryentity.erpbillnumber,entryentity.erpbillstatus,entryentity.erplogstatus";
        QFilter filter = new QFilter("id", "in", srcids);
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)"mal_order", (String)selectFields, (QFilter[])new QFilter[]{filter})) {
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDyo : entryCol) {
                entryDyo.set("erpbillnumber", null);
                entryDyo.set("erpbillstatus", null);
                entryDyo.set("erplogstatus", null);
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])objs);
    }

    private void deleteSupOrderChange(Set<String> entryIdSet) {
        DeleteServiceHelper.delete((String)"pur_ordchange", (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", entryIdSet)});
    }

    private void deleteDeliveryScheduleBill(Set<Long> billIds) {
        List bfRowList = BFTrackerServiceHelper.loadTargetRowIds((String)"pur_order", (Long[])billIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        if (!bfRowList.isEmpty()) {
            HashSet<Long> targetIds = new HashSet<Long>(bfRowList.size());
            for (BFRow bfRow : bfRowList) {
                targetIds.add(bfRow.getId().getBillId());
            }
            if (!targetIds.isEmpty()) {
                OperationResult unsubmit;
                String errorTitle;
                HashSet<Long> saveIds = new HashSet<Long>(56);
                HashSet<Long> submitIds = new HashSet<Long>(56);
                HashSet<Long> auditIds = new HashSet<Long>(56);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pur_deliveryschedule", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", targetIds)}, (String)"id");){
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        Long id = row.getLong("id");
                        String billstatus = row.getString("billstatus");
                        if ("A".equalsIgnoreCase(billstatus)) {
                            saveIds.add(id);
                            continue;
                        }
                        if ("B".equalsIgnoreCase(billstatus)) {
                            submitIds.add(id);
                            continue;
                        }
                        if (!"C".equalsIgnoreCase(billstatus)) continue;
                        auditIds.add(id);
                    }
                }
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("isStrict", "false");
                operateOption.setVariableValue("ishasright", "true");
                if (!auditIds.isEmpty()) {
                    OperationResult unAudit = OperationServiceHelper.executeOperate((String)"unaudit", (String)"pur_deliveryschedule", (Object[])auditIds.toArray(), (OperateOption)operateOption.copy());
                    if (!unAudit.isSuccess() && unAudit.getSuccessPkIds().size() <= 0) {
                        errorTitle = unAudit.getMessage() + "\t\n" + ExceptionUtil.getErrorInfoDetails((List)unAudit.getAllErrorOrValidateInfo());
                        this.getOperationResult().setMessage(errorTitle);
                    } else {
                        saveIds.addAll(unAudit.getSuccessPkIds());
                    }
                }
                if (!submitIds.isEmpty()) {
                    unsubmit = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"pur_deliveryschedule", (Object[])submitIds.toArray(), (OperateOption)operateOption.copy());
                    if (!unsubmit.isSuccess() && unsubmit.getSuccessPkIds().size() <= 0) {
                        errorTitle = unsubmit.getMessage() + "\t\n" + ExceptionUtil.getErrorInfoDetails((List)unsubmit.getAllErrorOrValidateInfo());
                        this.getOperationResult().setMessage(errorTitle);
                    } else {
                        saveIds.addAll(unsubmit.getSuccessPkIds());
                    }
                }
                if (!saveIds.isEmpty() && !(unsubmit = OperationServiceHelper.executeOperate((String)"delete", (String)"pur_deliveryschedule", (Object[])saveIds.toArray(), (OperateOption)operateOption.copy())).isSuccess() && unsubmit.getSuccessPkIds().size() <= 0) {
                    errorTitle = unsubmit.getMessage() + "\t\n" + ExceptionUtil.getErrorInfoDetails((List)unsubmit.getAllErrorOrValidateInfo());
                    this.getOperationResult().setMessage(errorTitle);
                }
            }
        }
    }
}

