/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pur.opplugin.validator.PurOrderUrgeValidator;

public class PurOrderUrgeOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PurOrderUrgeValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String currUserId = RequestContext.get().getUserId();
        IAppCache cache = AppCache.get((String)"scm-pur");
        HashMap<String, HashMap<String, String>> userUrgeLimitMap = (HashMap<String, HashMap<String, String>>)cache.get("userUrgeLimit", HashMap.class);
        Date now = TimeServiceHelper.now();
        for (DynamicObject dynamicObject : dataEntities) {
            HashMap<String, String> urgeBillMap;
            String dynId = String.valueOf(dynamicObject.getPkValue());
            if (null == userUrgeLimitMap) {
                userUrgeLimitMap = new HashMap<String, HashMap<String, String>>(1024);
            }
            if (null == (urgeBillMap = (HashMap<String, String>)userUrgeLimitMap.get(currUserId))) {
                urgeBillMap = new HashMap<String, String>();
            }
            urgeBillMap.put(dynId, String.valueOf(now.getTime()));
            userUrgeLimitMap.put(currUserId, urgeBillMap);
        }
        cache.put("userUrgeLimit", (Object)userUrgeLimitMap);
    }
}

