/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.isc.util.PurPaySaveUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pur.business.PurJointChannelHelper;

public class PurPayDefaultOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("*");
        e.getFieldKeys().add("materialentry.*");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        boolean easConfig = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"eas");
        boolean xkScmConfig = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"xkcloud");
        if (easConfig || xkScmConfig) {
            DynamicObject[] dyns = e.getDataEntities();
            this.beforeOperation(dyns);
        }
    }

    private void beforeOperation(DynamicObject[] dyns) {
        HashMap<String, Map> headDataMap = new HashMap<String, Map>((int)((double)dyns.length / 0.75));
        HashMap<String, Map> entryDataMap = new HashMap<String, Map>();
        DynamicObjectCollection entryCol = null;
        for (DynamicObject dyn : dyns) {
            String number = dyn.getString("billno");
            headDataMap.put(number, DynamicObjectUtil.plainObject2Map((DynamicObject)dyn));
            entryCol = dyn.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entryCol) {
                entryDataMap.put(number + "_" + entry.get("seq"), DynamicObjectUtil.plainObject2Map((DynamicObject)entry));
            }
            dyn.set("modifier", (Object)dyn.getDynamicObject("creator"));
        }
        PurPaySaveUtil helper = new PurPaySaveUtil();
        helper.beforeAddEntity(Arrays.asList(dyns), headDataMap, entryDataMap);
        helper.afterAddEntity(Arrays.asList(dyns), headDataMap, entryDataMap);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        boolean easConfig = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"eas");
        boolean xkScmConfig = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"xkcloud");
        if (easConfig || xkScmConfig) {
            DynamicObject[] dyns = e.getDataEntities();
            this.endOperation(dyns);
        }
    }

    private void endOperation(DynamicObject[] dyns) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        OperationServiceHelper.executeOperate((String)"sendmsgtosup", (String)"pur_pay", (DynamicObject[])dyns, (OperateOption)option);
    }
}

