/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.QualityRectificEnum;
import kd.scm.pur.common.enums.ProblemTypeEnum;

public final class PurQualityRectificConfirmOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    String problemtype = dataEntity.getString("problemtype");
                    String problemnote = dataEntity.getString("problemnote");
                    if (StringUtils.isBlank((CharSequence)problemtype)) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5904\u7406\u65b9\u5f0f\u3002", (String)"PurQualityRectificConfirmOp_0", (String)"scm-pur-opplugin", (Object[])new Object[0]));
                    }
                    if (!ProblemTypeEnum.PENDINGREFEEDBACK.getValue().equals(problemtype) || !StringUtils.isBlank((CharSequence)problemnote)) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5904\u7406\u610f\u89c1\u3002", (String)"PurQualityRectificConfirmOp_1", (String)"scm-pur-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            String icastatus = dataEntity.getString("icastatus");
            String pcastatus = dataEntity.getString("pcastatus");
            String verifystatus = dataEntity.getString("verifystatus");
            String problemtype = dataEntity.getString("problemtype");
            String problemnote = dataEntity.getString("problemnote");
            String problemsummary = dataEntity.getString("problemsummary");
            Boolean isICAPCA = false;
            if ("E".equals(problemtype)) {
                isICAPCA = true;
            }
            if (QualityRectificEnum.PENDINGCONFIRMATION.getValue().equals(icastatus)) {
                Date now = TimeServiceHelper.now();
                dataEntity.set("icastatus", (Object)problemtype);
                dataEntity.set("icaexplanation", (Object)problemnote);
                dataEntity.set("icaconfirmer", (Object)RequestContext.get().getCurrUserId());
                dataEntity.set("icaconfirmtime", (Object)now);
                if (!isICAPCA.booleanValue()) continue;
                dataEntity.set("icastatus", (Object)QualityRectificEnum.CONFIRMED.getValue());
                dataEntity.set("icaexplanation", (Object)problemnote);
                dataEntity.set("icaconfirmer", (Object)RequestContext.get().getCurrUserId());
                dataEntity.set("icaconfirmtime", (Object)now);
                dataEntity.set("pcastatus", (Object)QualityRectificEnum.CONFIRMED.getValue());
                dataEntity.set("pcaexplanation", (Object)problemnote);
                dataEntity.set("pcaconfirmer", (Object)RequestContext.get().getCurrUserId());
                dataEntity.set("pcaconfirmtime", (Object)now);
                continue;
            }
            if (QualityRectificEnum.PENDINGCONFIRMATION.getValue().equals(pcastatus)) {
                dataEntity.set("pcastatus", (Object)problemtype);
                dataEntity.set("pcaexplanation", (Object)problemnote);
                dataEntity.set("pcaconfirmer", (Object)RequestContext.get().getCurrUserId());
                dataEntity.set("pcaconfirmtime", (Object)TimeServiceHelper.now());
                continue;
            }
            if (!QualityRectificEnum.PENDINGCONFIRMATION.getValue().equals(verifystatus)) continue;
            dataEntity.set("verifystatus", (Object)problemtype);
            dataEntity.set("verifyexplanation", (Object)problemnote);
            dataEntity.set("verifyconfirmer", (Object)RequestContext.get().getCurrUserId());
            dataEntity.set("verifyconfirmtime", (Object)TimeServiceHelper.now());
            dataEntity.set("summary", (Object)problemsummary);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }
}

