/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin.validator;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.TimeServiceHelper;

public class PurStockUrgeValidator
extends AbstractValidator {
    public void validate() {
        IAppCache cache = AppCache.get((String)"scm-pur");
        HashMap userUrgeLimitMap = (HashMap)cache.get("userStockUrgeLimit", HashMap.class);
        if (null == userUrgeLimitMap) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            String urgeTime;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String dynId = String.valueOf(dynamicObject.getPkValue());
            String currUserId = RequestContext.get().getUserId();
            Date now = TimeServiceHelper.now();
            Map urgeBillMap = (Map)userUrgeLimitMap.get(currUserId);
            if (null == urgeBillMap || (urgeTime = (String)urgeBillMap.get(dynId)) == null) continue;
            long date = Long.parseLong(urgeTime);
            long countDown = now.getTime() - date;
            if (countDown / 3600000L >= 1L) continue;
            String minutes = String.valueOf(60L - countDown / 60000L);
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u53d1\u9001\u50ac\u529e\u6d88\u606f\uff0c\u8bf7{0}\u5206\u949f\u540e\u91cd\u8bd5\u3002", (String)"PurOrderUrgeValidator_0", (String)"scm-pur-opplugin", (Object[])new Object[]{minutes}));
        }
    }
}

