/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.checkmapping.PurCheckMappingUtils;
import kd.scm.common.util.BussinessTypeUtils;
import kd.scm.common.util.CheckUtils;
import kd.scm.common.util.CommonUtil;
import kd.scm.pur.business.PurStockAvailableMatchBasicQtyHelper;
import kd.scm.sccore.business.CheckAvailableBasicQtyHelper;

public final class PurAvailableCheckBasicQtyHelper {
    private static final Log log = LogFactory.getLog(PurAvailableCheckBasicQtyHelper.class);

    public static Map<Long, Map<String, BigDecimal>> assembleMatchAvailableBasicQty(Collection<Long> checkEntryIds, Map<String, String> customParamMap) {
        List<DynamicObject> queryStockData = PurStockAvailableMatchBasicQtyHelper.queryData("pur_check", new QFilter("materialentry.id", "in", checkEntryIds), "materialentry.id entryid,materialentry.businesstype_in.number businesstype,materialentry.material material,materialentry.unit unit,materialentry.basicunit basicunit,materialentry.qty qty,materialentry.basicqty basicqty,materialentry.linetype.controlcriterion controlcriterion,materialentry.inqty inqty,materialentry.unmatchqty unmatchqty,materialentry.srcentryid srcentryid,materialentry.suminvqty suminvqty,materialentry.srcbilltype srcbilltype", "");
        HashMap<String, Collection<Long>> checkData = new HashMap<String, Collection<Long>>(1024);
        HashSet<Long> materialIds = new HashSet<Long>(1024);
        HashSet<Long> unitIds = new HashSet<Long>(1024);
        for (DynamicObject bill : queryStockData) {
            HashSet<Long> stepSrcEntryIds;
            materialIds.add(bill.getLong("material"));
            unitIds.add(bill.getLong("unit"));
            unitIds.add(bill.getLong("basicunit"));
            String srcBillType = bill.getString("srcbilltype");
            String businesstype = bill.getString("businesstype");
            if (CheckUtils.isPurInstock((String)srcBillType) && BussinessTypeUtils.isOmBussinessType((String)businesstype)) {
                srcBillType = "im_mdc_omcmplinbill";
            }
            if ((stepSrcEntryIds = (HashSet<Long>)checkData.get(srcBillType)) == null) {
                stepSrcEntryIds = new HashSet<Long>(1024);
            }
            String srcEntryId = bill.getString("srcentryid");
            stepSrcEntryIds.add(Long.parseLong(srcEntryId));
            checkData.put(srcBillType, stepSrcEntryIds);
        }
        HashMap<Long, Map<String, BigDecimal>> checkAvailableDataMap = new HashMap<Long, Map<String, BigDecimal>>(1024);
        HashMap<String, Map<String, BigDecimal>> matchAvailableBasicQty = new HashMap<String, Map<String, BigDecimal>>(1024);
        matchAvailableBasicQty.putAll(PurAvailableCheckBasicQtyHelper.assembleFullMatchQty(checkData, customParamMap));
        Map materialCaches = BusinessDataServiceHelper.loadFromCache((Object[])materialIds.toArray(), (String)"bd_material");
        Map measureunitsCache = BusinessDataServiceHelper.loadFromCache((Object[])unitIds.toArray(), (String)"bd_measureunits");
        Map stepBasicQty = null;
        HashMap<String, BigDecimal> rowMap = null;
        BigDecimal suminvBasicQty = BigDecimal.ZERO;
        for (DynamicObject bill : queryStockData) {
            String srcEntryId = bill.getString("srcentryid");
            Long entryId = bill.getLong("entryid");
            BigDecimal qty = bill.getBigDecimal("qty");
            BigDecimal suminvqty = bill.getBigDecimal("suminvqty");
            BigDecimal basicQty = bill.getBigDecimal("basicqty");
            Object material = bill.get("material");
            Object unit = bill.get("unit");
            Object basicunit = bill.get("basicunit");
            stepBasicQty = (Map)matchAvailableBasicQty.get(srcEntryId);
            BigDecimal availableQty = BigDecimal.ZERO;
            BigDecimal availableBasicQty = BigDecimal.ZERO;
            if (unit.equals(basicunit)) {
                suminvBasicQty = suminvqty;
            } else {
                suminvBasicQty = CommonUtil.getDesQtyConv((DynamicObject)((DynamicObject)materialCaches.get(material)), (DynamicObject)((DynamicObject)measureunitsCache.get(unit)), (BigDecimal)suminvqty, (DynamicObject)((DynamicObject)measureunitsCache.get(basicunit)));
                if (suminvBasicQty == null || suminvBasicQty.compareTo(BigDecimal.ZERO) == 0) {
                    suminvBasicQty = suminvqty;
                }
            }
            if (stepBasicQty != null) {
                BigDecimal unverifyqty = (BigDecimal)stepBasicQty.get("unverifyqty");
                BigDecimal unverifybaseqty = (BigDecimal)stepBasicQty.get("unverifybaseqty");
                availableQty = unverifyqty.subtract(suminvqty);
                availableBasicQty = unverifybaseqty.subtract(suminvBasicQty);
            } else {
                availableQty = qty.subtract(suminvqty);
                availableBasicQty = basicQty.subtract(suminvBasicQty);
            }
            rowMap = new HashMap<String, BigDecimal>(2);
            rowMap.put("basicqty", availableBasicQty);
            rowMap.put("qty", availableQty);
            checkAvailableDataMap.put(entryId, rowMap);
        }
        if (log.isDebugEnabled()) {
            log.debug("PurAvailableStockBasicQtyService#getOrderStockBasicQty#orderAvailableDataMap:{}", (Object)SerializationUtils.toJsonString(checkAvailableDataMap));
        }
        return checkAvailableDataMap;
    }

    public static void assembleDetailmatchQty(Collection<DynamicObject> purDetailList) {
        HashMap<String, Collection<Long>> checkData = new HashMap<String, Collection<Long>>(1024);
        List pmOmBussnissTypeIds = BussinessTypeUtils.getOmBussnissTypeIds();
        for (DynamicObject row : purDetailList) {
            HashSet<Long> stepSrcEntryIds;
            String srcBillType = row.getString("srcbilltype");
            String srcEntryId = row.getString("entryid");
            Long businesstypeId = row.getLong("businesstype_in");
            if (CheckUtils.isPurInstock((String)srcBillType) && pmOmBussnissTypeIds.contains(businesstypeId)) {
                srcBillType = "im_mdc_omcmplinbill";
            }
            if ((stepSrcEntryIds = (HashSet<Long>)checkData.get(srcBillType)) == null) {
                stepSrcEntryIds = new HashSet<Long>(1024);
            }
            stepSrcEntryIds.add(Long.parseLong(srcEntryId));
            checkData.put(srcBillType, stepSrcEntryIds);
        }
        HashMap<String, BigDecimal> matchAvailableBasicQty = new HashMap<String, BigDecimal>(1024);
        HashMap<String, String> customParamMap = new HashMap<String, String>(8);
        if (!checkData.isEmpty()) {
            matchAvailableBasicQty.putAll(PurAvailableCheckBasicQtyHelper.assembleAvailableMatchQty(checkData, customParamMap));
        }
        BigDecimal availableMatchQty = null;
        for (DynamicObject row : purDetailList) {
            BigDecimal unmatchqty = row.getBigDecimal("unmatchqty");
            String srcEntryId = row.getString("entryid");
            availableMatchQty = matchAvailableBasicQty.getOrDefault(srcEntryId, unmatchqty);
            if (availableMatchQty != null) {
                row.set("unmatchqty", (Object)availableMatchQty);
            }
            PurCheckMappingUtils.assembleDetailUnmatchtaxamount((DynamicObject)row, (String)"unmatchtaxamount", (String)"");
        }
    }

    public static void assembleDetailBusinessDirect(Collection<DynamicObject> purDetailList) {
        CheckAvailableBasicQtyHelper.assembleDetailBusinessDirect(purDetailList);
    }

    public static void modifyDetailmatchQty(Collection<DynamicObject> purDetailList) {
        HashMap<String, Collection<Long>> checkData = new HashMap<String, Collection<Long>>(1024);
        List pmOmBussnissTypeIds = BussinessTypeUtils.getOmBussnissTypeIds();
        for (DynamicObject row : purDetailList) {
            HashSet<Long> stepSrcEntryIds;
            String srcBillType = row.getString("srcbilltype3");
            String srcEntryId = row.getString("entryid3");
            Object businesstypeObj = row.get("businesstype_in3");
            long businesstypeId = 0L;
            if (businesstypeObj != null && !businesstypeObj.equals(0)) {
                businesstypeId = ((DynamicObject)businesstypeObj).getLong("id");
            }
            if (CheckUtils.isPurInstock((String)srcBillType) && pmOmBussnissTypeIds.contains(businesstypeId)) {
                srcBillType = "im_mdc_omcmplinbill";
            }
            if ((stepSrcEntryIds = (HashSet<Long>)checkData.get(srcBillType)) == null) {
                stepSrcEntryIds = new HashSet<Long>(1024);
            }
            stepSrcEntryIds.add(Long.parseLong(srcEntryId));
            checkData.put(srcBillType, stepSrcEntryIds);
        }
        HashMap<String, BigDecimal> matchAvailableBasicQty = new HashMap<String, BigDecimal>(1024);
        HashMap<String, String> customParamMap = new HashMap<String, String>(8);
        if (!checkData.isEmpty()) {
            matchAvailableBasicQty.putAll(PurAvailableCheckBasicQtyHelper.assembleAvailableMatchQty(checkData, customParamMap));
        }
        BigDecimal availableMatchQty = null;
        for (DynamicObject row : purDetailList) {
            BigDecimal unmatchqty;
            String srcEntryId = row.getString("entryid3");
            availableMatchQty = matchAvailableBasicQty.getOrDefault(srcEntryId, unmatchqty = row.getBigDecimal("unmatchqty3"));
            if (availableMatchQty != null) {
                row.set("unmatchqty3", (Object)availableMatchQty);
            }
            PurCheckMappingUtils.assembleDetailUnmatchtaxamount((DynamicObject)row, (String)"unmatchtaxamount3", (String)"3");
        }
    }

    public static Map<String, BigDecimal> assembleAvailableMatchQty(Map<String, Collection<Long>> checkData, Map<String, String> customParamMap) {
        HashMap<String, BigDecimal> checkAvailableDataMap = new HashMap<String, BigDecimal>(1024);
        Map<String, Map<String, BigDecimal>> fullMatchQtyMap = PurAvailableCheckBasicQtyHelper.assembleFullMatchQty(checkData, customParamMap);
        Map<String, BigDecimal> stepBasicQty = null;
        for (Map.Entry<String, Map<String, BigDecimal>> entry : fullMatchQtyMap.entrySet()) {
            String entryKey = entry.getKey();
            stepBasicQty = entry.getValue();
            if (stepBasicQty == null) continue;
            checkAvailableDataMap.put(entryKey, stepBasicQty.get("unverifyqty"));
        }
        return checkAvailableDataMap;
    }

    private static Map<String, Map<String, BigDecimal>> assembleFullMatchQty(Map<String, Collection<Long>> checkData, Map<String, String> customParamMap) {
        HashMap<String, Map<String, BigDecimal>> checkAvailableDataMap = new HashMap<String, Map<String, BigDecimal>>(1024);
        String srcBillType = null;
        String entity = null;
        for (Map.Entry<String, Collection<Long>> entry : checkData.entrySet()) {
            String entryNumber = entry.getKey();
            srcBillType = entry.getKey();
            if (CheckUtils.isPurInstock((String)srcBillType)) {
                entity = "im_purinbill";
            } else if (CheckUtils.isPurReciept((String)srcBillType)) {
                entity = "im_purreceivebill";
            }
            if ("im_mdc_omcmplinbill".equals(srcBillType)) {
                entity = "im_mdc_omcmplinbill";
                entryNumber = "pur_instock";
            }
            customParamMap.put("srcbilltype", entity);
            if (!CheckUtils.isPurInstock((String)srcBillType) && !CheckUtils.isPurReciept((String)srcBillType) && !"im_mdc_omcmplinbill".equals(srcBillType)) continue;
            checkAvailableDataMap.putAll(PurStockAvailableMatchBasicQtyHelper.assembleMatchAvailableBasicQty(entryNumber, entry.getValue(), customParamMap));
        }
        return checkAvailableDataMap;
    }
}

