/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.ParamUtil;

public class PurEasInvoiceSendHelper {
    private static Log log = LogFactory.getLog(PurEasInvoiceSendHelper.class);
    private static String error_code_0 = "000";
    private static String error_code_1 = "001";
    private static String error_code_2 = "002";
    private static String error_code_3 = "003";
    private static String error_code_4 = "004";

    public static String doInvioceReceiveOperate(List<Object> invoiceList, String action) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1024);
        paramMap.put("invoices", invoiceList);
        paramMap.put("action", action);
        HashMap<String, HashMap<String, Object>> dataMap = new HashMap<String, HashMap<String, Object>>(1024);
        dataMap.put("data", paramMap);
        log.info("####");
        String msg = ApiUtil.doInvoiceOperate(dataMap);
        return msg;
    }

    public static boolean getParamStatus(DynamicObject[] invoices) {
        final String orgID = invoices[0].getDynamicObject("org").getString("id");
        Map params = ParamUtil.getParam((String)"eae607fb000143ac", (String)"eastax", (Set)new HashSet<String>(8){
            {
                super(x0);
                this.add(orgID);
            }
        });
        String status = (String)params.get(orgID);
        return Boolean.parseBoolean(status);
    }

    public static void buildInvoiceData(DynamicObject[] invoices, Set<String> invoiceBillnoSet, List<Object> invoiceList, Map<String, String> invoicecode_no_NumMap) {
        HashMap<String, String> entryInvoiceMap = new HashMap<String, String>(8);
        DynamicObjectCollection invoiceEntry = null;
        String orgNumber = null;
        for (DynamicObject invoice : invoices) {
            invoiceEntry = invoice.getDynamicObjectCollection("entryentity");
            String billno = invoice.getString("billno");
            String supplier = invoice.getDynamicObject("supplier").getString("number");
            invoiceBillnoSet.add(billno);
            if (null == invoice.getDynamicObject("org")) continue;
            orgNumber = invoice.getDynamicObject("org").getString("number");
            for (DynamicObject entry : invoiceEntry) {
                String invcode = entry.getString("invcode");
                String invno = entry.getString("invno");
                entryInvoiceMap = new HashMap(1024);
                entryInvoiceMap.put("companyNumber", orgNumber);
                entryInvoiceMap.put("invoiceCode", invcode);
                entryInvoiceMap.put("supplierNumber", supplier);
                entryInvoiceMap.put("invoiceNo", invno);
                invoiceList.add(entryInvoiceMap);
                invoicecode_no_NumMap.put(invcode + "_" + invno, billno);
            }
        }
    }

    public static StringBuffer parseAfterOperatorMsg(Map<String, String> invoicecode_no_NumMap, Set<String> invoiceBillnoSet, String msg) {
        if (StringUtils.isEmpty((CharSequence)msg)) {
            return null;
        }
        log.info(msg);
        StringBuffer errorStrBuffer = new StringBuffer();
        Map returnMap = (Map)JacksonJsonUtil.fromJson((String)msg, Map.class);
        Map msgMap = (Map)returnMap.get("data");
        Object totalErrorCode = msgMap.get("totalErrorCode");
        Object totalErrorMsg = msgMap.get("totalErrorMsg");
        String loadKDStr = ResManager.loadKDString((String)"\u53d1\u7968", (String)"PurEasInvoiceSendHelper_0", (String)"scm-pur-business", (Object[])new Object[0]);
        if (error_code_0.equals(totalErrorCode)) {
            return null;
        }
        if (error_code_1.equals(totalErrorCode)) {
            HashMap<String, StringBuffer> errmsgMap = new HashMap<String, StringBuffer>(1024);
            List invList = (List)msgMap.get("detailData");
            String invoicesCode = null;
            String invoicesNo = null;
            String errcode = null;
            String errMsg = null;
            String invoiceBillno = null;
            for (Object e : invList) {
                StringBuffer strBuffer;
                Map invmsgMap = (Map)e;
                errcode = invmsgMap.get("errorCode").toString();
                invoicesCode = invmsgMap.get("invoiceCode").toString();
                invoicesNo = invmsgMap.get("invoiceNo").toString();
                errMsg = invmsgMap.get("errorMsg").toString();
                if (error_code_0.equals(errcode) || null == (invoiceBillno = invoicecode_no_NumMap.get(invoicesCode + "_" + invoicesNo))) continue;
                if (null != errmsgMap.get(invoiceBillno)) {
                    strBuffer = (StringBuffer)errmsgMap.get(invoiceBillno);
                    strBuffer.append(loadKDStr).append(invoicesCode).append(errMsg).append(";");
                    errmsgMap.put(invoiceBillno, strBuffer);
                    continue;
                }
                strBuffer = new StringBuffer();
                strBuffer.append(loadKDStr).append(invoicesCode).append(errMsg).append(";");
                errmsgMap.put(invoiceBillno, strBuffer);
            }
            if (errmsgMap.size() > 0) {
                for (Map.Entry entry : errmsgMap.entrySet()) {
                    invoiceBillnoSet.remove(entry.getKey());
                    errorStrBuffer.append((String)entry.getKey()).append(":").append((StringBuffer)entry.getValue());
                    errorStrBuffer.append("\n");
                }
            }
        } else {
            errorStrBuffer.append(String.valueOf(totalErrorMsg));
        }
        return errorStrBuffer;
    }
}

