/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;

public class PurQualityrectificConfirmHelper {
    public static void buildReqParamList(DynamicObject problemnotice, List<Map<String, Object>> reqParamList, String status, Boolean isICAPCA) {
        String srctype = problemnotice.getString("srctype");
        if (!"2".equals(srctype)) {
            return;
        }
        DynamicObjectCollection materialentry = problemnotice.getDynamicObjectCollection("materialentry");
        if (CollectionUtils.isEmpty((Collection)materialentry)) {
            return;
        }
        String srcbillidStr = ((DynamicObject)materialentry.get(0)).getString("srcbillid");
        Long srcbillid = Long.parseLong(srcbillidStr);
        if ("ica".equals(status)) {
            PurQualityrectificConfirmHelper.icaConfirm(problemnotice, srcbillid, reqParamList);
        }
        if ("pca".equals(status)) {
            PurQualityrectificConfirmHelper.pcaConfirm(problemnotice, srcbillid, reqParamList, isICAPCA);
        }
        if ("verify".equals(status)) {
            PurQualityrectificConfirmHelper.verifyConfirm(problemnotice, srcbillid, reqParamList);
        }
    }

    private static void icaConfirm(DynamicObject problemnotice, Long srcbillid, List<Map<String, Object>> reqParamList) {
        HashMap<String, Object> reqParamMap = new HashMap<String, Object>(16);
        reqParamMap.put("id", srcbillid);
        PurQualityrectificConfirmHelper.icaConfrimParambuild(problemnotice, reqParamMap);
        reqParamList.add(reqParamMap);
    }

    private static void pcaConfirm(DynamicObject problemnotice, Long srcbillid, List<Map<String, Object>> reqParamList, Boolean isICAPCA) {
        HashMap<String, Object> reqParamMap = new HashMap<String, Object>(16);
        reqParamMap.put("id", srcbillid);
        if (isICAPCA.booleanValue()) {
            PurQualityrectificConfirmHelper.icaConfrimParambuild(problemnotice, reqParamMap);
        }
        PurQualityrectificConfirmHelper.pcaConfirmParamBuild(problemnotice, reqParamMap);
        reqParamList.add(reqParamMap);
    }

    private static void verifyConfirm(DynamicObject problemnotice, Long srcbillid, List<Map<String, Object>> reqParamList) {
        HashMap<String, Object> reqParamMap = new HashMap<String, Object>(16);
        reqParamMap.put("id", srcbillid);
        PurQualityrectificConfirmHelper.verifyConfirmParamBuild(problemnotice, reqParamMap);
        reqParamList.add(reqParamMap);
    }

    private static void icaConfrimParambuild(DynamicObject problemnotice, Map<String, Object> reqParamMap) {
        DynamicObjectCollection recteamentry = problemnotice.getDynamicObjectCollection("recteamentry");
        LinkedList entry_step2 = new LinkedList();
        for (DynamicObject dy : recteamentry) {
            HashMap<String, String> entry_step2Map = new HashMap<String, String>(16);
            String teamsource = dy.getString("teamsource");
            if (!"B".equals(teamsource)) continue;
            entry_step2Map.put("role", dy.getString("teamroles"));
            entry_step2Map.put("name", dy.getString("name"));
            entry_step2Map.put("contactway", dy.getString("phone"));
            entry_step2Map.put("department", dy.getString("department"));
            entry_step2.add(entry_step2Map);
        }
        if (!CollectionUtils.isEmpty(entry_step2)) {
            reqParamMap.put("entry_step2", entry_step2);
        }
        DynamicObjectCollection rectmentry = problemnotice.getDynamicObjectCollection("rectmentry");
        LinkedList entry_step4 = new LinkedList();
        for (DynamicObject dy : rectmentry) {
            HashMap<String, Object> entry_step4Map = new HashMap<String, Object>(16);
            String teamsource = dy.getString("tmsource");
            if (!"B".equals(teamsource)) continue;
            entry_step4Map.put("tmpact", dy.getString("describe"));
            entry_step4Map.put("validresultrmp", dy.getString("verify"));
            entry_step4Map.put("responsertmp", dy.getString("tmhead"));
            entry_step4Map.put("fiinishtimetmp", dy.getDate("completiontime"));
            entry_step4Map.put("remarktmp", dy.getString("tmmemo"));
            List<Map<String, Object>> attachMents = PurQualityrectificConfirmHelper.buildAtta("rectmatta", dy);
            entry_step4Map.put("provetmp", attachMents);
            entry_step4.add(entry_step4Map);
        }
        if (!CollectionUtils.isEmpty(entry_step4)) {
            reqParamMap.put("entry_step4", entry_step4);
        }
    }

    private static List<Map<String, Object>> buildAtta(String field, DynamicObject dy) {
        DynamicObjectCollection files = dy.getDynamicObjectCollection(field);
        LinkedList<Map<String, Object>> attachMents = new LinkedList<Map<String, Object>>();
        for (DynamicObject file : files) {
            HashMap<String, Object> attachMent = new HashMap<String, Object>(16);
            attachMents.add(attachMent);
            attachMent.put("fpkid", file.get("fpkid"));
            attachMent.put("fbasedataid", file.get("fbasedataid"));
            attachMent.put("fbasedataid_id", file.get("fbasedataid_id"));
        }
        return attachMents;
    }

    private static void verifyConfirmParamBuild(DynamicObject problemnotice, Map<String, Object> reqParamMap) {
        DynamicObjectCollection reccauseentry = problemnotice.getDynamicObjectCollection("receventry");
        LinkedList entry_step7 = new LinkedList();
        for (DynamicObject dy : reccauseentry) {
            HashMap<String, Object> entry_step7Map = new HashMap<String, Object>(16);
            String casource = dy.getString("evsource");
            if (!"B".equals(casource)) continue;
            entry_step7Map.put("statusbefore", dy.getString("verifydescription"));
            entry_step7Map.put("responserec", dy.getString("evhead"));
            entry_step7Map.put("fiinishtimeec", dy.getDate("evcompletiontime"));
            entry_step7Map.put("remarkec", dy.getString("evmemo"));
            List<Map<String, Object>> attachMents = PurQualityrectificConfirmHelper.buildAtta("recevatta", dy);
            entry_step7Map.put("proveec", attachMents);
            entry_step7.add(entry_step7Map);
        }
        if (!CollectionUtils.isEmpty(entry_step7)) {
            reqParamMap.put("entry_step7", entry_step7);
        }
        DynamicObjectCollection recfmentry = problemnotice.getDynamicObjectCollection("recpmentry");
        LinkedList entry_step8 = new LinkedList();
        for (DynamicObject dy : recfmentry) {
            HashMap<String, Object> entry_step8Map = new HashMap<String, Object>(16);
            String casource = dy.getString("pmsource");
            if (!"B".equals(casource)) continue;
            entry_step8Map.put("preventmeasure", dy.getString("measuredescribe"));
            entry_step8Map.put("responserpm", dy.getString("pmhead"));
            entry_step8Map.put("fiinishtimepm", dy.getDate("pmcompletiontime"));
            entry_step8Map.put("remarkpm", dy.getString("pmmemo"));
            List<Map<String, Object>> attachMents = PurQualityrectificConfirmHelper.buildAtta("recpmatta", dy);
            entry_step8Map.put("provepm", attachMents);
            entry_step8.add(entry_step8Map);
        }
        if (!CollectionUtils.isEmpty(entry_step8)) {
            reqParamMap.put("entry_step8", entry_step8);
        }
    }

    private static void pcaConfirmParamBuild(DynamicObject problemnotice, Map<String, Object> reqParamMap) {
        DynamicObjectCollection reccauseentry = problemnotice.getDynamicObjectCollection("reccauseentry");
        LinkedList entry_step5 = new LinkedList();
        for (DynamicObject dy : reccauseentry) {
            HashMap<String, Object> entry_step5Map = new HashMap<String, Object>(16);
            String casource = dy.getString("casource");
            if (!"B".equals(casource)) continue;
            entry_step5Map.put("cause", dy.getString("suspiciousreason"));
            entry_step5Map.put("validresultca", dy.getString("verificationresult"));
            entry_step5Map.put("isprimarycause", dy.getString("isrootcause"));
            entry_step5Map.put("responserca", dy.getString("cahead"));
            entry_step5Map.put("fiinishtimeca", dy.getDate("cacompletiontime"));
            entry_step5Map.put("remarkca", dy.getString("camemo"));
            List<Map<String, Object>> attachMents = PurQualityrectificConfirmHelper.buildAtta("reccaatta", dy);
            entry_step5Map.put("proveca", attachMents);
            entry_step5.add(entry_step5Map);
        }
        if (!CollectionUtils.isEmpty(entry_step5)) {
            reqParamMap.put("entry_step5", entry_step5);
        }
        DynamicObjectCollection recfmentry = problemnotice.getDynamicObjectCollection("recfmentry");
        LinkedList entry_step6 = new LinkedList();
        for (DynamicObject dy : recfmentry) {
            HashMap<String, Object> entry_step6Map = new HashMap<String, Object>(16);
            String casource = dy.getString("fmsource");
            if (!"B".equals(casource)) continue;
            entry_step6Map.put("correctmeasure", dy.getString("fmdescribe"));
            entry_step6Map.put("validresultcm", dy.getString("fmverify"));
            entry_step6Map.put("responsercm", dy.getString("fmhead"));
            entry_step6Map.put("fiinishtimecm", dy.getDate("fmcompletiontime"));
            entry_step6Map.put("remarkcm", dy.getString("fmmemo"));
            List<Map<String, Object>> attachMents = PurQualityrectificConfirmHelper.buildAtta("recfmatta", dy);
            entry_step6Map.put("provecm", attachMents);
            entry_step6.add(entry_step6Map);
        }
        if (!CollectionUtils.isEmpty(entry_step6)) {
            reqParamMap.put("entry_step6", entry_step6);
        }
    }
}

