/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public final class PurSalStockPushHelper {
    private static Log logger = LogFactory.getLog(PurSalStockPushHelper.class);

    @Deprecated
    public static List<DynamicObject> pushAcceptBillByPurSaloutstock(List<DynamicObject> entitys, Map<String, String> paramMap) {
        if (CollectionUtils.isEmpty(paramMap)) {
            return null;
        }
        logger.info("\u534f\u540c\u4e0b\u63a8\u91c7\u8d2d\u9a8c\u6536\u5355botp\u63d2\u4ef6\u53c2\u6570={}", (Object)SerializationUtils.toJsonString(paramMap));
        Set<String> paramKeys = paramMap.keySet();
        String ispur = paramMap.get("ispur");
        if (StringUtils.isBlank((CharSequence)ispur) || !"true".equals(ispur)) {
            return null;
        }
        String splitStrategy = paramMap.get("splitstrategy");
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:MM:ss");
        for (DynamicObject bill : entitys) {
            DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("billentry");
            DynamicObjectCollection splitBillEntrys = new DynamicObjectCollection();
            long seq = 1L;
            for (DynamicObject billentry : billentrys) {
                String mainBillEntryId = billentry.getString("mainbillentryid");
                if (paramKeys.contains(mainBillEntryId) && "splitrow".equals(splitStrategy)) {
                    String entryParamStr = paramMap.get(mainBillEntryId);
                    List entryParamList = (List)SerializationUtils.fromJsonString((String)entryParamStr, List.class);
                    for (Map entryParamsMap : entryParamList) {
                        DynamicObject splitEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)billentry, (boolean)false, (boolean)true);
                        splitEntry.setParent(billentry.getParent());
                        PurSalStockPushHelper.setEntryProp(entryParamsMap, bill, splitEntry, sf);
                        splitEntry.set("seq", (Object)seq);
                        splitBillEntrys.add((Object)splitEntry);
                        ++seq;
                    }
                    continue;
                }
                if (!"splitbill".equals(splitStrategy)) continue;
                PurSalStockPushHelper.setEntryProp(paramMap, bill, billentry, sf);
            }
            if (splitBillEntrys.isEmpty()) continue;
            bill.set("billentry", (Object)splitBillEntrys);
        }
        return entitys;
    }

    private static void setEntryProp(Map<String, String> paramMap, DynamicObject bill, DynamicObject entry, SimpleDateFormat sf) {
        String mainBillEntryId = entry.getString("mainbillentryid");
        IDataEntityType loadEntryDataEntityType = entry.getDataEntityType();
        DataEntityPropertyCollection loadEntryProperties = loadEntryDataEntityType.getProperties();
        IDataEntityType loadBillDataEntityType = bill.getDataEntityType();
        DataEntityPropertyCollection loadBillProperties = loadBillDataEntityType.getProperties();
        for (Map.Entry<String, String> param : paramMap.entrySet()) {
            String key = param.getKey();
            String propKey = key.replace("_" + mainBillEntryId, "");
            String value = param.getValue();
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            if ("qty".equals(propKey)) {
                BigDecimal qty = new BigDecimal(value);
                DynamicObject material = entry.getDynamicObject("material");
                DynamicObject baseUnit = entry.getDynamicObject("baseUnit");
                DynamicObject unit = entry.getDynamicObject("unit");
                BigDecimal baseqty = PurSalStockPushHelper.getDesQtyConv(material, unit, qty, baseUnit);
                entry.set(propKey, (Object)qty);
                entry.set("baseqty", (Object)baseqty);
                continue;
            }
            if (entry.containsProperty(propKey)) {
                PurSalStockPushHelper.setValue(entry, sf, loadEntryProperties, key, propKey, value);
                continue;
            }
            if (!bill.containsProperty(propKey)) continue;
            PurSalStockPushHelper.setValue(bill, sf, loadBillProperties, key, propKey, value);
        }
    }

    private static void setValue(DynamicObject entry, SimpleDateFormat sf, DataEntityPropertyCollection loadProperties, String key, String propKey, String value) {
        IDataEntityProperty loadProperty = (IDataEntityProperty)loadProperties.get((Object)propKey);
        try {
            if (loadProperty instanceof DateTimeProp) {
                entry.set(propKey, (Object)sf.parse(value));
            } else if (loadProperty instanceof BooleanProp) {
                entry.set(propKey, (Object)Boolean.valueOf(value));
            } else if (loadProperty instanceof DecimalProp) {
                BigDecimal bigDecimalValue = new BigDecimal(value);
                entry.set(propKey, (Object)bigDecimalValue);
            } else {
                entry.set(propKey, (Object)value);
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u8d27\u5355\u4e0b\u63a8\u5b57\u6bb5\u8bbe\u7f6e\u503c\u5f02\u5e38", (Throwable)e);
        }
    }

    private static BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal qty = BigDecimal.ZERO;
        if (material == null || srcUnit == null || desUnit == null || srcQty == null) {
            qty = BigDecimal.ZERO;
        } else if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            qty = srcQty;
        } else {
            BigDecimal unitRate;
            Long materialId = material.getLong("masterid.id");
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("numerator") != 0 && (unitRate = new BigDecimal(muConv.getInt("denominator")).divide(new BigDecimal(muConv.getInt("numerator")), 10, 4)) != null && unitRate.compareTo(BigDecimal.ZERO) != 0) {
                int unitPrecision = desUnit.getInt("precision");
                if (StringUtils.isNotBlank((CharSequence)desUnit.getString("precisionaccount"))) {
                    int account = desUnit.getInt("precisionaccount");
                    int unitPrecisionType = 4;
                    if (account == 2) {
                        unitPrecisionType = 1;
                    } else if (account == 3) {
                        unitPrecisionType = 0;
                    }
                    qty = srcQty.divide(unitRate, unitPrecision, unitPrecisionType);
                }
            }
        }
        return qty;
    }
}

