/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.helper.SRMBillEntityTypeHelper;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.ScMultiDataHandleServiceHelper;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.CheckUtils;

public final class PurStockAvailableMatchBasicQtyHelper {
    private static final Log log = LogFactory.getLog(PurStockAvailableMatchBasicQtyHelper.class);

    public static Map<String, Map<String, BigDecimal>> assembleMatchAvailableBasicQty(String entityNumber, Collection<Long> stockEntryIds, Map<String, String> customParamMap) {
        if (stockEntryIds == null || stockEntryIds.isEmpty()) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u53c2\u6570:orderEntryIds\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2\u3002", (String)"PurAvailableStockBasicQtyHelper_0", (String)"scm-pur-business", (Object[])new Object[0]));
        }
        List<DynamicObject> queryStockData = PurStockAvailableMatchBasicQtyHelper.queryStockData(entityNumber, stockEntryIds);
        Map<String, Map<String, BigDecimal>> matchERPAvailableDataMap = PurStockAvailableMatchBasicQtyHelper.getErpMatchBasicQty(queryStockData, customParamMap);
        Map<String, BigDecimal> stepBasicQty = null;
        HashMap<String, BigDecimal> rowMap = null;
        HashMap<String, Map<String, BigDecimal>> matchAvailableBasicQty = new HashMap<String, Map<String, BigDecimal>>(1024);
        for (DynamicObject bill : queryStockData) {
            String businessDirect;
            Boolean isreturn;
            String srcEntryId = bill.getString("srcentryid");
            String entryId = bill.getString("entryid");
            BigDecimal qty = bill.getBigDecimal("qty");
            BigDecimal unmatchqty = bill.getBigDecimal("unmatchqty");
            BigDecimal basicqty = bill.getBigDecimal("basicqty");
            BigDecimal unmatchbaseqty = bill.getBigDecimal("unmatchbaseqty");
            if (CheckUtils.isPurReciept((String)entityNumber) && (isreturn = Boolean.valueOf(bill.getBoolean("isreturn"))).booleanValue()) {
                qty = qty.compareTo(BigDecimal.ZERO) > 0 ? qty.negate() : qty;
                unmatchqty = unmatchqty.compareTo(BigDecimal.ZERO) > 0 ? unmatchqty.negate() : unmatchqty;
                basicqty = basicqty.compareTo(BigDecimal.ZERO) > 0 ? basicqty.negate() : basicqty;
                BigDecimal bigDecimal = unmatchbaseqty = unmatchbaseqty.compareTo(BigDecimal.ZERO) > 0 ? unmatchbaseqty.negate() : unmatchbaseqty;
            }
            if ("pur_return".equals(entityNumber) || "scp_return".equals(entityNumber)) {
                qty = qty.compareTo(BigDecimal.ZERO) > 0 ? qty.negate() : qty;
                unmatchqty = unmatchqty.compareTo(BigDecimal.ZERO) > 0 ? unmatchqty.negate() : unmatchqty;
                basicqty = basicqty.compareTo(BigDecimal.ZERO) > 0 ? basicqty.negate() : basicqty;
                BigDecimal bigDecimal = unmatchbaseqty = unmatchbaseqty.compareTo(BigDecimal.ZERO) > 0 ? unmatchbaseqty.negate() : unmatchbaseqty;
            }
            if (("pur_instock".equals(entityNumber) || "scp_instock".equals(entityNumber)) && "return".equals(businessDirect = bill.getString("businessdirect"))) {
                qty = qty.compareTo(BigDecimal.ZERO) > 0 ? qty.negate() : qty;
                unmatchqty = unmatchqty.compareTo(BigDecimal.ZERO) > 0 ? unmatchqty.negate() : unmatchqty;
                basicqty = basicqty.compareTo(BigDecimal.ZERO) > 0 ? basicqty.negate() : basicqty;
                unmatchbaseqty = unmatchbaseqty.compareTo(BigDecimal.ZERO) > 0 ? unmatchbaseqty.negate() : unmatchbaseqty;
            }
            stepBasicQty = matchERPAvailableDataMap.get(srcEntryId);
            BigDecimal availableQty = BigDecimal.ZERO;
            BigDecimal availableBasicQty = BigDecimal.ZERO;
            if (stepBasicQty != null) {
                availableQty = stepBasicQty.get("unverifyqty");
                availableBasicQty = stepBasicQty.get("unverifybaseqty");
            } else {
                availableQty = unmatchqty == null ? qty : unmatchqty;
                availableBasicQty = unmatchbaseqty == null ? basicqty : unmatchbaseqty;
            }
            rowMap = new HashMap<String, BigDecimal>(2);
            rowMap.put("unverifyqty", availableQty);
            rowMap.put("unverifybaseqty", availableBasicQty);
            matchAvailableBasicQty.put(entryId, rowMap);
        }
        if (log.isDebugEnabled()) {
            log.debug("PurAvailableStockBasicQtyService#getOrderStockBasicQty#orderAvailableDataMap:{}", (Object)SerializationUtils.toJsonString(matchERPAvailableDataMap));
        }
        return matchAvailableBasicQty;
    }

    public static Map<String, Map<String, BigDecimal>> getErpMatchBasicQty(List<DynamicObject> executeBills, Map<String, String> customParamMap) {
        HashMap messageMap = new HashMap(1024);
        String keyField = customParamMap.getOrDefault("keyField", "id");
        String jointChannelField = customParamMap.getOrDefault("jointChannelField", "jointdatachannelid");
        try {
            MultiDataHandleResult dataHandleResult = ScMultiDataHandleServiceHelper.executeManualSceneHandle((String)"manualcheckstockmatchqty", executeBills, (String)keyField, (String)jointChannelField, customParamMap);
            String messageJsonString = dataHandleResult.getMessage();
            messageMap.putAll((Map)SerializationUtils.fromJsonString((String)messageJsonString, Map.class));
            if (log.isDebugEnabled()) {
                log.debug("PurAvailableStockBasicQtyHelper#getErpStockBasicQty#messageMap:{}", (Object)SerializationUtils.toJsonString(messageMap));
            }
        }
        catch (RuntimeException runtimeException) {
            SRMStoreExceptionTraceHelper.saveWarnData((RuntimeException)runtimeException);
        }
        HashMap<String, Map<String, BigDecimal>> stockQtyMap = new HashMap<String, Map<String, BigDecimal>>(1024);
        if (!messageMap.isEmpty()) {
            HashMap<String, BigDecimal> stepBasicQty = null;
            for (Map.Entry entry : messageMap.entrySet()) {
                String entryKey = (String)entry.getKey();
                Map entryValue = (Map)entry.getValue();
                String unVerifyQtyString = (String)entryValue.get("unverifyqty");
                String unVerifyBaseQtyString = (String)entryValue.get("unverifybaseqty");
                BigDecimal unVerifyQty = BigDecimal.ZERO;
                BigDecimal unVerifyBaseQty = BigDecimal.ZERO;
                if (unVerifyQtyString != null) {
                    unVerifyQty = new BigDecimal(unVerifyQtyString);
                }
                if (unVerifyBaseQtyString != null) {
                    unVerifyBaseQty = new BigDecimal(unVerifyBaseQtyString);
                }
                stepBasicQty = new HashMap<String, BigDecimal>(2);
                stepBasicQty.put("unverifyqty", unVerifyQty);
                stepBasicQty.put("unverifybaseqty", unVerifyBaseQty);
                stockQtyMap.put(entryKey, stepBasicQty);
            }
        }
        return stockQtyMap;
    }

    public static List<DynamicObject> queryStockData(String entityNumber, Collection<Long> stockEntryIds) {
        Collection<String> properties = PurStockAvailableMatchBasicQtyHelper.assembleMustProperties();
        if (CheckUtils.isPurReciept((String)entityNumber)) {
            properties.add("isreturn");
        }
        String entityFields = SRMBillEntityTypeHelper.getEntityFields((String)entityNumber, properties);
        QFilter filter = new QFilter("materialentry.id", "in", stockEntryIds);
        return PurStockAvailableMatchBasicQtyHelper.queryData(entityNumber, filter, "materialentry.id entryid," + entityFields, null);
    }

    public static List<DynamicObject> queryData(String entityNumber, QFilter qFilter, String entityFields, String orderBysParam) {
        ORM orm = ORM.create();
        ArrayList<DynamicObject> jointBills = new ArrayList<DynamicObject>(1024);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)PurStockAvailableMatchBasicQtyHelper.class.getName(), (String)entityNumber, (String)entityFields, (QFilter[])new QFilter[]{qFilter}, (String)orderBysParam);
        jointBills.addAll((Collection<DynamicObject>)orm.toPlainDynamicObjectCollection(dataSet));
        return jointBills;
    }

    public static Collection<String> assembleMustProperties() {
        HashSet<String> properties = new HashSet<String>(64);
        properties.add("billno");
        properties.add("businessdirect");
        properties.add("businesstype");
        properties.add("material");
        properties.add("basicunit");
        properties.add("unit");
        properties.add("unmatchqty");
        properties.add("unmatchbaseqty");
        properties.add("srcentryid");
        properties.add("qty");
        properties.add("basicqty");
        properties.add("srcbilltype");
        properties.add("jointdatachannelid");
        return properties;
    }

    public static List<DynamicObject> assembleJointBill(Collection<DynamicObject> allRows) {
        final Iterator<DynamicObject> allRowsIterator = allRows.iterator();
        ArrayList<DynamicObject> queryStockData = new ArrayList<DynamicObject>(1024);
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("billno", (DataType)DataType.StringType), new Field("jointdatachannelid", (DataType)DataType.StringType), new Field("srcentryid", (DataType)DataType.StringType), new Field("srcbilltype", (DataType)DataType.StringType)});
        DataSet dataSet = Algo.create((String)"PurStockAvailableMatchBasicQtyHelperAlgo").createDataSet((Iterator)new Iterator<Object[]>(){

            @Override
            public boolean hasNext() {
                return allRowsIterator.hasNext();
            }

            @Override
            public Object[] next() {
                DynamicObject row = (DynamicObject)allRowsIterator.next();
                DynamicObject bill = (DynamicObject)row.getParent();
                Long id = bill.getLong("id");
                String billNo = bill.getString("id");
                String jointdatachannelid = row.getString("jointdatachannelid");
                String srcentryid = row.getString("srcentryid");
                String srcbilltype = row.getString("srcbilltype");
                return new Object[]{id, billNo, jointdatachannelid, srcentryid, srcbilltype};
            }
        }, rowMeta);
        ORM orm = ORM.create();
        queryStockData.addAll((Collection<DynamicObject>)orm.toPlainDynamicObjectCollection(dataSet));
        return queryStockData;
    }
}

