/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business.suppliercoll;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.pur.business.suppliercoll.PurSupplierCollInitiateHelper;

final class PurSupplierCollPermHelper {
    private static final Log log = LogFactory.getLog(PurSupplierCollPermHelper.class);

    PurSupplierCollPermHelper() {
    }

    private IAppCache getAppCache() {
        return AppCache.get((String)PurSupplierCollInitiateHelper.BATCH_INITIALIZE_SUPPLIER_CONTROL);
    }

    public Collection<Long> assembleAvailableCtrlOrgs(List<Long> purOrgUnits) {
        return this.assembleAvailableCtrl(purOrgUnits);
    }

    public QFilter assembleAvailableSupplierQFilter(List<Long> ctrlOrgId) {
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", ctrlOrgId, (boolean)false);
        qFilter = qFilter != null ? qFilter.and(new QFilter("createorg.id", "in", ctrlOrgId)) : new QFilter("createorg.id", "in", ctrlOrgId);
        return qFilter;
    }

    public Collection<Long> assembleAvailableOrgUnits() {
        HashSet<Long> org = new HashSet<Long>(1024);
        HasPermDimObjResult hasPermDimObjResult = PermissionServiceHelper.getUserHasPermDimObjs((long)RequestContext.get().getCurrUserId(), (String)"bos_org");
        if (hasPermDimObjResult.hasAllDimObjPerm()) {
            org.addAll(OrgUnitServiceHelper.getAllOrg((String)"15"));
        } else {
            org.addAll(hasPermDimObjResult.getHasPermDimObjs());
        }
        return org;
    }

    public Collection<Long> assembleAvailablePurOrgUnits() {
        HashSet<Long> org = new HashSet<Long>(1024);
        List allOrg = OrgUnitServiceHelper.getAllOrg((String)"02");
        HasPermDimObjResult hasPermDimObjResult = PermissionServiceHelper.getUserHasPermDimObjs((long)RequestContext.get().getCurrUserId(), (String)"bos_org");
        if (hasPermDimObjResult.hasAllDimObjPerm()) {
            org.addAll(allOrg);
        } else {
            allOrg.retainAll(hasPermDimObjResult.getHasPermDimObjs());
            org.addAll(allOrg);
        }
        return org;
    }

    public Collection<Long> assembleAvailableCtrl(List<Long> purOrgUnits) {
        HashSet<Long> availableOrgCtrlUnit = new HashSet<Long>(1024);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)"bd_supplier");
        String treeType = ctrlView.getString("treetype");
        if ("16".equals(treeType)) {
            QFilter viewFilter = new QFilter("view.id", "=", (Object)ctrlView.getLong("id"));
            QFilter orgFilter = new QFilter("org.id", "in", purOrgUnits);
            QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
            Map viewOrgArr = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (QFilter[])filters);
            HashMap<Long, Long> ctrlOrgParentMap = new HashMap<Long, Long>(1024);
            ArrayList<DynamicObject> doubleCheckOrgColl = new ArrayList<DynamicObject>(1024);
            for (Map.Entry entry : viewOrgArr.entrySet()) {
                DynamicObject viewOrg = (DynamicObject)entry.getValue();
                Long tempOrgId = (Long)viewOrg.get("org.id");
                if (!viewOrg.getBoolean("isctrlunit")) continue;
                if (viewOrg.getInt("level") > 1) {
                    DynamicObject parentOrg = viewOrg.getDynamicObject("parent");
                    if (parentOrg == null) continue;
                    ctrlOrgParentMap.put(viewOrg.getLong("org.id"), parentOrg.getLong("id"));
                    doubleCheckOrgColl.add(viewOrg);
                    continue;
                }
                if (viewOrg.getInt("level") != 1) continue;
                availableOrgCtrlUnit.add(tempOrgId);
            }
            if (!CollectionUtils.isEmpty(ctrlOrgParentMap)) {
                Map parentCheck = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (QFilter[])new QFilter[]{new QFilter("org.id", "in", ctrlOrgParentMap.values()).and(viewFilter)});
                ArrayList<Long> parentOrgCtrlColl = new ArrayList<Long>(1024);
                for (Map.Entry entry : parentCheck.entrySet()) {
                    DynamicObject viewOrg = (DynamicObject)entry.getValue();
                    if (!viewOrg.getBoolean("isctrlunit")) continue;
                    parentOrgCtrlColl.add(viewOrg.getLong("org.id"));
                }
                for (DynamicObject viewOrg : doubleCheckOrgColl) {
                    Long tempOrgId = (Long)viewOrg.get("org.id");
                    Long parentOrgId = (Long)ctrlOrgParentMap.get(tempOrgId);
                    if (parentOrgId == null || !parentOrgCtrlColl.contains(parentOrgId)) continue;
                    availableOrgCtrlUnit.add(viewOrg.getLong("org.id"));
                }
            }
        }
        return availableOrgCtrlUnit;
    }
}

