/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business.suppliercoll.jointbill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.pur.business.suppliercoll.PurSupplierCollInitiateHelper;
import kd.scm.pur.business.suppliercoll.jointbill.InitJointDataService;

abstract class AbstractInitJointDataService
implements InitJointDataService {
    protected static final Log log = LogFactory.getLog(AbstractInitJointDataService.class);
    protected int batchSize;
    protected final Map<String, Collection<String>> executeBillMap = new HashMap<String, Collection<String>>(1024);

    AbstractInitJointDataService() {
    }

    @Override
    public Map<String, Map<String, String>> processQueryData() {
        return null;
    }

    @Override
    public final void processInitData() {
        block2: {
            String traceId = RequestContext.get().getTraceId();
            try {
                Map<String, Collection<String>> executeBillMap = this.executeBillMap;
                ArrayList<String> orderBillIds = new ArrayList<String>(executeBillMap.get(PurSupplierCollInitiateHelper.ORDERBILLIDS));
                ArrayList<String> orderChangeBillIds = new ArrayList<String>(executeBillMap.get(PurSupplierCollInitiateHelper.ORDERCHANGEBILLIDS));
                Collection<String> acceptBillIds = executeBillMap.get(PurSupplierCollInitiateHelper.ACCEPTBILLIDS);
                Collection<String> receiptBillIds = executeBillMap.get(PurSupplierCollInitiateHelper.RECEIPTBILLIDS);
                Collection<String> imStockBillIds = executeBillMap.get(PurSupplierCollInitiateHelper.INBILLBILLIDS);
                this.executeInitData(orderBillIds, orderChangeBillIds, acceptBillIds, receiptBillIds, imStockBillIds);
                this.storeInitiateSyncLog(traceId);
            }
            catch (RuntimeException runtimeException) {
                this.storeInitiateSyncLog(traceId);
                if (!log.isWarnEnabled()) break block2;
                log.warn((Throwable)runtimeException);
            }
        }
    }

    public final void initExecuteParam(Map<String, Collection<String>> executeBillMap, Integer batchSize) {
        this.executeBillMap.putAll(executeBillMap);
        this.batchSize = batchSize;
    }

    protected void executeInitData(Collection<String> orderBillIdsParam, Collection<String> orderChangeBillIdsParam, Collection<String> receiptBillIdsParam, Collection<String> inBillBillIdsParam) {
        this.executeInitData(orderBillIdsParam, orderChangeBillIdsParam, new ArrayList<String>(), receiptBillIdsParam, inBillBillIdsParam);
    }

    protected void executeInitData(Collection<String> orderBillIdsParam, Collection<String> orderChangeBillIdsParam, Collection<String> acceptBillIdsParam, Collection<String> receiptBillIdsParam, Collection<String> inBillBillIdsParam) {
    }

    protected void storeInitiateSyncLog(String traceId) {
        HashMap<String, String> configMap = new HashMap<String, String>(16);
        configMap.put(PurSupplierCollInitiateHelper.BATCHSIZE, String.valueOf(this.batchSize));
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        resultMap.put("successMessage", "");
        resultMap.put("validMessage", "");
        resultMap.put("errorMessage", "");
        PurSupplierCollInitiateHelper.storeInitiateSyncLog(traceId, SerializationUtils.toJsonString(configMap), SerializationUtils.toJsonString(this.executeBillMap), SerializationUtils.toJsonString(resultMap));
    }

    protected final List<String> getCurrIds(List<String> pkIds, int batchSize, int seq) {
        ArrayList<String> ids = new ArrayList<String>();
        int begin = seq * batchSize;
        int end = begin + batchSize;
        for (int i = begin; i < end && i < pkIds.size(); ++i) {
            ids.add(pkIds.get(i));
        }
        return ids;
    }
}

