/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.business.task;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.DateUtil;

public final class PurScheduleNotTimelyDeliverTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(PurScheduleNotTimelyDeliverTask.class);
    private static final String DEFAULT_OPERATE_KEY = "nottimelydeliverwarning";
    private static final int DEFAULT_BILL_DATE_DURING_COUNT = 6;

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        int billDateDuringCount = 0;
        Object billdateduring = params.get("billdateduring");
        try {
            billDateDuringCount = billdateduring != null ? Math.min(24, Integer.parseInt(billdateduring.toString())) : 6;
        }
        catch (Exception exception) {
            billDateDuringCount = 6;
            log.info("exception:{},message:{}", (Object)exception.getClass().getName(), (Object)String.valueOf(exception.getMessage()));
        }
        Date nowDate = TimeServiceHelper.today();
        LocalDate localDate = nowDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate billLocalDate = localDate.minusMonths(billDateDuringCount);
        LocalDateTime billLocalDateTime = billLocalDate.atTime(0, 0, 0);
        Date billDate = Date.from(billLocalDateTime.atZone(ZoneId.systemDefault()).toInstant());
        nowDate = DateUtil.addDays((Date)nowDate, (int)1);
        QFilter basicQFilter = new QFilter("materialentry.promisedate", "<", (Object)nowDate).and(new QFilter("billdate", ">=", (Object)billDate)).and(new QFilter("materialentry.promisestatus", "=", (Object)"B")).and(new QFilter("materialentry.entrystatus", "=", (Object)"A"));
        Object filterFieldParam = params.get("filterfield");
        if (filterFieldParam != null && !filterFieldParam.toString().trim().isEmpty()) {
            if ("sumoutstockqty".equals(filterFieldParam)) {
                basicQFilter.and(QFilter.of((String)"materialentry.sumoutstockqty < materialentry.promiseqty", (Object[])new Object[0]));
            } else if ("relateoutstockqty".equals(filterFieldParam)) {
                basicQFilter.and(QFilter.of((String)"materialentry.relateoutstockqty < materialentry.promiseqty", (Object[])new Object[0]));
            } else {
                basicQFilter.and(QFilter.of((String)"materialentry.sumoutstockqty < materialentry.promiseqty", (Object[])new Object[0]));
            }
        } else {
            basicQFilter.and(QFilter.of((String)"materialentry.sumoutstockqty < materialentry.promiseqty", (Object[])new Object[0]));
        }
        HashSet<Long> billIds = new HashSet<Long>(1024);
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        ListSelectedRow listSelectedRow = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"pur_deliveryschedule", (String)"id,materialentry.id entryid", (QFilter[])new QFilter[]{basicQFilter}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long billId = row.getLong("id");
                billIds.add(billId);
                listSelectedRow = new ListSelectedRow((Object)billId);
                listSelectedRow.setEntryEntityKey("materialentry");
                listSelectedRow.setEntryPrimaryKeyValue((Object)row.getLong("entryid"));
                listSelectedRows.add((Object)listSelectedRow);
            }
        }
        if (!billIds.isEmpty()) {
            Object operateKeyParam = params.get("operateKey");
            String operateKey = null;
            try {
                if (operateKeyParam != null && !operateKeyParam.toString().trim().isEmpty()) {
                    Map dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)"pur_deliveryschedule", (String)operateKeyParam.toString());
                    operateKey = !dataEntityOperate.isEmpty() ? String.valueOf(dataEntityOperate.get("key")) : DEFAULT_OPERATE_KEY;
                }
            }
            catch (RuntimeException runtimeException) {
                operateKey = DEFAULT_OPERATE_KEY;
                SRMStoreExceptionTraceHelper.saveWarnData((RuntimeException)runtimeException);
            }
            try {
                OperateOption operateOption = OperateOption.create();
                String str = SerializationUtils.toJsonString((Object)listSelectedRows);
                operateOption.setVariableValue("bos_listselectedrowcollection", str);
                OperationServiceHelper.executeOperate((String)operateKey, (String)"pur_deliveryschedule", (Object[])billIds.toArray(), (OperateOption)operateOption);
            }
            catch (RuntimeException runtimeException) {
                SRMStoreExceptionTraceHelper.saveWarnData((RuntimeException)runtimeException);
            }
        }
    }
}

