/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.scm.common.util.ScmcUtil;
import kd.scm.pur.api.PurWebApiService;
import kd.scm.pur.api.args.ApiArgs;

public class PurPushToPurReturnService
extends PurWebApiService {
    private static Log log = LogFactory.getLog(PurPushToPurReturnService.class);
    private static final String IM_PURINBILL = "im_purinbill";
    private static final String PUR_PURRETURN = "pur_return";
    private static final String IM_PURINBILL_ENTRY = "billentry";

    @Override
    protected void checkParam(ApiArgs apiArgs) {
        super.checkParam(apiArgs);
        Map<String, Object> param = apiArgs.getParam();
        Object data = param.get("data");
        if (null == data) {
            apiArgs.setCancel(true);
            apiArgs.setResult(ApiResult.fail((String)ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\u3002", (String)"PurPushToPurReturnService_0", (String)"scm-pur-webapi", (Object[])new Object[0])));
        }
    }

    @Override
    protected void doService(ApiArgs apiArgs) {
        super.doService(apiArgs);
        Map<String, Object> param = apiArgs.getParam();
        Object data = param.get("data");
        Map entityMap = null;
        HashMap<String, Map<String, Map<String, Object>>> entryDataMap = new HashMap<String, Map<String, Map<String, Object>>>(1024);
        List dataList = (List)data;
        for (Object object : dataList) {
            if (null == object) continue;
            entityMap = (Map)object;
            String id = String.valueOf(entityMap.get("id"));
            List entryList = (List)entityMap.get("entryentity");
            HashMap<String, Map> entryDetailMap = new HashMap<String, Map>();
            for (Object entry : entryList) {
                Map entryMap = (Map)entry;
                String entryId = String.valueOf(entryMap.get("entryid"));
                entryDetailMap.putIfAbsent(entryId, entryMap);
            }
            entryDataMap.put(id, entryDetailMap);
        }
        Object result = this.toPurPurReturn(entryDataMap);
        apiArgs.getResult().setMessage(String.valueOf(result));
    }

    private Object toPurPurReturn(Map<String, Map<String, Map<String, Object>>> entryDataMap) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(IM_PURINBILL);
        pushArgs.setTargetEntityNumber(PUR_PURRETURN);
        pushArgs.setBuildConvReport(true);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)PUR_PURRETURN);
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
            }
        };
        ArrayList pushedDataList = new ArrayList();
        StringBuilder msgSb = new StringBuilder();
        StringBuilder exceptionMessage = new StringBuilder();
        for (Map.Entry<String, Map<String, Map<String, Object>>> entryData : entryDataMap.entrySet()) {
            Map<String, Map<String, Object>> entryMap = entryData.getValue();
            ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(entryMap.size());
            for (Map.Entry<String, Map<String, Object>> entry : entryMap.entrySet()) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)entryData.getKey());
                row.setEntryEntityKey(IM_PURINBILL_ENTRY);
                row.setEntryPrimaryKeyValue((Object)entry.getKey());
                selectedRowList.add(row);
            }
            pushArgs.setSelectedRows(selectedRowList);
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (result.isSuccess()) {
                List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
                pushedDataList.addAll(targetData);
                result.release(refDataProvider, mainType);
                continue;
            }
            msgSb.append("id:").append(entryData.getKey()).append(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\u3002", (String)"PurPushToPurReturnService_1", (String)"scm-pur-webapi", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a", (String)"PurPushToPurReturnService_2", (String)"scm-pur-webapi", (Object[])new Object[0])).append(result.getMessage()).append("\u3002\n");
            exceptionMessage.append(ResManager.loadKDString((String)"@@@\u4f9b\u5e94\u94fe\u91c7\u8d2d\u9000\u8d27\u5355\u4e0b\u63a8\u534f\u540c\u91c7\u8d2d\u9000\u8d27\u5355\u5f02\u5e38\uff1a", (String)"PurPushToPurReturnService_3", (String)"scm-pur-webapi", (Object[])new Object[0])).append(result.getMessage());
        }
        if (log.isWarnEnabled()) {
            log.warn("exceptionMessage:{}", (Object)exceptionMessage);
        }
        if (pushedDataList.size() > 0) {
            String msg = ScmcUtil.dealConvertResult(pushedDataList, (String)PUR_PURRETURN, (boolean)true);
            msgSb.append("----").append(msg);
        }
        return msgSb.toString();
    }
}

