/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.container.GridContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.ORM;
import kd.bos.portal.constant.SchemeType;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AppHomepageUtil {
    public static final String CALLBACK_SHOWNEWCARDTYPEFORM = "CallBack_showAddCardForm";
    public static final String CALLBACK_GETSCHEME = "CallBack_getScheme";
    public static final String CACHE_CARDCONFIG = "cache_cardConfig";
    public static final String CACHE_ALLCARDCONFIG = "cache_allCardConfig";
    public static final String CACHE_CARDID_PAGEID_MAP = "cache_CardId_PageId_Map";
    public static final String CACHE_TEMPDEL = "cache_TempDel";
    public static final String CACHE_GRID_LAYOUT = "cache_grid_layout";
    public static final String FORM_NEWCARDTYPE = "bos_card_addnew";
    public static final String BTN_ADDCARD = "addCard";
    public static final String BTN_EDITEND = "editEnd";
    public static final String BTN_EDITCANCEL = "editCancel";
    public static final String BTN_DELETECARD = "deleteCard";
    public static final String CTRL_GRIDCONTAINER = "gridcontainerap";
    public static final String FLOATMENU_DESIGNMODE = "adjustlayout";
    public static final String FLOATMENU_RESET = "reset";
    public static final String FLOATMENU_SAVE_AS = "saveas";
    public static final String FLOATMENU_SWITCH = "switch";
    public static final String FLOATMENU_PANEL = "floatmenu";
    public static final String CONFIRMCALLBACKID_RESET = "confirm_reset";
    public static final String CONFIRMCALLBACKID_SET_DEFAULT = "confirm_setDefault";
    public static final String CONFIRMCALLBACKID_MODIFY_OR_NEWCUSTOM = "confirm_modifyOrNewCustom";
    public static final String PGCACHE_ISMAINPAGE = "IS_MainPage_Type";
    public static final String PGCACHE_ISCUSTOM_MAINPAGE = "pgCache_IsCustomMainPage";

    public static void refreshGridContainer(IFormView currView, IPageCache pageCache) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        DynamicObject schemeObj = AppHomepageUtil.getCurUserSuitableScheme(userId, currView, pageCache);
        AppHomepageUtil.refreshGridContainer(schemeObj, currView, pageCache);
    }

    public static void refreshGridContainer(DynamicObject schemeObj, IFormView currView, IPageCache pageCache) {
        String layout = null;
        if (schemeObj != null) {
            layout = schemeObj.getString("layout");
        }
        if (StringUtils.isEmpty(layout)) {
            return;
        }
        pageCache.put("pgCache_grid_layout", layout);
        Long schemeId = null;
        if (schemeObj != null) {
            schemeId = schemeObj.getLong("id");
        }
        if (schemeId == null) {
            return;
        }
        String schemeType = schemeObj.getString("schemetype");
        pageCache.put("pgCache_currentScheme", String.valueOf(schemeId));
        pageCache.put("pgCache_currentSchemeType", schemeType);
        AppHomepageUtil.showItemControl(Boolean.TRUE, currView, pageCache);
        DynamicObject[] arrDObj = CardUtils.loadAllMainPageCardConfig((Long)schemeId);
        HashMap<String, String> allCardConfig = new HashMap<String, String>();
        for (DynamicObject cardObj : arrDObj) {
            if (cardObj.getString("cardType").equals("bos_card_quicklaunch")) continue;
            String cardId = cardObj.getString("cardid");
            String configStr = cardObj.getString("config");
            configStr = CardUtils.convertToPureJson((String)configStr);
            Map configMap = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
            String mapEntryStr = "";
            String cardTitleInCfgStr = (String)configMap.get("cardtitle");
            if (StringUtils.isNotEmpty((CharSequence)cardTitleInCfgStr) && !"[]".equals(cardTitleInCfgStr)) {
                mapEntryStr = "[zh_CN=" + cardTitleInCfgStr + "]";
            } else {
                OrmLocaleValue ormLocaleValue = (OrmLocaleValue)cardObj.get("cardtitle");
                mapEntryStr = CardUtils.getMapEntryStrFromOrmLocaleValue((OrmLocaleValue)ormLocaleValue);
            }
            configMap.put("cardtitle", mapEntryStr);
            configStr = SerializationUtils.toJsonString((Object)configMap);
            allCardConfig.put(cardId, configStr);
        }
        AppHomepageUtil.showAllCardForm(allCardConfig, false, currView, pageCache);
    }

    public static void showAllCardForm(Map<String, String> allCardConfigMap, boolean ifDesignMode, IFormView currView, IPageCache pageCache) {
        for (Map.Entry<String, String> entry : allCardConfigMap.entrySet()) {
            String cardId = entry.getKey();
            String strConfigMap = entry.getValue();
            Map configMap = (Map)SerializationUtils.fromJsonString((String)strConfigMap, Map.class);
            String cardType = (String)configMap.get("cardType");
            FormShowParameter fsp = new FormShowParameter();
            fsp.setSendToClient(true);
            AppHomepageUtil.setFormId(fsp, configMap);
            AppHomepageUtil.setShowType(fsp, cardType, cardId, ifDesignMode);
            AppHomepageUtil.setCustomParam(fsp, cardType, configMap);
            currView.showForm(fsp);
        }
    }

    private static void setFormId(FormShowParameter fsp, Map<String, Object> pReturnMap) {
        String cardType = (String)pReturnMap.get("cardType");
        if (cardType.equals("bos_card_custom")) {
            String formNum = (String)pReturnMap.get("cardformnum");
            fsp.setFormId(formNum);
        } else {
            fsp.setFormId(cardType);
        }
    }

    private static String setShowType(FormShowParameter fsp, String cardType, String pNewCardIndex, boolean ifDesignMode) {
        HashMap custParam = fsp.getOpenStyle().getCustParam();
        if (custParam == null) {
            custParam = new HashMap();
            fsp.getOpenStyle().setCustParam(custParam);
        }
        String strNewCardIndex = pNewCardIndex;
        switch (cardType) {
            case "bos_card_billstatsconfig": 
            case "bos_card_workflowconfig": 
            case "bos_card_qingconfig": 
            case "bos_card_custom_config": 
            case "bos_card_yzjconifg": {
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCloseCallBack(null);
                break;
            }
            case "bos_card_custom": 
            case "bos_card_quicklaunch": 
            case "bos_card_billstats": 
            case "bos_card_billstats_list": 
            case "bos_card_workflow": 
            case "bos_card_msgcenter": 
            case "bos_card_qing": 
            case "bos_card_yzj_subscribe": {
                fsp.getOpenStyle().setShowType(ShowType.InContainer);
                if (strNewCardIndex == null) {
                    strNewCardIndex = AppHomepageUtil.getNewCardIndex();
                }
                fsp.getOpenStyle().setTargetKey(CTRL_GRIDCONTAINER);
                fsp.getOpenStyle().getCustParam().put("cardId", strNewCardIndex);
                String strIfDesignMode = null;
                strIfDesignMode = ifDesignMode ? "1" : "0";
                fsp.getOpenStyle().getCustParam().put("ifDesignMode", strIfDesignMode);
                break;
            }
        }
        return strNewCardIndex;
    }

    private static void setCustomParam(FormShowParameter fsp, String cardType, Map<String, Object> pReturnMap) {
        switch (cardType) {
            case "bos_card_quicklaunch": {
                fsp.getOpenStyle().getCustParam().put("cardRefresh", "false");
            }
        }
    }

    private static String getNewCardIndex() {
        long lNewCardId = ORM.create().genLongId("bos_mainpagecardconfig");
        String newCardId = String.valueOf(lNewCardId);
        return newCardId;
    }

    public void resetGridContainerLayout(String layout, IFormView currView, PageCache pageCache) {
        GridContainer gc = (GridContainer)currView.getControl(CTRL_GRIDCONTAINER);
        gc.reset(layout);
    }

    public static void showItemControl(Boolean isShowChangeDesignItem, IFormView currView, IPageCache pageCache) {
        currView.setVisible(isShowChangeDesignItem, new String[]{FLOATMENU_DESIGNMODE});
        String schemeType = pageCache.get("pgCache_currentSchemeType");
        if (SchemeType.UserScheme.getValue().equals(schemeType)) {
            currView.setVisible(Boolean.TRUE, new String[]{FLOATMENU_RESET});
        } else {
            currView.setVisible(Boolean.FALSE, new String[]{FLOATMENU_RESET});
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        boolean hasRight = CardUtils.checkHasModifySchemeRight((Long)userId);
        currView.setVisible(Boolean.valueOf(isShowChangeDesignItem == false && hasRight), new String[]{FLOATMENU_SAVE_AS});
        currView.setVisible(Boolean.TRUE, new String[]{FLOATMENU_SWITCH});
    }

    public Map<String, String> getCardPageMap(IFormView currView, PageCache pageCache) {
        HashMap<String, String> result = null;
        String cardPageMapStr = pageCache.get(CACHE_CARDID_PAGEID_MAP);
        if (StringUtils.isEmpty((CharSequence)cardPageMapStr)) {
            result = new HashMap();
            pageCache.put(CACHE_CARDID_PAGEID_MAP, SerializationUtils.toJsonString(result));
        } else {
            result = (Map)SerializationUtils.fromJsonString((String)cardPageMapStr, Map.class);
        }
        return result;
    }

    public static void setCardPageMap(Map<String, String> pCardPageMap, IPageCache pageCache) {
        pageCache.put(CACHE_CARDID_PAGEID_MAP, SerializationUtils.toJsonString(pCardPageMap));
    }

    private static DynamicObject getCurUserSuitableScheme(Long userId, IFormView currView, IPageCache pageCache) {
        DynamicObject schemeObj = null;
        String selFields = "id,layout,schemetype";
        boolean isMainPage = CardUtils.isMainPage((IFormView)currView);
        pageCache.put(PGCACHE_ISMAINPAGE, Boolean.toString(isMainPage));
        String strSchemeId = pageCache.get("pgCache_currentScheme");
        if (StringUtils.isNotEmpty((CharSequence)strSchemeId)) {
            return BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(strSchemeId), (String)"portal_scheme", (String)selFields);
        }
        schemeObj = CardUtils.loadScheme((SchemeType)SchemeType.UserScheme, (Long)userId, (String)selFields, (boolean)isMainPage, (IFormView)currView);
        if (schemeObj != null) {
            return schemeObj;
        }
        Long schemeId = CardUtils.getGroupSchemeId((Long)userId, (IFormView)currView);
        if (schemeId != null) {
            return BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"portal_scheme", (String)selFields);
        }
        schemeObj = CardUtils.loadScheme((SchemeType)SchemeType.SysDefScheme, (Long)userId, (String)selFields, (boolean)isMainPage, (IFormView)currView);
        return schemeObj;
    }

    public static Map<String, String> getCardPageMap(IPageCache pageCache) {
        HashMap<String, String> result = null;
        String cardPageMapStr = pageCache.get(CACHE_CARDID_PAGEID_MAP);
        if (StringUtils.isEmpty((CharSequence)cardPageMapStr)) {
            result = new HashMap();
            pageCache.put(CACHE_CARDID_PAGEID_MAP, SerializationUtils.toJsonString(result));
        } else {
            result = (Map)SerializationUtils.fromJsonString((String)cardPageMapStr, Map.class);
        }
        return result;
    }
}

