/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.common;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.SupBidStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.CommonUtil;

public class QuoBidBillUtil {
    public static Map<String, Object> verifyJoinBidHall(DynamicObject bidBillObj) {
        String bidStatus;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("succed", "true");
        if (!QuoBidBillUtil.checkUserIsEnroll(bidBillObj)) {
            returnMap.put("message", ResManager.loadKDString((String)"\u60a8\u672a\u62a5\u540d\uff0c\u65e0\u6cd5\u8fdb\u5165\u7ade\u4ef7\u5927\u5385\u3002", (String)"QuoBidBillUtil_0", (String)"scm-quo-common", (Object[])new Object[0]));
            returnMap.put("succed", "false");
        }
        if (!QuoBidBillUtil.isQualify(bidBillObj)) {
            returnMap.put("message", ResManager.loadKDString((String)"\u8d44\u5ba1\u672a\u901a\u8fc7\u65e0\u6cd5\u8fdb\u5165\u7ade\u4ef7\u5927\u5385\u3002", (String)"QuoBidBillUtil_1", (String)"scm-quo-common", (Object[])new Object[0]));
            returnMap.put("succed", "false");
            return returnMap;
        }
        if (!QuoBidBillUtil.checkIsRecDeposit(bidBillObj)) {
            returnMap.put("message", ResManager.loadKDString((String)"\u5f88\u9057\u61be\uff0c\u672a\u7f34\u7eb3\u4fdd\u8bc1\u91d1\u65e0\u6cd5\u8fdb\u5165\u7ade\u4ef7\u5927\u5385\u3002", (String)"QuoBidBillUtil_2", (String)"scm-quo-common", (Object[])new Object[0]));
            returnMap.put("succed", "false");
        }
        if ((bidStatus = bidBillObj.getString("bidstatus")).equals(BidStatusEnum.ENROLMENT.getVal()) || bidStatus.equals(BidStatusEnum.BEENEXAMINED.getVal()) || bidStatus.equals(BidStatusEnum.DEADLINE.getVal())) {
            returnMap.put("message", ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u62a5\u540d\u4e2d\uff0c\u62a5\u540d\u622a\u6b62\u6216\u5df2\u8d44\u5ba1\u65f6\uff0c\u65e0\u6cd5\u8fdb\u5165\u7ade\u4ef7\u5927\u5385\u3002", (String)"QuoBidBillUtil_3", (String)"scm-quo-common", (Object[])new Object[0]));
            returnMap.put("succed", "false");
        }
        return returnMap;
    }

    private static boolean checkIsRecDeposit(DynamicObject bidBillObj) {
        Object suppaydate;
        BigDecimal cashDeposit = CommonUtil.getBigDecimalPro((Object)bidBillObj.get("cashdeposit"));
        if (cashDeposit.compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        DynamicObject currUserQuoSupEntry = QuoBidBillUtil.getCurrUserQuoSupEntry(bidBillObj.getDynamicObjectCollection("supquoentry"));
        return currUserQuoSupEntry == null || (suppaydate = currUserQuoSupEntry.get("suppaydate")) != null;
    }

    private static boolean isQualify(DynamicObject bidBillObj) {
        Object supEntryStatus;
        String checkType = bidBillObj.getString("checktype");
        if (checkType != null && "3".equals(checkType)) {
            return true;
        }
        DynamicObject currUserQuoSupEntry = QuoBidBillUtil.getCurrUserQuoSupEntry(bidBillObj.getDynamicObjectCollection("supquoentry"));
        return currUserQuoSupEntry == null || (supEntryStatus = currUserQuoSupEntry.get("supentrystatus")) == null || !supEntryStatus.equals(SupBidStatusEnum.HAVEREFUSED.getVal());
    }

    public static boolean checkUserIsEnroll(DynamicObject bidBillObj) {
        DynamicObjectCollection cols = bidBillObj.getDynamicObjectCollection("supquoentry");
        DynamicObject currUserQuoSupEntry = QuoBidBillUtil.getCurrUserQuoSupEntry(cols);
        return currUserQuoSupEntry != null;
    }

    public static DynamicObject getCurrUserQuoSupEntry(DynamicObjectCollection objs) {
        List suppliers = BizPartnerUtil.getSupplierByUserOfBizPartner();
        for (DynamicObject col : objs) {
            DynamicObject supEnroll = col.getDynamicObject("supenroll");
            DynamicObject entrysupplier = col.getDynamicObject("entrysupplier");
            if (entrysupplier == null || supEnroll == null || suppliers == null || !suppliers.contains(Long.parseLong(entrysupplier.getPkValue().toString()))) continue;
            return col;
        }
        return null;
    }
}

