/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.enums.SupInquiryStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.InquirySupParticipateUtils;

public class QuoCommonUtil {
    public static void setBidbillStatus(DynamicObjectCollection rows) {
        HashMap myStatus = new HashMap();
        List supplierIds = BizPartnerUtil.getSupplierByUserOfBizPartner();
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (DynamicObject row2 : rows) {
            billIds.add(row2.getLong("id"));
        }
        QFilter filter = new QFilter("id", "in", billIds).and("supquoentry.entrysupplier", "in", (Object)supplierIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"QuoBidListDataProvider", (String)"quo_bidbill", (String)"id,cashdeposit,checktype,supquoentry.supentrystatus,supquoentry.supenroll,supquoentry.suppaydate,quoentry.id", (QFilter[])new QFilter[]{filter}, (String)"supquoentry.supentrystatus desc");){
            dataSet.forEach(row -> myStatus.put(row.getString("id"), row.getString("supquoentry.supentrystatus")));
        }
        for (DynamicObject row3 : rows) {
            String status = (String)myStatus.get(row3.getString("id"));
            String bidStatus = row3.getString("bidstatus");
            if (status == null || status.trim().equals("")) {
                if (bidStatus.equals(BidStatusEnum.ENROLMENT.getVal())) {
                    Date enrolldate = row3.getDate("enrolldate");
                    if (enrolldate != null && enrolldate.before(TimeServiceHelper.now())) {
                        row3.set("supplierstatus", (Object)"Z");
                        continue;
                    }
                    row3.set("supplierstatus", (Object)"Y");
                    continue;
                }
                row3.set("supplierstatus", (Object)"Z");
                continue;
            }
            row3.set("supplierstatus", (Object)status);
        }
    }

    public static boolean isCashdeposit(DynamicObject obj) {
        DynamicObjectCollection cols = obj.getDynamicObjectCollection("supquoentry");
        for (DynamicObject col : cols) {
            Object suppaydate;
            DynamicObject supEnroll = col.getDynamicObject("supenroll");
            if (supEnroll == null || !supEnroll.getPkValue().toString().equals(String.valueOf(RequestContext.get().getUserId())) || (suppaydate = col.get("suppaydate")) != null) continue;
            return false;
        }
        return true;
    }

    public static void getBidMyStatusIds(DynamicObjectCollection rows, Set<Long> ids1, Set<Long> ids2, Set<Long> ids3) {
        if (rows != null && rows.size() > 0) {
            for (DynamicObject row : rows) {
                String bidStatus = row.getString("bidstatus");
                String supStatus = row.getString("supplierstatus");
                if (StringUtils.equals((CharSequence)bidStatus, (CharSequence)"A") && StringUtils.equals((CharSequence)supStatus, (CharSequence)"Y")) {
                    ids1.add(row.getLong("id"));
                    continue;
                }
                if (StringUtils.equals((CharSequence)bidStatus, (CharSequence)"C") && (StringUtils.equals((CharSequence)supStatus, (CharSequence)"B") || StringUtils.equals((CharSequence)supStatus, (CharSequence)"D"))) {
                    ids2.add(row.getLong("id"));
                    continue;
                }
                if (!StringUtils.equals((CharSequence)bidStatus, (CharSequence)"E") || !StringUtils.equals((CharSequence)supStatus, (CharSequence)"F")) continue;
                ids3.add(row.getLong("id"));
            }
        }
    }

    public static void setInquiryStatus(DynamicObjectCollection rows) {
        List supplierIds = BizPartnerUtil.getSupplierByUserOfBizPartner();
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (DynamicObject row2 : rows) {
            billIds.add(row2.getLong("id"));
        }
        QFilter filter = new QFilter("id", "in", billIds).and("entryentity.supplier", "in", (Object)supplierIds);
        HashMap<String, Map<String, Object>> supplierInfoMap = new HashMap<String, Map<String, Object>>(billIds.size());
        Map<String, Date> turnsLogMap = null;
        ArrayList<String> supstatus = new ArrayList<String>();
        supstatus.add("C");
        supstatus.add("D");
        supstatus.add("E");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"QuoInquiryListDataProvider", (String)"quo_inquiry", (String)"id,entryentity.supplier,entryentity.supentrystatus,entryentity.entryturns,entryentity.entrycount,entryentity.deadline,entryentity.supplierbizstatus", (QFilter[])new QFilter[]{filter}, (String)"entryentity.deadline desc");){
            dataSet.forEach(row -> {
                HashMap<String, Object> infoMap = (HashMap<String, Object>)supplierInfoMap.get(row.getString("id"));
                String supentrystatus = row.getString("entryentity.supentrystatus");
                if (infoMap == null) {
                    infoMap = new HashMap<String, Object>();
                    infoMap.put("supplierbizstatus", row.getString("entryentity.supplierbizstatus"));
                    infoMap.put("entrycount", row.getString("entryentity.entrycount"));
                    infoMap.put("deadline", row.getDate("entryentity.deadline"));
                    infoMap.put("supentrystatus", supentrystatus);
                    infoMap.put("supplierId", row.getString("entryentity.supplier"));
                    supplierInfoMap.put(row.getString("id"), infoMap);
                }
                if (supstatus.contains(supentrystatus) && infoMap != null) {
                    infoMap.put("supentrystatus", supentrystatus);
                }
            });
        }
        turnsLogMap = QuoCommonUtil.getTurnsInfo(billIds);
        for (DynamicObject row3 : rows) {
            QuoCommonUtil.setSupplierExtendInfo(supplierInfoMap, turnsLogMap, row3);
        }
    }

    private static Map<String, Date> getTurnsInfo(List<Long> billIds) {
        HashMap<String, Date> turnsLogMap = new HashMap<String, Date>(billIds.size());
        QFilter filter = new QFilter("id", "in", billIds).and("entrylog.turns_log", "=", (Object)"1");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"QuoInquiryListDataProvider", (String)"quo_inquiry", (String)"id,entrylog.logdeadline", (QFilter[])new QFilter[]{filter}, null);){
            dataSet.forEach(row -> turnsLogMap.put(row.getString("id"), row.getDate("entrylog.logdeadline")));
        }
        return turnsLogMap;
    }

    private static void setSupplierExtendInfo(Map<String, Map<String, Object>> supplierInfoMap, Map<String, Date> turnsLogMap, DynamicObject row) {
        Map<String, Object> supplierInfo = supplierInfoMap.get(row.getString("id"));
        HashMap<String, String> paramMap = new HashMap<String, String>(3);
        paramMap.put("supplierProStatus", "supplierprostatus");
        paramMap.put("supplierstatus", "supplierstatus");
        paramMap.put("bizstatus", row.getString("bizstatus"));
        if (supplierInfo != null && supplierInfo.get("supplierId") != null) {
            String supplierbizstatus = (String)supplierInfo.get("supplierbizstatus");
            String status = (String)supplierInfo.get("supentrystatus");
            paramMap.put("supplierbizstatus", supplierbizstatus);
            paramMap.put("status", status);
            Date deadLine = (Date)supplierInfo.get("deadline");
            QuoCommonUtil.setInquirySupplierProStatus(paramMap, deadLine, row);
            row.set("turns", StringUtils.isBlank((Object)supplierInfo.get("entrycount")) ? "1" : supplierInfo.get("entrycount"));
            if (deadLine != null) {
                row.set("enddate", (Object)deadLine);
            }
        } else {
            Date date = null;
            if (turnsLogMap != null && turnsLogMap.size() > 0 && turnsLogMap.get(row.getString("id")) != null) {
                date = turnsLogMap.get(row.getString("id"));
                row.set("enddate", (Object)date);
            } else {
                date = row.getDate("enddate");
            }
            QuoCommonUtil.setInquirySupplierProStatus(paramMap, date, row);
            if (!"1".equals(row.getString("turns"))) {
                row.set("supplierProStatus", (Object)SupInquiryStatusEnum.PARTICALADOPTION.getVal());
                row.set("supplierstatus", (Object)"Z");
            }
            if (BizStatusEnum.END.getVal().equals(row.getString("bizstatus"))) {
                row.set("supplierProStatus", (Object)BizStatusEnum.END.getVal());
            }
            row.set("turns", (Object)"1");
        }
    }

    public static void setInquirySupplierProStatus(Map<String, String> paramMap, Date deadLine, DynamicObject row) {
        if (paramMap != null) {
            String supplierbizstatus = paramMap.get("supplierbizstatus");
            String bizstatus = paramMap.get("bizstatus");
            String status = paramMap.get("status");
            String supplierProStatus = paramMap.get("supplierProStatus");
            String supplierstatus = paramMap.get("supplierstatus");
            InquirySupParticipateUtils.setSupProStatus((DynamicObject)row, (Date)deadLine, (String)supplierProStatus, (String)supplierbizstatus);
            if (status == null || status.trim().equals("")) {
                if ("A".equals(bizstatus)) {
                    if (deadLine != null && deadLine.before(TimeServiceHelper.now())) {
                        row.set(supplierstatus, (Object)"Z");
                    } else {
                        row.set(supplierstatus, (Object)"Y");
                    }
                } else {
                    row.set(supplierstatus, (Object)"Z");
                }
            } else {
                row.set(supplierstatus, (Object)status);
            }
        }
    }

    public static void getInqMyStatusIds(DynamicObjectCollection rows, Set<Long> ids1, Set<Long> ids2, Set<Long> ids3) {
        if (rows != null && rows.size() > 0) {
            for (DynamicObject row : rows) {
                String bizStatus = row.getString("bizstatus");
                String supplierProStatus = row.getString("supplierprostatus");
                String supStatus = row.getString("supplierstatus");
                if (StringUtils.equals((CharSequence)bizStatus, (CharSequence)"A") && StringUtils.equals((CharSequence)supStatus, (CharSequence)"Y") && StringUtils.equals((CharSequence)supplierProStatus, (CharSequence)"A")) {
                    ids1.add(row.getLong("id"));
                    continue;
                }
                if (StringUtils.equals((CharSequence)bizStatus, (CharSequence)"B") && StringUtils.equals((CharSequence)supStatus, (CharSequence)"B") && StringUtils.equals((CharSequence)supplierProStatus, (CharSequence)"B")) {
                    ids2.add(row.getLong("id"));
                    continue;
                }
                if (!StringUtils.equals((CharSequence)bizStatus, (CharSequence)"C") || !StringUtils.equals((CharSequence)supStatus, (CharSequence)"C") && !StringUtils.equals((CharSequence)supStatus, (CharSequence)"D")) continue;
                ids3.add(row.getLong("id"));
            }
        }
    }

    public static void getAutoFillNoMap(Map<String, String> autoBillNoMap, DynamicObject bill) {
        if (autoBillNoMap == null || bill == null) {
            return;
        }
        if (bill.getBoolean("isautofillprice")) {
            autoBillNoMap.put(bill.getString("billno"), "1");
        } else {
            DynamicObjectCollection materialentry = bill.getDynamicObjectCollection("materialentry");
            String turns = bill.getString("turns");
            DynamicObject dynamicObject = materialentry.stream().filter(info -> StringUtils.equals((CharSequence)turns, (CharSequence)info.getString("newestturns"))).findAny().orElse(null);
            if (dynamicObject != null) {
                autoBillNoMap.put(bill.getString("billno"), "0");
            }
        }
    }
}

