/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.enums.SupInquiryStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.InquirySupParticipateUtils;
import kd.scm.common.util.InquiryUtil;
import kd.scm.quo.common.ext.imp.DefaultQuoInquiryVerify;
import kd.sdk.scm.quo.extpoint.IQuoInquiryVerify;

public final class QuoInquiryUtil {
    private static Log log = LogFactory.getLog((String)"QuoInquiryUtil");

    public static Map<String, Object> verifyUnquote(DynamicObject inquiryBill) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("succed", "true");
        boolean flag = true;
        String errorInfo = null;
        DynamicObject quoSupEntry = QuoInquiryUtil.getQuoMaxEntry(inquiryBill);
        if (quoSupEntry != null) {
            String supEntryStatus = quoSupEntry.getString("supentrystatus");
            if (supEntryStatus.equals(SupInquiryStatusEnum.NOTQUOTEDPRICE.getVal())) {
                flag = false;
                errorInfo = ResManager.loadKDString((String)"\u60a8\u5df2\u505a\u4e0d\u62a5\u4ef7\u5904\u7406,\u65e0\u9700\u91cd\u590d\u5904\u7406\u3002", (String)"QuoInquiryUtil_2", (String)"scm-quo-common", (Object[])new Object[0]);
            }
            Object enddate = quoSupEntry.get("deadline");
            if (TimeServiceHelper.now().after((Date)enddate) && flag) {
                flag = false;
                errorInfo = ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65e5\u671f\u5df2\u8fc7,\u4e0d\u80fd\u505a\u4e0d\u62a5\u4ef7\u5904\u7406\u3002", (String)"QuoInquiryUtil_0", (String)"scm-quo-common", (Object[])new Object[0]);
            }
        } else if (quoSupEntry == null && flag && !"1".equals(inquiryBill.getString("turns"))) {
            flag = false;
            errorInfo = ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65e5\u671f\u5df2\u8fc7,\u4e0d\u80fd\u505a\u4e0d\u62a5\u4ef7\u5904\u7406\u3002", (String)"QuoInquiryUtil_0", (String)"scm-quo-common", (Object[])new Object[0]);
        }
        if (flag && QuoInquiryUtil.hasQuotedInCurrTurns(inquiryBill)) {
            flag = false;
            errorInfo = ResManager.loadKDString((String)"\u5df2\u6709\u62a5\u4ef7\u5355,\u4e0d\u80fd\u505a\u4e0d\u62a5\u4ef7\u5904\u7406\u3002", (String)"QuoInquiryUtil_8", (String)"scm-quo-common", (Object[])new Object[0]);
        }
        Date endDate = inquiryBill.getDate("enddate");
        if (flag && !TimeServiceHelper.now().before(endDate)) {
            flag = false;
            errorInfo = ResManager.loadKDString((String)"\u62a5\u4ef7\u622a\u6b62\u65e5\u671f\u5df2\u8fc7,\u4e0d\u80fd\u505a\u4e0d\u62a5\u4ef7\u5904\u7406\u3002", (String)"QuoInquiryUtil_0", (String)"scm-quo-common", (Object[])new Object[0]);
        }
        String bizStatus = inquiryBill.getString("bizstatus");
        if (flag && !bizStatus.equals(BizStatusEnum.ENROLMENT.getVal())) {
            flag = false;
            errorInfo = ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e0d\u5728\u62a5\u4ef7\u4e2d,\u4e0d\u80fd\u505a\u4e0d\u62a5\u4ef7\u5904\u7406\u3002", (String)"QuoInquiryUtil_1", (String)"scm-quo-common", (Object[])new Object[0]);
        }
        returnMap.put("succed", String.valueOf(flag));
        returnMap.put("message", errorInfo);
        return returnMap;
    }

    public static boolean hasQuotedInCurrTurns(DynamicObject inquiryBill) {
        QFilter inquiryBillNofilter = new QFilter("inquiryno", "=", (Object)inquiryBill.getString("billno"));
        QFilter turnsFilter = new QFilter("turns", "=", (Object)inquiryBill.getString("turns"));
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        QFilter entrystatusFilter = new QFilter("materialentry.entrystatus", "=", (Object)"A");
        QFilter supplierFilter = new QFilter("supplier", "in", (Object)BizPartnerUtil.getSupplierByUserOfBizPartner());
        QFilter[] filters = new QFilter[]{inquiryBillNofilter, turnsFilter, statusFilter, supplierFilter, entrystatusFilter};
        boolean[] flag = new boolean[]{false};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"QuoInquiryUtil", (String)"quo_quote", (String)"id,supplier,billno,billstatus", (QFilter[])filters, (String)"");){
            ds.forEach(row -> {
                flag[0] = true;
            });
        }
        return flag[0];
    }

    public static Map<String, Object> verifyQuote(DynamicObject inquiryBill) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        DefaultQuoInquiryVerify plugin = new DefaultQuoInquiryVerify();
        PluginProxy pluginProxy = PluginProxy.create((Object)plugin, IQuoInquiryVerify.class, (String)"SCM_QUO_INQUIRYQUOTE_VERIFY", null);
        pluginProxy.callReplaceIfPresent(p -> {
            p.verifyQuote(returnMap, inquiryBill);
            return null;
        });
        return returnMap;
    }

    public static Map<String, Object> verifyQuote(DynamicObject inquiryBill, List<Long> supplierIds) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        DefaultQuoInquiryVerify plugin = new DefaultQuoInquiryVerify();
        PluginProxy pluginProxy = PluginProxy.create((Object)plugin, IQuoInquiryVerify.class, (String)"SCM_QUO_INQUIRYQUOTE_VERIFY", null);
        pluginProxy.callReplaceIfPresent(p -> {
            p.verifyQuote(returnMap, inquiryBill, supplierIds);
            return null;
        });
        return returnMap;
    }

    private static boolean checkSupplierQuo(DynamicObject inquiryBill) {
        DynamicObjectCollection cols = inquiryBill.getDynamicObjectCollection("entryentity");
        List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        boolean isQuote = false;
        for (DynamicObject col : cols) {
            Long id;
            DynamicObject supplier = col.getDynamicObject("supplier");
            if (null == supplier || !supIdList.contains(id = (Long)supplier.getPkValue()) || null == col.getDate("quotedate")) continue;
            isQuote = true;
            break;
        }
        return isQuote;
    }

    public static DynamicObject getCurrUserQuoSupEntry(DynamicObject inquiryBill) {
        DynamicObjectCollection cols = inquiryBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject col : cols) {
            List userIds;
            DynamicObject supplier = col.getDynamicObject("supplier");
            if (supplier == null || !InquirySupParticipateUtils.isShowSelect((DynamicObject)col) || !(userIds = BizPartnerUtil.getSupplierByUserOfBizPartner()).contains(supplier.getLong("id"))) continue;
            return col;
        }
        return null;
    }

    private static DynamicObject getQuoMaxEntry(DynamicObject inquiryBill) {
        DefaultQuoInquiryVerify verify = new DefaultQuoInquiryVerify();
        return verify.getQuoMaxEntry(inquiryBill);
    }

    public static void confirmUnquote(DynamicObject inquiryBill) {
        if (inquiryBill != null) {
            DynamicObject[] quoteBills;
            List supplierList = BizPartnerUtil.getSupplierByUserOfBizPartner();
            if (supplierList.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u901a\u8fc7\u4f9b\u5e94\u5546\u7528\u6237\u627e\u4e0d\u5230\u5bf9\u5e94\u4f9b\u5e94\u5546\u3002", (String)"QuoInquiryUtil_9", (String)"scm-quo-common", (Object[])new Object[0]));
            }
            String supscope = inquiryBill.getString("supscope");
            DynamicObjectCollection cols = inquiryBill.getDynamicObjectCollection("entryentity");
            if ("2".equals(supscope)) {
                for (DynamicObject[] row : cols) {
                    if (!InquirySupParticipateUtils.isShowSelect((DynamicObject)row) || !supplierList.contains(row.getLong("supplier_id"))) continue;
                    QuoInquiryUtil.setUnquoteInfo((DynamicObject)row);
                }
            } else {
                DynamicObject quoSupEntry = QuoInquiryUtil.getCurrUserQuoSupEntry(inquiryBill);
                if (quoSupEntry == null) {
                    quoSupEntry = cols.addNew();
                    quoSupEntry.set("supplier", supplierList.get(0));
                    quoSupEntry.set("entryturns", (Object)inquiryBill.getString("turns"));
                    InquirySupParticipateUtils.setSupEntryDeadLine((DynamicObject)quoSupEntry, (Date)inquiryBill.getDate("enddate"));
                    quoSupEntry.set("entrycount", (Object)"1");
                }
                QuoInquiryUtil.setUnquoteInfo(quoSupEntry);
            }
            for (DynamicObject quoteBill : quoteBills = QuoInquiryUtil.getQuoteBillByCurrSupAndBillno(inquiryBill.getString("billno"), supplierList)) {
                DynamicObjectCollection materialentrys = quoteBill.getDynamicObjectCollection("materialentry");
                for (DynamicObject entry : materialentrys) {
                    entry.set("entrystatus", (Object)"B");
                }
            }
            SaveServiceHelper.save((DynamicObject[])quoteBills);
            ArrayList<String> inquiryBillNoList = new ArrayList<String>();
            inquiryBillNoList.add(inquiryBill.getString("billno"));
            InquiryUtil.updateInquiryQuoResult((DynamicObject[])new DynamicObject[]{inquiryBill}, inquiryBillNoList);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inquiryBill});
        }
    }

    public static DynamicObject[] getQuoteBillByCurrSupAndBillno(String billno, List<Long> supplierList) {
        if (!supplierList.isEmpty()) {
            QFilter inquirynoFilter = new QFilter("inquiryno", "=", (Object)billno);
            QFilter supplierFilter = new QFilter("supplier", "in", supplierList);
            QFilter entrystatusFilter = new QFilter("materialentry.entrystatus", "=", (Object)"A");
            return BusinessDataServiceHelper.load((String)"quo_quote", (String)"id,billno,materialentry.entrystatus", (QFilter[])new QFilter[]{inquirynoFilter, supplierFilter, entrystatusFilter});
        }
        return new DynamicObject[0];
    }

    private static void setUnquoteInfo(DynamicObject quoSupEntry) {
        quoSupEntry.set("quoter", (Object)RequestContext.get().getUserId());
        quoSupEntry.set("quotedate", (Object)TimeServiceHelper.now());
        quoSupEntry.set("supentrystatus", (Object)SupInquiryStatusEnum.NOTQUOTEDPRICE.getVal());
        InquirySupParticipateUtils.setSupProjectStatus((DynamicObject)quoSupEntry, (BizStatusEnum)BizStatusEnum.CONFIRMED);
        quoSupEntry.set("canshow", (Object)Boolean.FALSE);
    }
}

